/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc.admin;

import java.util.Iterator;
import java.util.Map;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.wc.SVNTreeConflictUtil;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea;
import org.tmatesoft.svn.core.wc.SVNRevision;

public class SVNEntry {
    private Map myAttributes;
    private SVNAdminArea myAdminArea;
    private String myName;
    static /* synthetic */ Class class$org$tmatesoft$svn$core$internal$wc$admin$SVNEntry;

    public SVNEntry(Map attributes, SVNAdminArea adminArea, String name) {
        this.myAttributes = attributes;
        this.myName = name;
        this.myAdminArea = adminArea;
        if (!this.myAttributes.containsKey("svn:entry:name")) {
            this.myAttributes.put("svn:entry:name", name);
        }
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != (class$org$tmatesoft$svn$core$internal$wc$admin$SVNEntry == null ? (class$org$tmatesoft$svn$core$internal$wc$admin$SVNEntry = SVNEntry.class$("org.tmatesoft.svn.core.internal.wc.admin.SVNEntry")) : class$org$tmatesoft$svn$core$internal$wc$admin$SVNEntry)) {
            return false;
        }
        SVNEntry entry = (SVNEntry)obj;
        return entry.myAttributes == this.myAttributes && entry.myName.equals(this.myName);
    }

    public int hashCode() {
        return ((Object)this.myAttributes).hashCode() + 17 * this.myName.hashCode();
    }

    public boolean isThisDir() {
        if (this.myAdminArea != null) {
            return this.myAdminArea.getThisDirName().equals(this.getName());
        }
        return "".equals(this.getName());
    }

    public String getURL() {
        return (String)this.myAttributes.get("svn:entry:url");
    }

    public SVNURL getSVNURL() throws SVNException {
        String url = this.getURL();
        if (url != null) {
            return SVNURL.parseURIEncoded(url);
        }
        return null;
    }

    public String getName() {
        return this.myName;
    }

    public boolean isDirectory() {
        return "dir".equals(this.myAttributes.get("svn:entry:kind"));
    }

    public long getRevision() {
        String revStr = (String)this.myAttributes.get("svn:entry:revision");
        if (revStr != null) {
            try {
                return Long.parseLong(revStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1L;
    }

    public boolean isScheduledForAddition() {
        return "add".equals(this.myAttributes.get("svn:entry:schedule"));
    }

    public boolean isScheduledForDeletion() {
        return "delete".equals(this.myAttributes.get("svn:entry:schedule"));
    }

    public boolean isScheduledForReplacement() {
        return "replace".equals(this.myAttributes.get("svn:entry:schedule"));
    }

    public boolean isHidden() {
        return this.isDeleted() && !this.isScheduledForAddition() && !this.isScheduledForReplacement() || this.isAbsent() || this.getDepth() == SVNDepth.EXCLUDE;
    }

    public boolean isFile() {
        return "file".equals(this.myAttributes.get("svn:entry:kind"));
    }

    public String getLockToken() {
        return (String)this.myAttributes.get("svn:entry:lock-token");
    }

    public boolean isDeleted() {
        return Boolean.TRUE.toString().equals(this.myAttributes.get("svn:entry:deleted"));
    }

    public boolean isAbsent() {
        return Boolean.TRUE.toString().equals(this.myAttributes.get("svn:entry:absent"));
    }

    public String toString() {
        return this.myName;
    }

    private boolean setAttributeValue(String name, String value) {
        if (value == null) {
            return this.myAttributes.remove(name) != null;
        }
        String oldValue = this.myAttributes.put(name, value);
        return !value.equals(oldValue);
    }

    public boolean setRevision(long revision) {
        return this.setAttributeValue("svn:entry:revision", Long.toString(revision));
    }

    public boolean setChangelistName(String changelistName) {
        return this.setAttributeValue("svn:entry:changelist", changelistName);
    }

    public String getChangelistName() {
        return (String)this.myAttributes.get("svn:entry:changelist");
    }

    public boolean setWorkingSize(long size) {
        if (this.getKind() == SVNNodeKind.FILE) {
            return this.setAttributeValue("svn:entry:working-size", Long.toString(size));
        }
        return false;
    }

    public long getWorkingSize() {
        String workingSize = (String)this.myAttributes.get("svn:entry:working-size");
        if (workingSize == null) {
            return -1L;
        }
        try {
            return Long.parseLong(workingSize);
        }
        catch (NumberFormatException nfe) {
            return -1L;
        }
    }

    public SVNDepth getDepth() {
        String depthString = (String)this.myAttributes.get("svn:entry:depth");
        return SVNDepth.fromString(depthString);
    }

    public void setDepth(SVNDepth depth) {
        this.setAttributeValue("svn:entry:depth", depth.getName());
    }

    public boolean setURL(String url) {
        return this.setAttributeValue("svn:entry:url", url);
    }

    public void setIncomplete(boolean incomplete) {
        this.setAttributeValue("svn:entry:incomplete", incomplete ? Boolean.TRUE.toString() : null);
    }

    public boolean isIncomplete() {
        return Boolean.TRUE.toString().equals(this.myAttributes.get("svn:entry:incomplete"));
    }

    public String getConflictOld() {
        return (String)this.myAttributes.get("svn:entry:conflict-old");
    }

    public void setConflictOld(String name) {
        this.setAttributeValue("svn:entry:conflict-old", name);
    }

    public String getConflictNew() {
        return (String)this.myAttributes.get("svn:entry:conflict-new");
    }

    public void setConflictNew(String name) {
        this.setAttributeValue("svn:entry:conflict-new", name);
    }

    public String getConflictWorking() {
        return (String)this.myAttributes.get("svn:entry:conflict-wrk");
    }

    public void setConflictWorking(String name) {
        this.setAttributeValue("svn:entry:conflict-wrk", name);
    }

    public String getPropRejectFile() {
        return (String)this.myAttributes.get("svn:entry:prop-reject-file");
    }

    public void setPropRejectFile(String name) {
        this.setAttributeValue("svn:entry:prop-reject-file", name);
    }

    public String getAuthor() {
        return (String)this.myAttributes.get("svn:entry:last-author");
    }

    public String getCommittedDate() {
        return (String)this.myAttributes.get("svn:entry:committed-date");
    }

    public long getCommittedRevision() {
        String rev = (String)this.myAttributes.get("svn:entry:committed-rev");
        if (rev == null) {
            return -1L;
        }
        try {
            return Long.parseLong(rev);
        }
        catch (NumberFormatException nfe) {
            return -1L;
        }
    }

    public void setTextTime(String time) {
        this.setAttributeValue("svn:entry:text-time", time);
    }

    public void setKind(SVNNodeKind kind) {
        String kindStr = kind == SVNNodeKind.DIR ? "dir" : (kind == SVNNodeKind.FILE ? "file" : null);
        this.setAttributeValue("svn:entry:kind", kindStr);
    }

    public void setAbsent(boolean absent) {
        this.setAttributeValue("svn:entry:absent", absent ? Boolean.TRUE.toString() : null);
    }

    public void setDeleted(boolean deleted) {
        this.setAttributeValue("svn:entry:deleted", deleted ? Boolean.TRUE.toString() : null);
    }

    public SVNNodeKind getKind() {
        String kind = (String)this.myAttributes.get("svn:entry:kind");
        if ("dir".equals(kind)) {
            return SVNNodeKind.DIR;
        }
        if ("file".equals(kind)) {
            return SVNNodeKind.FILE;
        }
        return SVNNodeKind.UNKNOWN;
    }

    public String getTextTime() {
        return (String)this.myAttributes.get("svn:entry:text-time");
    }

    public String getChecksum() {
        return (String)this.myAttributes.get("svn:entry:checksum");
    }

    public void setLockComment(String comment) {
        this.myAttributes.put("svn:entry:lock-comment", comment);
    }

    public void setLockOwner(String owner) {
        this.setAttributeValue("svn:entry:lock-owner", owner);
    }

    public void setLockCreationDate(String date) {
        this.setAttributeValue("svn:entry:lock-creation-date", date);
    }

    public void setLockToken(String token) {
        this.setAttributeValue("svn:entry:lock-token", token);
    }

    public void setUUID(String uuid) {
        this.setAttributeValue("svn:entry:uuid", uuid);
    }

    public void unschedule() {
        this.setAttributeValue("svn:entry:schedule", null);
    }

    public void scheduleForAddition() {
        this.setAttributeValue("svn:entry:schedule", "add");
    }

    public void scheduleForDeletion() {
        this.setAttributeValue("svn:entry:schedule", "delete");
    }

    public void scheduleForReplacement() {
        this.setAttributeValue("svn:entry:schedule", "replace");
    }

    public void setSchedule(String schedule) {
        this.setAttributeValue("svn:entry:schedule", schedule);
    }

    public void setCopyFromRevision(long revision) {
        this.setAttributeValue("svn:entry:copyfrom-rev", revision >= 0L ? Long.toString(revision) : null);
    }

    public boolean setCopyFromURL(String url) {
        return this.setAttributeValue("svn:entry:copyfrom-url", url);
    }

    public void setCopied(boolean copied) {
        this.setAttributeValue("svn:entry:copied", copied ? Boolean.TRUE.toString() : null);
    }

    public String getCopyFromURL() {
        return (String)this.myAttributes.get("svn:entry:copyfrom-url");
    }

    public SVNURL getCopyFromSVNURL() throws SVNException {
        String url = this.getCopyFromURL();
        if (url != null) {
            return SVNURL.parseURIEncoded(url);
        }
        return null;
    }

    public long getCopyFromRevision() {
        String rev = (String)this.myAttributes.get("svn:entry:copyfrom-rev");
        if (rev == null) {
            return -1L;
        }
        try {
            return Long.parseLong(rev);
        }
        catch (NumberFormatException nfe) {
            return -1L;
        }
    }

    public String getPropTime() {
        return (String)this.myAttributes.get("svn:entry:prop-time");
    }

    public void setPropTime(String time) {
        this.setAttributeValue("svn:entry:prop-time", time);
    }

    public boolean isCopied() {
        return Boolean.TRUE.toString().equals(this.myAttributes.get("svn:entry:copied"));
    }

    public String getUUID() {
        return (String)this.myAttributes.get("svn:entry:uuid");
    }

    public String getRepositoryRoot() {
        return (String)this.myAttributes.get("svn:entry:repos");
    }

    public SVNURL getRepositoryRootURL() throws SVNException {
        String url = this.getRepositoryRoot();
        if (url != null) {
            return SVNURL.parseURIEncoded(url);
        }
        return null;
    }

    public boolean setRepositoryRoot(String url) {
        return this.setAttributeValue("svn:entry:repos", url);
    }

    public boolean setRepositoryRootURL(SVNURL url) {
        return this.setRepositoryRoot(url == null ? null : url.toString());
    }

    public void loadProperties(Map entryProps) {
        if (entryProps == null) {
            return;
        }
        Iterator propNames = entryProps.keySet().iterator();
        while (propNames.hasNext()) {
            String propName = (String)propNames.next();
            this.setAttributeValue(propName, (String)entryProps.get(propName));
        }
    }

    public String getLockOwner() {
        return (String)this.myAttributes.get("svn:entry:lock-owner");
    }

    public String getLockComment() {
        return (String)this.myAttributes.get("svn:entry:lock-comment");
    }

    public String getLockCreationDate() {
        return (String)this.myAttributes.get("svn:entry:lock-creation-date");
    }

    public String getSchedule() {
        return (String)this.myAttributes.get("svn:entry:schedule");
    }

    public void setCachableProperties(String[] cachableProps) {
        if (cachableProps != null) {
            this.myAttributes.put("svn:entry:cachable-props", cachableProps);
        } else {
            this.myAttributes.remove("svn:entry:cachable-props");
        }
    }

    public void setKeepLocal(boolean keepLocal) {
        this.setAttributeValue("svn:entry:keep-local", keepLocal ? Boolean.TRUE.toString() : null);
    }

    public boolean isKeepLocal() {
        return Boolean.TRUE.toString().equals(this.myAttributes.get("svn:entry:keep-local"));
    }

    public String[] getCachableProperties() {
        return (String[])this.myAttributes.get("svn:entry:cachable-props");
    }

    public String[] getPresentProperties() {
        return (String[])this.myAttributes.get("svn:entry:present-props");
    }

    public String getExternalFilePath() {
        return (String)this.myAttributes.get("svn:entry:file-external-path");
    }

    public SVNRevision getExternalFileRevision() {
        SVNRevision revision = (SVNRevision)this.myAttributes.get("svn:entry:file-external-revision");
        return revision;
    }

    public SVNRevision getExternalFilePegRevision() {
        SVNRevision pegRevision = (SVNRevision)this.myAttributes.get("svn:entry:file-external-peg-revision");
        return pegRevision;
    }

    public String getTreeConflictData() {
        return (String)this.myAttributes.get("svn:entry:tree-conflicts");
    }

    public Map getTreeConflicts() throws SVNException {
        String conflictData = this.getTreeConflictData();
        return SVNTreeConflictUtil.readTreeConflicts(this.getAdminArea().getRoot(), conflictData);
    }

    public void setTreeConflictData(String conflictData) {
        this.setAttributeValue("svn:entry:tree-conflicts", conflictData);
    }

    public void setTreeConflicts(Map treeConflicts) throws SVNException {
        String conflictData = SVNTreeConflictUtil.getTreeConflictData(treeConflicts);
        this.setTreeConflictData(conflictData);
    }

    public Map asMap() {
        return this.myAttributes;
    }

    public SVNAdminArea getAdminArea() {
        return this.myAdminArea;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

