/*
Copyright (C) 2000-2010  Ministere de la culture et de la communication (France), AJLSM
See LICENCE file
*/
package fr.gouv.culture.sdx.document;

import fr.gouv.culture.sdx.exception.SDXException;

import java.io.File;
import java.net.URL;


public class BinaryDocument extends AbstractDocument {

    /**Le document XML auquel il est rattache. */
//	 FIXME : private object never used locally [MP]
    private String parentDocId;

    /** L'identificateur de ce document attache. */
//  FIXME : private object never used locally [MP]
    private String docId;

    /** Le nom de fichier dont il s'agit. */
//  FIXME : private object never used locally [MP]
    private String filename;

    /** L'URL ou l'on trouve les donnees */
//  FIXME : private object never used locally [MP]
    private URL sourceUrl;

    /** L'URL relative ou l'on trouve les donnees */
//  FIXME : private object never used locally [MP]
    private String relativeUrl;

    /** La source de donnees. */
//  FIXME : private object never used locally [MP]
    private File dataSource;

    /** Le document lui-meme */
//  FIXME : private object never used locally [MP]
    private byte[] data;

    /** La longueur du contenu */
//  FIXME : private object never used locally [MP]
    private int length = -1;
    /** String representation of the default mimetype for our attached documents. */
    public static final String DEFAULT_MIMETYPE = "application/octet-stream";

    /**Gets the docType for the document*/
    public String getDocType() {
        return Document.DOCTYPE_BINARY;
    }

    /**Convenience constructor for document deletion*/
    public BinaryDocument() {
    }

    /** Builds a Binary document and set's the necessary fields
     *
     * @param docId     The document id
     * @param url       The url of this document
     * @param mimetype  The mimetype String
     * @throws SDXException
     */
    public BinaryDocument(String docId, URL url, String mimetype) throws SDXException {
        setId(docId);
        //setting the document mimetype
        setMimeType(mimetype);
        // set content
        setContent(url);
    }

}
