/*
Copyright (C) 2000-2010  Ministere de la culture et de la communication (France), AJLSM
See LICENCE file
*/
package fr.gouv.culture.sdx.oai;

import fr.gouv.culture.oai.OAIObject;
import fr.gouv.culture.oai.OAIRepository;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.context.Contextualizable;

public interface DocumentBaseOAIRepository extends OAIRepository, Serviceable, Contextualizable {
	interface ConfigurationNode {
		/*Configuration node names*/
		String ADMIN_EMAIL = OAIObject.Node.Name.ADMIN_EMAIL;
		String NAME = "name";
		String BASE_URL = OAIObject.Node.Name.BASE_URL;
		String ID = "id";
		String EXT_OAI_ID_PREFIX = "oai-id-prefix";
		String DEFAULT_OAI_REPOSITORY = "default"; 
		String QUERY = "query";
		String NO_PER_RESPONSE = "noPerResponse";
		String OAI_SETS = "oai-sets";
		String OAI_SET = "oai-set";
		String SPEC = "spec";
		/**String representation of the "description" attribute name "src". */
		String SRC = "src";
		String DESCRIPTION = OAIObject.Node.Name.DESCRIPTION;
	}
}
