/*
Copyright (C) 2000-2010  Ministere de la culture et de la communication (France), AJLSM
See LICENCE file
*/
package fr.gouv.culture.sdx.resolver.entity;

import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.exception.SDXExceptionCode;
import org.apache.cocoon.components.resolver.DefaultResolver;
//import org.apache.excalibur.xml.DefaultEntityResolver;

import java.io.IOException;
import java.net.URL;

/**A simple extension of Cocoon's ResolverImpl which facilitates the addition of
 * entity catlogs files based upon configuration data from our application.xconf files.
 * The current usage of this class in the code specifies that these catalogs will
 * only be added if and only if the cocoon.xconf is changed  to specify our this
 * resolver with the role set to the value of ROLE in
 * org.apache.avalon.excalibur.xml.EntityResolver from and we can acquire
 * this resolver from Cocoon's component manager based upon that role.
 */
public class SDXResolver extends DefaultResolver{

	public SDXResolver() {
		super();
	}

    /**Adds a Entity Catalog to the CatalogResolver
     *
     * <p>This catalog should be in one of the formats supported by
     * org.apache.xml.resolver.tools.CatalogResolver
     *
     * @param url   The url of the catalog to add
     * @throws SDXException
     */
    public void addCatalog(URL url) throws SDXException {
        try {
            super.catalogResolver.getCatalog().parseCatalog(url.toExternalForm());
        } catch (IOException e) {
            String[] args = new String[2];
            args[0] = url.toExternalForm();
            args[1] = e.getMessage();
            throw new SDXException(super.getLogger(), SDXExceptionCode.ERROR_ENTITY_CATALOG_ADD, args, e);
        }
    }

}
