/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModelStatus;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.jdom.DOMFactory;
import org.eclipse.jdt.core.jdom.IDOMImport;
import org.eclipse.jdt.core.jdom.IDOMNode;
import org.eclipse.jdt.internal.core.CreateElementInCUOperation;
import org.eclipse.jdt.internal.core.JavaModelStatus;
import org.eclipse.jdt.internal.core.util.Util;

public class CreateImportOperation
extends CreateElementInCUOperation {
    protected String fImportName;

    public CreateImportOperation(String importName, ICompilationUnit parentElement) {
        super(parentElement);
        this.fImportName = importName;
    }

    protected IDOMNode generateElementDOM() {
        if (this.fCUDOM.getChild(this.fImportName) == null) {
            DOMFactory factory = new DOMFactory();
            IDOMImport imp = factory.createImport();
            imp.setName(this.fImportName);
            return imp;
        }
        this.fCreationOccurred = false;
        return null;
    }

    protected IJavaElement generateResultHandle() {
        return this.getCompilationUnit().getImport(this.fImportName);
    }

    public String getMainTaskName() {
        return Util.bind("operation.createImportsProgress");
    }

    protected void initializeDefaultPosition() {
        try {
            ICompilationUnit cu = this.getCompilationUnit();
            IImportDeclaration[] imports = cu.getImports();
            if (imports.length > 0) {
                this.createAfter(imports[imports.length - 1]);
                return;
            }
            IType[] types = cu.getTypes();
            if (types.length > 0) {
                this.createBefore(types[0]);
                return;
            }
            IJavaElement[] children = cu.getChildren();
            int i = 0;
            while (i < children.length) {
                if (children[i].getElementType() == 11) {
                    this.createAfter(children[i]);
                    return;
                }
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {}
    }

    public IJavaModelStatus verify() {
        IJavaModelStatus status = super.verify();
        if (!status.isOK()) {
            return status;
        }
        if (JavaConventions.validateImportDeclaration(this.fImportName).getSeverity() == 4) {
            return new JavaModelStatus(983, this.fImportName);
        }
        return JavaModelStatus.VERIFIED_OK;
    }
}

