/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.elementprocessor.impl.poi.hssf.elements;

import java.io.IOException;
import org.apache.cocoon.components.elementprocessor.impl.poi.hssf.elements.BaseElementProcessor;
import org.apache.cocoon.components.elementprocessor.impl.poi.hssf.elements.BorderStyle;
import org.apache.cocoon.components.elementprocessor.impl.poi.hssf.elements.ColorCode;
import org.apache.cocoon.components.elementprocessor.types.NumericConverter;
import org.apache.cocoon.components.elementprocessor.types.NumericResult;
import org.apache.cocoon.components.elementprocessor.types.Validator;

public class EPDiagonal
extends BaseElementProcessor {
    private NumericResult _style = null;
    private boolean _color_fetched = false;
    private ColorCode _color = null;
    private static final String _style_attribute = "Style";
    private static final String _color_attribute = "Color";
    private static final Validator _style_validator = new Validator(){

        public IOException validate(Number number) {
            return BorderStyle.isValid(number.intValue()) ? null : new IOException("\"" + number + "\" is not a legal value");
        }
    };

    public EPDiagonal() {
        super(null);
    }

    public int getStyle() throws IOException {
        if (this._style == null) {
            this._style = NumericConverter.extractInteger(this.getValue(_style_attribute), _style_validator);
        }
        return this._style.intValue();
    }

    public ColorCode getColor() throws IOException {
        if (!this._color_fetched) {
            String colorString = this.getValue(_color_attribute);
            if (colorString != null) {
                this._color = new ColorCode(colorString);
            }
            this._color_fetched = true;
        }
        return this._color;
    }
}

