/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient.cookie;

import org.apache.commons.httpclient.cookie.CookieSpec;
import org.apache.commons.httpclient.cookie.CookieSpecBase;
import org.apache.commons.httpclient.cookie.NetscapeDraftSpec;
import org.apache.commons.httpclient.cookie.RFC2109Spec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class CookiePolicy {
    private static final String SYSTEM_PROPERTY = "apache.commons.httpclient.cookiespec";
    public static final int COMPATIBILITY = 0;
    public static final int NETSCAPE_DRAFT = 1;
    public static final int RFC2109 = 2;
    private static int defaultPolicy = 2;
    protected static final Log LOG = LogFactory.getLog((Class)(class$org$apache$commons$httpclient$cookie$CookiePolicy == null ? (class$org$apache$commons$httpclient$cookie$CookiePolicy = CookiePolicy.class$("org.apache.commons.httpclient.cookie.CookiePolicy")) : class$org$apache$commons$httpclient$cookie$CookiePolicy));
    static /* synthetic */ Class class$org$apache$commons$httpclient$cookie$CookiePolicy;

    public static int getDefaultPolicy() {
        return defaultPolicy;
    }

    public static void setDefaultPolicy(int policy) {
        defaultPolicy = policy;
    }

    public static CookieSpec getSpecByPolicy(int policy) {
        switch (policy) {
            case 0: {
                return new CookieSpecBase();
            }
            case 1: {
                return new NetscapeDraftSpec();
            }
            case 2: {
                return new RFC2109Spec();
            }
        }
        return CookiePolicy.getSpecByPolicy(defaultPolicy);
    }

    public static CookieSpec getDefaultSpec() {
        return CookiePolicy.getSpecByPolicy(defaultPolicy);
    }

    public static CookieSpec getSpecByVersion(int ver) {
        switch (ver) {
            case 0: {
                return new NetscapeDraftSpec();
            }
            case 1: {
                return new RFC2109Spec();
            }
        }
        return CookiePolicy.getDefaultSpec();
    }

    public static CookieSpec getCompatibilitySpec() {
        return CookiePolicy.getSpecByPolicy(0);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        String s = null;
        try {
            s = System.getProperty(SYSTEM_PROPERTY);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if ("COMPATIBILITY".equalsIgnoreCase(s)) {
            CookiePolicy.setDefaultPolicy(0);
        } else if ("NETSCAPE_DRAFT".equalsIgnoreCase(s)) {
            CookiePolicy.setDefaultPolicy(1);
        } else if ("RFC2109".equalsIgnoreCase(s)) {
            CookiePolicy.setDefaultPolicy(2);
        } else {
            if (s != null) {
                LOG.warn((Object)("Unrecognized cookiespec property '" + s + "' - using default"));
            }
            CookiePolicy.setDefaultPolicy(defaultPolicy);
        }
    }
}

