/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.treeprocessor.variables;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.ServiceSelector;
import org.apache.avalon.framework.service.WrapperServiceManager;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.components.modules.input.InputModule;
import org.apache.cocoon.components.treeprocessor.InvokeContext;
import org.apache.cocoon.components.treeprocessor.variables.VariableExpressionTokenizer;
import org.apache.cocoon.components.treeprocessor.variables.VariableResolver;
import org.apache.cocoon.sitemap.PatternException;
import org.apache.commons.lang.builder.HashCodeBuilder;

public final class PreparedVariableResolver
extends VariableResolver
implements Disposable {
    private ServiceManager manager;
    private ServiceSelector selector;
    protected List tokens;
    protected boolean needsMapStack;
    private static final int OPEN = -2;
    private static final int CLOSE = -3;
    private static final int COLON = -4;
    private static final int TEXT = -5;
    private static final int EXPR = -7;
    private static final int SITEMAP_VAR = -9;
    private static final int THREADSAFE_MODULE = -10;
    private static final int STATEFUL_MODULE = -11;
    private static final int ROOT_SITEMAP_VARIABLE = 0;
    private static final int ANCHOR_VAR = -1;
    private static Token COLON_TOKEN = new Token(-4);
    private static Token OPEN_TOKEN = new Token(-2);
    private static Token CLOSE_TOKEN = new Token(-3);
    private static Token EMPTY_TOKEN = new Token(-7);

    public PreparedVariableResolver(String expr, ComponentManager manager) throws PatternException {
        this(expr, (ServiceManager)new WrapperServiceManager(manager));
    }

    public PreparedVariableResolver(String expr, ServiceManager manager) throws PatternException {
        super(expr);
        this.manager = manager;
        this.tokens = new ArrayList();
        VariableExpressionTokenizer.tokenize(expr, new VariableExpressionTokenizer.TokenReciever(){

            public void addToken(int type, String value) throws PatternException {
                switch (type) {
                    case -4: {
                        PreparedVariableResolver.this.tokens.add(COLON_TOKEN);
                        break;
                    }
                    case -2: {
                        PreparedVariableResolver.this.tokens.add(OPEN_TOKEN);
                        break;
                    }
                    case -3: {
                        PreparedVariableResolver.this.tokens.add(CLOSE_TOKEN);
                        break;
                    }
                    case -5: {
                        PreparedVariableResolver.this.tokens.add(new Token(value));
                        break;
                    }
                    case -6: {
                        Token token;
                        if (value.equals("sitemap")) {
                            PreparedVariableResolver.this.needsMapStack = true;
                            token = new Token(-9);
                        } else if (value.startsWith("#")) {
                            PreparedVariableResolver.this.needsMapStack = true;
                            token = new Token(-1, value.substring(1));
                        } else {
                            token = PreparedVariableResolver.this.getNewModuleToken(value);
                        }
                        PreparedVariableResolver.this.tokens.add(token);
                        break;
                    }
                    case -8: {
                        PreparedVariableResolver.this.needsMapStack = true;
                        PreparedVariableResolver.this.tokens.add(PreparedVariableResolver.this.getNewVariableToken(value));
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown token type: " + type);
                    }
                }
            }
        });
    }

    private Token getNewVariableToken(String variable) {
        if (variable.startsWith("/")) {
            return new Token(0, variable.substring(1));
        }
        int level = 1;
        int pos = 0;
        while (variable.startsWith("../", pos)) {
            ++level;
            pos += "../".length();
        }
        return new Token(level, variable.substring(pos));
    }

    private Token getNewModuleToken(String moduleName) throws PatternException {
        Token token;
        InputModule module;
        if (this.selector == null) {
            try {
                this.selector = (ServiceSelector)this.manager.lookup(InputModule.ROLE + "Selector");
            }
            catch (ServiceException ce) {
                throw new PatternException("Cannot access input modules selector", ce);
            }
        }
        try {
            module = (InputModule)this.selector.select((Object)moduleName);
        }
        catch (ServiceException e) {
            throw new PatternException("Cannot get module named '" + moduleName + "' in expression '" + this.originalExpr + "'", e);
        }
        if (module instanceof ThreadSafe) {
            token = new Token(-10, module);
        } else {
            this.selector.release((Object)module);
            token = new Token(-11, moduleName);
        }
        return token;
    }

    public final String resolve(InvokeContext context, Map objectModel) throws PatternException {
        List mapStack = null;
        int stackSize = 0;
        if (this.needsMapStack) {
            if (context == null) {
                throw new PatternException("Need an invoke context to resolve " + this);
            }
            mapStack = context.getMapStack();
            stackSize = mapStack.size();
        }
        Stack<Token> stack = new Stack<Token>();
        Iterator i = this.tokens.iterator();
        block4: while (i.hasNext()) {
            Token token = (Token)i.next();
            switch (token.getType()) {
                case -5: {
                    if (stack.empty()) {
                        stack.push(new Token(-7, token.getStringValue()));
                        continue block4;
                    }
                    Token last = (Token)stack.peek();
                    if (last.hasType(-7)) {
                        last.merge(token);
                        continue block4;
                    }
                    stack.push(new Token(-7, token.getStringValue()));
                    continue block4;
                }
                case -3: {
                    Token result;
                    Token expr = (Token)stack.pop();
                    Token lastButOne = (Token)stack.pop();
                    if (expr.hasType(-4)) {
                        stack.pop();
                        result = this.processModule(lastButOne, EMPTY_TOKEN, objectModel, context, mapStack, stackSize);
                    } else if (lastButOne.hasType(-4)) {
                        Token module = (Token)stack.pop();
                        stack.pop();
                        result = this.processModule(module, expr, objectModel, context, mapStack, stackSize);
                    } else {
                        result = this.processVariable(expr, mapStack, stackSize);
                    }
                    if (stack.empty()) {
                        stack.push(result);
                        continue block4;
                    }
                    Token last = (Token)stack.peek();
                    if (last.hasType(-7)) {
                        last.merge(result);
                        continue block4;
                    }
                    stack.push(result);
                    continue block4;
                }
            }
            stack.push(token);
        }
        if (stack.size() != 1) {
            throw new PatternException("Evaluation error in expression: " + this.originalExpr);
        }
        return ((Token)stack.pop()).getStringValue();
    }

    private Token processModule(Token module, Token expr, Map objectModel, InvokeContext context, List mapStack, int stackSize) throws PatternException {
        int type = module.getType();
        if (type == -1) {
            Map levelResult = context.getMapByAnchor(module.getStringValue());
            if (levelResult == null) {
                throw new PatternException("Error while evaluating '" + this.originalExpr + "' : no anchor '" + String.valueOf(module.getStringValue()) + "' found in context");
            }
            Object result = levelResult.get(expr.getStringValue());
            return new Token(-7, result == null ? "" : result.toString());
        }
        if (type == -10) {
            try {
                InputModule im = module.getModule();
                Object result = im.getAttribute(expr.getStringValue(), null, objectModel);
                return new Token(-7, result == null ? "" : result.toString());
            }
            catch (ConfigurationException confEx) {
                throw new PatternException("Cannot get variable '" + expr.getStringValue() + "' in expression '" + this.originalExpr + "'", confEx);
            }
        }
        if (type == -11) {
            InputModule im = null;
            String moduleName = module.getStringValue();
            try {
                im = (InputModule)this.selector.select((Object)moduleName);
                Object result = im.getAttribute(expr.getStringValue(), null, objectModel);
                Token token = new Token(-7, result == null ? "" : result.toString());
                return token;
            }
            catch (ServiceException e) {
                throw new PatternException("Cannot get module '" + moduleName + "' in expression '" + this.originalExpr + "'", e);
            }
            catch (ConfigurationException confEx) {
                throw new PatternException("Cannot get variable '" + expr.getStringValue() + "' in expression '" + this.originalExpr + "'", confEx);
            }
            finally {
                this.selector.release((Object)im);
            }
        }
        if (type == -9) {
            Token token;
            String variable = expr.getStringValue();
            if (variable.startsWith("/")) {
                token = new Token(0, variable.substring(1));
            } else {
                int level = 1;
                int pos = 0;
                while (variable.startsWith("../", pos)) {
                    ++level;
                    pos += "../".length();
                }
                token = new Token(level, variable.substring(pos));
            }
            return this.processVariable(token, mapStack, stackSize);
        }
        throw new PatternException("Unknown token type: " + expr.getType());
    }

    private Token processVariable(Token expr, List mapStack, int stackSize) throws PatternException {
        int type = expr.getType();
        String value = expr.getStringValue();
        if (type == 0) {
            Object result = ((Map)mapStack.get(0)).get(value);
            return new Token(-7, result == null ? "" : result.toString());
        }
        if (type > stackSize) {
            throw new PatternException("Error while evaluating '" + this.originalExpr + "' : not so many levels");
        }
        Object result = ((Map)mapStack.get(stackSize - type)).get(value);
        return new Token(-7, result == null ? "" : result.toString());
    }

    public final void dispose() {
        if (this.selector != null) {
            Iterator i = this.tokens.iterator();
            while (i.hasNext()) {
                Token token = (Token)i.next();
                if (!token.hasType(-10)) continue;
                InputModule im = token.getModule();
                this.selector.release((Object)im);
            }
            this.manager.release((Object)this.selector);
            this.selector = null;
            this.manager = null;
        }
    }

    private static class Token {
        private Object value;
        private int type;

        public Token(int type) {
            this.value = type == -7 ? "" : null;
            this.type = type;
        }

        public Token(int type, String value) {
            this.value = value;
            this.type = type;
        }

        public Token(int type, InputModule module) {
            this.value = module;
            this.type = type;
        }

        public Token(String value) {
            this.type = -5;
            this.value = value;
        }

        public int getType() {
            return this.type;
        }

        public String getStringValue() {
            if (this.value instanceof String) {
                return (String)this.value;
            }
            return null;
        }

        public boolean hasType(int type) {
            return this.type == type;
        }

        public boolean equals(Object o) {
            if (o instanceof Token) {
                return ((Token)o).hasType(this.type);
            }
            return false;
        }

        public int hashCode() {
            return new HashCodeBuilder().append(this.value).append(this.type).toHashCode();
        }

        public void merge(Token newToken) {
            this.value = this.value + newToken.getStringValue();
        }

        public InputModule getModule() {
            if (this.value instanceof InputModule) {
                return (InputModule)this.value;
            }
            return null;
        }
    }
}

