/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.portal.coplets.basket;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.wrapper.RequestParameters;
import org.apache.cocoon.portal.PortalService;
import org.apache.cocoon.portal.coplets.basket.AddItemEvent;
import org.apache.cocoon.portal.coplets.basket.ContentItem;
import org.apache.cocoon.portal.coplets.basket.UploadItemEvent;
import org.apache.cocoon.transformation.AbstractSAXTransformer;
import org.apache.cocoon.xml.AttributesImpl;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class BasketTransformer
extends AbstractSAXTransformer {
    public static final String NAMESPACE_URI = "http://apache.org/cocoon/portal/basket/1.0";
    protected static final String ADD_ITEM_ELEMENT = "add-item";
    protected static final String UPLOAD_ITEM_ELEMENT = "upload-item";
    protected static final String UPLOAD_FORM_ELEMENT = "upload-form";
    protected List uploadElements = new ArrayList();

    public BasketTransformer() {
        this.namespaceURI = NAMESPACE_URI;
    }

    public void recycle() {
        super.recycle();
        this.uploadElements.clear();
    }

    public void endTransformingElement(String uri, String name, String raw) throws ProcessingException, IOException, SAXException {
        if (ADD_ITEM_ELEMENT.equals(name)) {
            this.endElement("", "a", "a");
        } else if (UPLOAD_ITEM_ELEMENT.equals(name)) {
            this.endElement("", "input", "input");
        } else if (UPLOAD_FORM_ELEMENT.equals(name)) {
            this.endElement("", "form", "form");
            this.uploadElements = new ArrayList();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void startTransformingElement(String uri, String name, String raw, Attributes attr) throws ProcessingException, IOException, SAXException {
        String parameters;
        if (ADD_ITEM_ELEMENT.equals(name)) {
            String value = attr.getValue("content");
            boolean addContent = false;
            if (value != null) {
                addContent = new Boolean(value);
            }
            String href = attr.getValue("href");
            PortalService service = null;
            try {
                try {
                    service = (PortalService)this.manager.lookup(PortalService.ROLE);
                    ContentItem ci = new ContentItem(href, addContent);
                    AddItemEvent e = new AddItemEvent(ci);
                    AttributesImpl ai = new AttributesImpl();
                    ai.addCDATAAttribute("href", service.getComponentManager().getLinkService().getLinkURI(e));
                    this.startElement("", "a", "a", (Attributes)ai);
                }
                catch (ServiceException se) {
                    throw new SAXException("Unable to lookup portal service.", (Exception)((Object)se));
                }
                Object var13_22 = null;
            }
            catch (Throwable throwable) {
                Object var13_23 = null;
                this.manager.release((Object)service);
                throw throwable;
            }
            this.manager.release((Object)service);
            return;
        }
        if (UPLOAD_ITEM_ELEMENT.equals(name)) {
            this.uploadElements.add(attr.getValue("name"));
            this.startElement("", "input", "input", attr);
            return;
        }
        if (!UPLOAD_FORM_ELEMENT.equals(name)) return;
        AttributesImpl ai = new AttributesImpl(attr);
        PortalService service = null;
        try {
            try {
                service = (PortalService)this.manager.lookup(PortalService.ROLE);
                UploadItemEvent e = new UploadItemEvent(this.uploadElements);
                parameters = service.getComponentManager().getLinkService().getLinkURI(e);
                int pos = parameters.indexOf(63);
                ai.addCDATAAttribute("action", parameters.substring(0, pos));
                parameters = parameters.substring(pos + 1);
            }
            catch (ServiceException se) {
                throw new SAXException("Unable to lookup portal service.", (Exception)((Object)se));
            }
            Object var15_26 = null;
        }
        catch (Throwable throwable) {
            Object var15_27 = null;
            this.manager.release((Object)service);
            throw throwable;
        }
        this.manager.release((Object)service);
        this.startElement("", "form", "form", (Attributes)ai);
        if (parameters == null) return;
        if (parameters.length() <= 0) return;
        RequestParameters pars = new RequestParameters(parameters);
        Enumeration enumeration = pars.getParameterNames();
        while (enumeration.hasMoreElements()) {
            String pName = (String)enumeration.nextElement();
            String pValue = pars.getParameter(pName);
            AttributesImpl hiddenAttrs = new AttributesImpl();
            hiddenAttrs.addCDATAAttribute("type", "hidden");
            hiddenAttrs.addCDATAAttribute("name", pName);
            hiddenAttrs.addCDATAAttribute("value", pValue);
            this.startElement("", "input", "input", (Attributes)hiddenAttrs);
            this.endElement("", "input", "input");
        }
        return;
    }
}

