/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.portal.layout.renderer.aspect.impl;

import org.apache.cocoon.portal.PortalService;
import org.apache.cocoon.portal.coplet.CopletInstanceData;
import org.apache.cocoon.portal.coplet.status.SizingStatus;
import org.apache.cocoon.portal.event.impl.ChangeCopletInstanceAspectDataEvent;
import org.apache.cocoon.portal.layout.Layout;
import org.apache.cocoon.portal.layout.impl.CopletLayout;
import org.apache.cocoon.portal.layout.renderer.aspect.RendererAspectContext;
import org.apache.cocoon.portal.layout.renderer.aspect.impl.AbstractAspect;
import org.apache.cocoon.xml.XMLUtils;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class SizingAspect
extends AbstractAspect {
    public void toSAX(RendererAspectContext context, Layout layout, PortalService service, ContentHandler handler) throws SAXException {
        CopletInstanceData cid = ((CopletLayout)layout).getCopletInstanceData();
        boolean showContent = true;
        boolean sizable = (Boolean)cid.getCopletData().getAspectData("sizable");
        Integer size = null;
        if (sizable) {
            ChangeCopletInstanceAspectDataEvent event;
            size = (Integer)cid.getAspectData("size");
            if (size == null) {
                size = SizingStatus.STATUS_MAXIMIZED;
            }
            if (size.equals(SizingStatus.STATUS_MAXIMIZED)) {
                event = new ChangeCopletInstanceAspectDataEvent(cid, "size", (Object)SizingStatus.STATUS_MINIMIZED);
                XMLUtils.createElement((ContentHandler)handler, (String)"minimize-uri", (String)service.getComponentManager().getLinkService().getLinkURI(event));
            }
            if (size.equals(SizingStatus.STATUS_MINIMIZED)) {
                event = new ChangeCopletInstanceAspectDataEvent(cid, "size", (Object)SizingStatus.STATUS_MAXIMIZED);
                XMLUtils.createElement((ContentHandler)handler, (String)"maximize-uri", (String)service.getComponentManager().getLinkService().getLinkURI(event));
            }
            if (size.equals(SizingStatus.STATUS_MINIMIZED)) {
                showContent = false;
            }
        }
        if (showContent) {
            context.invokeNext(layout, service, handler);
        }
    }
}

