/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.util.List;
import org.apache.fop.pdf.PDFDeviceColorSpace;
import org.apache.fop.pdf.PDFFunction;
import org.apache.fop.pdf.PDFNumber;
import org.apache.fop.pdf.PDFObject;

public class PDFShading
extends PDFObject {
    protected String shadingName = null;
    protected int shadingType = 3;
    protected PDFDeviceColorSpace colorSpace = null;
    protected List background = null;
    protected List bBox = null;
    protected boolean antiAlias = false;
    protected List domain = null;
    protected List matrix = null;
    protected PDFFunction function = null;
    protected List coords = null;
    protected List extend = null;
    protected int bitsPerCoordinate = 0;
    protected int bitsPerFlag = 0;
    protected List decode = null;
    protected int bitsPerComponent = 0;
    protected int verticesPerRow = 0;

    public PDFShading(int theShadingType, PDFDeviceColorSpace theColorSpace, List theBackground, List theBBox, boolean theAntiAlias, List theDomain, List theMatrix, PDFFunction theFunction) {
        this.shadingType = theShadingType;
        this.colorSpace = theColorSpace;
        this.background = theBackground;
        this.bBox = theBBox;
        this.antiAlias = theAntiAlias;
        this.domain = theDomain;
        this.matrix = theMatrix;
        this.function = theFunction;
    }

    public PDFShading(int theShadingType, PDFDeviceColorSpace theColorSpace, List theBackground, List theBBox, boolean theAntiAlias, List theCoords, List theDomain, PDFFunction theFunction, List theExtend) {
        this.shadingType = theShadingType;
        this.colorSpace = theColorSpace;
        this.background = theBackground;
        this.bBox = theBBox;
        this.antiAlias = theAntiAlias;
        this.coords = theCoords;
        this.domain = theDomain;
        this.function = theFunction;
        this.extend = theExtend;
    }

    public PDFShading(int theShadingType, PDFDeviceColorSpace theColorSpace, List theBackground, List theBBox, boolean theAntiAlias, int theBitsPerCoordinate, int theBitsPerComponent, int theBitsPerFlag, List theDecode, PDFFunction theFunction) {
        this.shadingType = theShadingType;
        this.colorSpace = theColorSpace;
        this.background = theBackground;
        this.bBox = theBBox;
        this.antiAlias = theAntiAlias;
        this.bitsPerCoordinate = theBitsPerCoordinate;
        this.bitsPerComponent = theBitsPerComponent;
        this.bitsPerFlag = theBitsPerFlag;
        this.decode = theDecode;
        this.function = theFunction;
    }

    public PDFShading(int theShadingType, PDFDeviceColorSpace theColorSpace, List theBackground, List theBBox, boolean theAntiAlias, int theBitsPerCoordinate, int theBitsPerComponent, List theDecode, int theVerticesPerRow, PDFFunction theFunction) {
        this.shadingType = theShadingType;
        this.colorSpace = theColorSpace;
        this.background = theBackground;
        this.bBox = theBBox;
        this.antiAlias = theAntiAlias;
        this.bitsPerCoordinate = theBitsPerCoordinate;
        this.bitsPerComponent = theBitsPerComponent;
        this.decode = theDecode;
        this.verticesPerRow = theVerticesPerRow;
        this.function = theFunction;
    }

    public String getName() {
        return this.shadingName;
    }

    public void setName(String name) {
        if (name.indexOf(" ") >= 0) {
            throw new IllegalArgumentException("Shading name must not contain any spaces");
        }
        this.shadingName = name;
    }

    public String toPDFString() {
        int tempInt;
        int vectorSize;
        StringBuffer p = new StringBuffer(128);
        p.append(this.getObjectID() + "<< \n/ShadingType " + this.shadingType + " \n");
        if (this.colorSpace != null) {
            p.append("/ColorSpace /" + this.colorSpace.getName() + " \n");
        }
        if (this.background != null) {
            p.append("/Background [ ");
            vectorSize = this.background.size();
            for (tempInt = 0; tempInt < vectorSize; ++tempInt) {
                p.append(PDFNumber.doubleOut((Double)this.background.get(tempInt)) + " ");
            }
            p.append("] \n");
        }
        if (this.bBox != null) {
            p.append("/BBox [ ");
            vectorSize = this.bBox.size();
            for (tempInt = 0; tempInt < vectorSize; ++tempInt) {
                p.append(PDFNumber.doubleOut((Double)this.bBox.get(tempInt)) + " ");
            }
            p.append("] \n");
        }
        if (this.antiAlias) {
            p.append("/AntiAlias " + this.antiAlias + " \n");
        }
        if (this.shadingType == 1) {
            if (this.domain != null) {
                p.append("/Domain [ ");
                vectorSize = this.domain.size();
                for (tempInt = 0; tempInt < vectorSize; ++tempInt) {
                    p.append(PDFNumber.doubleOut((Double)this.domain.get(tempInt)) + " ");
                }
                p.append("] \n");
            } else {
                p.append("/Domain [ 0 1 ] \n");
            }
            if (this.matrix != null) {
                p.append("/Matrix [ ");
                vectorSize = this.matrix.size();
                for (tempInt = 0; tempInt < vectorSize; ++tempInt) {
                    p.append(PDFNumber.doubleOut((Double)this.matrix.get(tempInt)) + " ");
                }
                p.append("] \n");
            }
            if (this.function != null) {
                p.append("/Function ");
                p.append(this.function.referencePDF() + " \n");
            }
        } else if (this.shadingType == 2 || this.shadingType == 3) {
            if (this.coords != null) {
                p.append("/Coords [ ");
                vectorSize = this.coords.size();
                for (tempInt = 0; tempInt < vectorSize; ++tempInt) {
                    p.append(PDFNumber.doubleOut((Double)this.coords.get(tempInt)) + " ");
                }
                p.append("] \n");
            }
            if (this.domain != null) {
                p.append("/Domain [ ");
                vectorSize = this.domain.size();
                for (tempInt = 0; tempInt < vectorSize; ++tempInt) {
                    p.append(PDFNumber.doubleOut((Double)this.domain.get(tempInt)) + " ");
                }
                p.append("] \n");
            } else {
                p.append("/Domain [ 0 1 ] \n");
            }
            if (this.extend != null) {
                p.append("/Extend [ ");
                vectorSize = this.extend.size();
                for (tempInt = 0; tempInt < vectorSize; ++tempInt) {
                    p.append((Boolean)this.extend.get(tempInt) + " ");
                }
                p.append("] \n");
            } else {
                p.append("/Extend [ true true ] \n");
            }
            if (this.function != null) {
                p.append("/Function ");
                p.append(this.function.referencePDF() + " \n");
            }
        } else if (this.shadingType == 4 || this.shadingType == 6 || this.shadingType == 7) {
            if (this.bitsPerCoordinate > 0) {
                p.append("/BitsPerCoordinate " + this.bitsPerCoordinate + " \n");
            } else {
                p.append("/BitsPerCoordinate 1 \n");
            }
            if (this.bitsPerComponent > 0) {
                p.append("/BitsPerComponent " + this.bitsPerComponent + " \n");
            } else {
                p.append("/BitsPerComponent 1 \n");
            }
            if (this.bitsPerFlag > 0) {
                p.append("/BitsPerFlag " + this.bitsPerFlag + " \n");
            } else {
                p.append("/BitsPerFlag 2 \n");
            }
            if (this.decode != null) {
                p.append("/Decode [ ");
                vectorSize = this.decode.size();
                for (tempInt = 0; tempInt < vectorSize; ++tempInt) {
                    p.append((Boolean)this.decode.get(tempInt) + " ");
                }
                p.append("] \n");
            }
            if (this.function != null) {
                p.append("/Function ");
                p.append(this.function.referencePDF() + " \n");
            }
        } else if (this.shadingType == 5) {
            if (this.bitsPerCoordinate > 0) {
                p.append("/BitsPerCoordinate " + this.bitsPerCoordinate + " \n");
            } else {
                p.append("/BitsPerCoordinate 1 \n");
            }
            if (this.bitsPerComponent > 0) {
                p.append("/BitsPerComponent " + this.bitsPerComponent + " \n");
            } else {
                p.append("/BitsPerComponent 1 \n");
            }
            if (this.decode != null) {
                p.append("/Decode [ ");
                vectorSize = this.decode.size();
                for (tempInt = 0; tempInt < vectorSize; ++tempInt) {
                    p.append((Boolean)this.decode.get(tempInt) + " ");
                }
                p.append("] \n");
            }
            if (this.function != null) {
                p.append("/Function ");
                p.append(this.function.referencePDF() + " \n");
            }
            if (this.verticesPerRow > 0) {
                p.append("/VerticesPerRow " + this.verticesPerRow + " \n");
            } else {
                p.append("/VerticesPerRow 2 \n");
            }
        }
        p.append(">> \nendobj\n");
        return p.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PDFShading)) {
            return false;
        }
        PDFShading shad = (PDFShading)obj;
        if (this.shadingType != shad.shadingType) {
            return false;
        }
        if (this.antiAlias != shad.antiAlias) {
            return false;
        }
        if (this.bitsPerCoordinate != shad.bitsPerCoordinate) {
            return false;
        }
        if (this.bitsPerFlag != shad.bitsPerFlag) {
            return false;
        }
        if (this.bitsPerComponent != shad.bitsPerComponent) {
            return false;
        }
        if (this.verticesPerRow != shad.verticesPerRow) {
            return false;
        }
        if (this.colorSpace != null ? !this.colorSpace.equals(shad.colorSpace) : shad.colorSpace != null) {
            return false;
        }
        if (this.background != null ? !((Object)this.background).equals(shad.background) : shad.background != null) {
            return false;
        }
        if (this.bBox != null ? !((Object)this.bBox).equals(shad.bBox) : shad.bBox != null) {
            return false;
        }
        if (this.domain != null ? !((Object)this.domain).equals(shad.domain) : shad.domain != null) {
            return false;
        }
        if (this.matrix != null ? !((Object)this.matrix).equals(shad.matrix) : shad.matrix != null) {
            return false;
        }
        if (this.coords != null ? !((Object)this.coords).equals(shad.coords) : shad.coords != null) {
            return false;
        }
        if (this.extend != null ? !((Object)this.extend).equals(shad.extend) : shad.extend != null) {
            return false;
        }
        if (this.decode != null ? !((Object)this.decode).equals(shad.decode) : shad.decode != null) {
            return false;
        }
        return !(this.function != null ? !this.function.equals(shad.function) : shad.function != null);
    }
}

