/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.cron;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Set;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.service.ServiceManager;
import org.quartz.Calendar;
import org.quartz.CronTrigger;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.impl.jdbcjobstore.DriverDelegate;
import org.quartz.spi.ClassLoadHelper;
import org.quartz.utils.Key;
import org.quartz.utils.TriggerStatus;

public class QuartzDriverDelegate
implements DriverDelegate {
    private Logger logger;
    private ServiceManager manager;
    private Context context;
    private DriverDelegate delegate;

    public QuartzDriverDelegate(Logger logger, ServiceManager manager, Context context, DriverDelegate delegate) {
        this.logger = logger;
        this.manager = manager;
        this.context = context;
        this.delegate = delegate;
    }

    public int insertJobDetail(Connection conn, JobDetail job) throws IOException, SQLException {
        this.removeTransientData(job);
        return this.delegate.insertJobDetail(conn, job);
    }

    public int updateJobDetail(Connection conn, JobDetail job) throws IOException, SQLException {
        this.removeTransientData(job);
        return this.delegate.updateJobDetail(conn, job);
    }

    public int updateJobData(Connection conn, JobDetail job) throws IOException, SQLException {
        this.removeTransientData(job);
        return this.delegate.updateJobData(conn, job);
    }

    private void removeTransientData(JobDetail job) {
        JobDataMap map = job.getJobDataMap();
        if (map != null) {
            this.logger.debug("QuartzDriverDelegate: Removing transient data");
            map.remove((Object)"QuartzJobScheduler.Logger");
            map.remove((Object)"QuartzJobScheduler.Context");
            map.remove((Object)"QuartzJobScheduler.ServiceManager");
        }
    }

    public JobDetail selectJobDetail(Connection conn, String jobName, String groupName, ClassLoadHelper loadHelper) throws ClassNotFoundException, IOException, SQLException {
        JobDataMap map;
        JobDetail job = this.delegate.selectJobDetail(conn, jobName, groupName, loadHelper);
        if (job != null && (map = job.getJobDataMap()) != null) {
            this.logger.debug("QuartzDriverDelegate: Adding transient data");
            map.put((Object)"QuartzJobScheduler.Logger", (Object)this.logger);
            map.put((Object)"QuartzJobScheduler.Context", (Object)this.context);
            map.put((Object)"QuartzJobScheduler.ServiceManager", (Object)this.manager);
        }
        return job;
    }

    public int updateTriggerStatesFromOtherStates(Connection conn, String newState, String oldState1, String oldState2) throws SQLException {
        return this.delegate.updateTriggerStatesFromOtherStates(conn, newState, oldState1, oldState2);
    }

    public Key[] selectMisfiredTriggers(Connection conn, long ts) throws SQLException {
        return this.delegate.selectMisfiredTriggers(conn, ts);
    }

    public Key[] selectMisfiredTriggersInState(Connection conn, String state, long ts) throws SQLException {
        return this.delegate.selectMisfiredTriggersInState(conn, state, ts);
    }

    public Key[] selectMisfiredTriggersInGroupInState(Connection conn, String groupName, String state, long ts) throws SQLException {
        return this.delegate.selectMisfiredTriggersInGroupInState(conn, groupName, state, ts);
    }

    public Trigger[] selectTriggersForRecoveringJobs(Connection conn) throws SQLException, IOException, ClassNotFoundException {
        return this.delegate.selectTriggersForRecoveringJobs(conn);
    }

    public int deleteFiredTriggers(Connection conn) throws SQLException {
        return this.delegate.deleteFiredTriggers(conn);
    }

    public int deleteFiredTriggers(Connection conn, String instanceId) throws SQLException {
        return this.delegate.deleteFiredTriggers(conn, instanceId);
    }

    public int deleteVolatileFiredTriggers(Connection conn) throws SQLException {
        return this.delegate.deleteVolatileFiredTriggers(conn);
    }

    public Key[] selectVolatileTriggers(Connection conn) throws SQLException {
        return this.delegate.selectVolatileTriggers(conn);
    }

    public Key[] selectVolatileJobs(Connection conn) throws SQLException {
        return this.delegate.selectVolatileJobs(conn);
    }

    public Key[] selectTriggerNamesForJob(Connection conn, String jobName, String groupName) throws SQLException {
        return this.delegate.selectTriggerNamesForJob(conn, jobName, groupName);
    }

    public int deleteJobListeners(Connection conn, String jobName, String groupName) throws SQLException {
        return this.delegate.deleteJobListeners(conn, jobName, groupName);
    }

    public int deleteJobDetail(Connection conn, String jobName, String groupName) throws SQLException {
        return this.delegate.deleteJobDetail(conn, jobName, groupName);
    }

    public boolean isJobStateful(Connection conn, String jobName, String groupName) throws SQLException {
        return this.delegate.isJobStateful(conn, jobName, groupName);
    }

    public boolean jobExists(Connection conn, String jobName, String groupName) throws SQLException {
        return this.delegate.jobExists(conn, jobName, groupName);
    }

    public int insertJobListener(Connection conn, JobDetail job, String listener) throws SQLException {
        return this.delegate.insertJobListener(conn, job, listener);
    }

    public String[] selectJobListeners(Connection conn, String jobName, String groupName) throws SQLException {
        return this.delegate.selectJobListeners(conn, jobName, groupName);
    }

    public int selectNumJobs(Connection conn) throws SQLException {
        return this.delegate.selectNumJobs(conn);
    }

    public String[] selectJobGroups(Connection conn) throws SQLException {
        return this.delegate.selectJobGroups(conn);
    }

    public String[] selectJobsInGroup(Connection conn, String groupName) throws SQLException {
        return this.delegate.selectJobsInGroup(conn, groupName);
    }

    public int insertTrigger(Connection conn, Trigger trigger, String state, JobDetail jobDetail) throws SQLException, IOException {
        return this.delegate.insertTrigger(conn, trigger, state, jobDetail);
    }

    public int insertSimpleTrigger(Connection conn, SimpleTrigger trigger) throws SQLException {
        return this.delegate.insertSimpleTrigger(conn, trigger);
    }

    public int insertBlobTrigger(Connection conn, Trigger trigger) throws SQLException, IOException {
        return this.delegate.insertBlobTrigger(conn, trigger);
    }

    public int insertCronTrigger(Connection conn, CronTrigger trigger) throws SQLException {
        return this.delegate.insertCronTrigger(conn, trigger);
    }

    public int updateTrigger(Connection conn, Trigger trigger, String state, JobDetail jobDetail) throws SQLException, IOException {
        return this.delegate.updateTrigger(conn, trigger, state, jobDetail);
    }

    public int updateSimpleTrigger(Connection conn, SimpleTrigger trigger) throws SQLException {
        return this.delegate.updateSimpleTrigger(conn, trigger);
    }

    public int updateCronTrigger(Connection conn, CronTrigger trigger) throws SQLException {
        return this.delegate.updateCronTrigger(conn, trigger);
    }

    public int updateBlobTrigger(Connection conn, Trigger trigger) throws SQLException, IOException {
        return this.delegate.updateBlobTrigger(conn, trigger);
    }

    public boolean triggerExists(Connection conn, String triggerName, String groupName) throws SQLException {
        return this.delegate.triggerExists(conn, triggerName, groupName);
    }

    public int updateTriggerState(Connection conn, String triggerName, String groupName, String state) throws SQLException {
        return this.delegate.updateTriggerState(conn, triggerName, groupName, state);
    }

    public int updateTriggerStateFromOtherState(Connection conn, String triggerName, String groupName, String newState, String oldState) throws SQLException {
        return this.delegate.updateTriggerStateFromOtherState(conn, triggerName, groupName, newState, oldState);
    }

    public int updateTriggerStateFromOtherStates(Connection conn, String triggerName, String groupName, String newState, String oldState1, String oldState2, String oldState3) throws SQLException {
        return this.delegate.updateTriggerStateFromOtherStates(conn, triggerName, groupName, newState, oldState1, oldState2, oldState3);
    }

    public int updateTriggerStateFromOtherStatesBeforeTime(Connection conn, String newState, String oldState1, String oldState2, long time) throws SQLException {
        return this.delegate.updateTriggerStateFromOtherStatesBeforeTime(conn, newState, oldState1, oldState2, time);
    }

    public int updateTriggerGroupStateFromOtherStates(Connection conn, String groupName, String newState, String oldState1, String oldState2, String oldState3) throws SQLException {
        return this.delegate.updateTriggerGroupStateFromOtherStates(conn, groupName, newState, oldState1, oldState2, oldState3);
    }

    public int updateTriggerGroupStateFromOtherState(Connection conn, String groupName, String newState, String oldState) throws SQLException {
        return this.delegate.updateTriggerGroupStateFromOtherState(conn, groupName, newState, oldState);
    }

    public int updateTriggerStatesForJob(Connection conn, String jobName, String groupName, String state) throws SQLException {
        return this.delegate.updateTriggerStatesForJob(conn, jobName, groupName, state);
    }

    public int updateTriggerStatesForJobFromOtherState(Connection conn, String jobName, String groupName, String state, String oldState) throws SQLException {
        return this.delegate.updateTriggerStatesForJobFromOtherState(conn, jobName, groupName, state, oldState);
    }

    public int deleteTriggerListeners(Connection conn, String triggerName, String groupName) throws SQLException {
        return this.delegate.deleteTriggerListeners(conn, triggerName, groupName);
    }

    public int insertTriggerListener(Connection conn, Trigger trigger, String listener) throws SQLException {
        return this.delegate.insertTriggerListener(conn, trigger, listener);
    }

    public String[] selectTriggerListeners(Connection conn, String triggerName, String groupName) throws SQLException {
        return this.delegate.selectTriggerListeners(conn, triggerName, groupName);
    }

    public int deleteSimpleTrigger(Connection conn, String triggerName, String groupName) throws SQLException {
        return this.delegate.deleteSimpleTrigger(conn, triggerName, groupName);
    }

    public int deleteBlobTrigger(Connection conn, String triggerName, String groupName) throws SQLException {
        return this.delegate.deleteBlobTrigger(conn, triggerName, groupName);
    }

    public int deleteCronTrigger(Connection conn, String triggerName, String groupName) throws SQLException {
        return this.delegate.deleteCronTrigger(conn, triggerName, groupName);
    }

    public int deleteTrigger(Connection conn, String triggerName, String groupName) throws SQLException {
        return this.delegate.deleteTrigger(conn, triggerName, groupName);
    }

    public int selectNumTriggersForJob(Connection conn, String jobName, String groupName) throws SQLException {
        return this.delegate.selectNumTriggersForJob(conn, jobName, groupName);
    }

    public JobDetail selectJobForTrigger(Connection conn, String triggerName, String groupName, ClassLoadHelper loadHelper) throws SQLException, ClassNotFoundException {
        return this.delegate.selectJobForTrigger(conn, triggerName, groupName, loadHelper);
    }

    public List selectStatefulJobsOfTriggerGroup(Connection conn, String groupName) throws SQLException {
        return this.delegate.selectStatefulJobsOfTriggerGroup(conn, groupName);
    }

    public Trigger[] selectTriggersForJob(Connection conn, String jobName, String groupName) throws SQLException, ClassNotFoundException, IOException {
        return this.delegate.selectTriggersForJob(conn, jobName, groupName);
    }

    public Trigger[] selectTriggersForCalendar(Connection conn, String calName) throws SQLException, ClassNotFoundException, IOException {
        return this.delegate.selectTriggersForCalendar(conn, calName);
    }

    public Trigger selectTrigger(Connection conn, String triggerName, String groupName) throws SQLException, ClassNotFoundException, IOException {
        return this.delegate.selectTrigger(conn, triggerName, groupName);
    }

    public String selectTriggerState(Connection conn, String triggerName, String groupName) throws SQLException {
        return this.delegate.selectTriggerState(conn, triggerName, groupName);
    }

    public TriggerStatus selectTriggerStatus(Connection conn, String triggerName, String groupName) throws SQLException {
        return this.delegate.selectTriggerStatus(conn, triggerName, groupName);
    }

    public int selectNumTriggers(Connection conn) throws SQLException {
        return this.delegate.selectNumTriggers(conn);
    }

    public String[] selectTriggerGroups(Connection conn) throws SQLException {
        return this.delegate.selectTriggerGroups(conn);
    }

    public String[] selectTriggersInGroup(Connection conn, String groupName) throws SQLException {
        return this.delegate.selectTriggersInGroup(conn, groupName);
    }

    public Key[] selectTriggersInState(Connection conn, String state) throws SQLException {
        return this.delegate.selectTriggersInState(conn, state);
    }

    public int insertPausedTriggerGroup(Connection conn, String groupName) throws SQLException {
        return this.delegate.insertPausedTriggerGroup(conn, groupName);
    }

    public int deletePausedTriggerGroup(Connection conn, String groupName) throws SQLException {
        return this.delegate.deletePausedTriggerGroup(conn, groupName);
    }

    public int deleteAllPausedTriggerGroups(Connection conn) throws SQLException {
        return this.delegate.deleteAllPausedTriggerGroups(conn);
    }

    public boolean isTriggerGroupPaused(Connection conn, String groupName) throws SQLException {
        return this.delegate.isTriggerGroupPaused(conn, groupName);
    }

    public Set selectPausedTriggerGroups(Connection conn) throws SQLException {
        return this.delegate.selectPausedTriggerGroups(conn);
    }

    public boolean isExistingTriggerGroup(Connection conn, String groupName) throws SQLException {
        return this.delegate.isExistingTriggerGroup(conn, groupName);
    }

    public int insertCalendar(Connection conn, String calendarName, Calendar calendar) throws IOException, SQLException {
        return this.delegate.insertCalendar(conn, calendarName, calendar);
    }

    public int updateCalendar(Connection conn, String calendarName, Calendar calendar) throws IOException, SQLException {
        return this.delegate.updateCalendar(conn, calendarName, calendar);
    }

    public boolean calendarExists(Connection conn, String calendarName) throws SQLException {
        return this.delegate.calendarExists(conn, calendarName);
    }

    public Calendar selectCalendar(Connection conn, String calendarName) throws ClassNotFoundException, IOException, SQLException {
        return this.delegate.selectCalendar(conn, calendarName);
    }

    public boolean calendarIsReferenced(Connection conn, String calendarName) throws SQLException {
        return this.delegate.calendarIsReferenced(conn, calendarName);
    }

    public int deleteCalendar(Connection conn, String calendarName) throws SQLException {
        return this.delegate.deleteCalendar(conn, calendarName);
    }

    public int selectNumCalendars(Connection conn) throws SQLException {
        return this.delegate.selectNumCalendars(conn);
    }

    public String[] selectCalendars(Connection conn) throws SQLException {
        return this.delegate.selectCalendars(conn);
    }

    public long selectNextFireTime(Connection conn) throws SQLException {
        return this.delegate.selectNextFireTime(conn);
    }

    public Key selectTriggerForFireTime(Connection conn, long fireTime) throws SQLException {
        return this.delegate.selectTriggerForFireTime(conn, fireTime);
    }

    public int insertFiredTrigger(Connection conn, Trigger trigger, String state, JobDetail jobDetail) throws SQLException {
        return this.delegate.insertFiredTrigger(conn, trigger, state, jobDetail);
    }

    public List selectFiredTriggerRecords(Connection conn, String triggerName, String groupName) throws SQLException {
        return this.delegate.selectFiredTriggerRecords(conn, triggerName, groupName);
    }

    public List selectFiredTriggerRecordsByJob(Connection conn, String jobName, String groupName) throws SQLException {
        return this.delegate.selectFiredTriggerRecordsByJob(conn, jobName, groupName);
    }

    public List selectInstancesFiredTriggerRecords(Connection conn, String instanceName) throws SQLException {
        return this.delegate.selectInstancesFiredTriggerRecords(conn, instanceName);
    }

    public int deleteFiredTrigger(Connection conn, String entryId) throws SQLException {
        return this.delegate.deleteFiredTrigger(conn, entryId);
    }

    public int selectJobExecutionCount(Connection conn, String jobName, String jobGroup) throws SQLException {
        return this.delegate.selectJobExecutionCount(conn, jobName, jobGroup);
    }

    public int insertSchedulerState(Connection conn, String instanceId, long checkInTime, long interval, String recoverer) throws SQLException {
        return this.delegate.insertSchedulerState(conn, instanceId, checkInTime, interval, recoverer);
    }

    public int deleteSchedulerState(Connection conn, String instanceId) throws SQLException {
        return this.delegate.deleteSchedulerState(conn, instanceId);
    }

    public List selectSchedulerStateRecords(Connection conn, String instanceId) throws SQLException {
        return this.delegate.selectSchedulerStateRecords(conn, instanceId);
    }

    public JobDataMap selectTriggerJobDataMap(Connection conn, String triggerName, String groupName) throws SQLException, ClassNotFoundException, IOException {
        return this.delegate.selectTriggerJobDataMap(conn, triggerName, groupName);
    }

    public int updateSchedulerState(Connection conn, String instanceId, long checkInTime, String recoverer) throws SQLException {
        return this.delegate.updateSchedulerState(conn, instanceId, checkInTime, recoverer);
    }
}

