/*
Copyright (C) 2000-2010  Ministere de la culture et de la communication (France), AJLSM
See LICENCE file
*/
package fr.gouv.culture.sdx.search.lucene.query;

import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.search.lucene.Field;
import fr.gouv.culture.sdx.search.lucene.queryparser.QueryParser;
//import fr.gouv.culture.sdx.utils.save.SaveParameters;
//import fr.gouv.culture.sdx.utils.save.Saveable;

import org.apache.lucene.search.RemoteSearchable;
import org.apache.lucene.search.Searchable;

import java.io.IOException;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;

public class RemoteIndex extends UnicastRemoteObject implements Index {
    /** Constructs and exports a remote index. */
    LuceneIndex lIndex = null;

    public RemoteIndex(LuceneIndex lIndex) throws RemoteException {
        super();
        this.lIndex = lIndex;
    }

    public Searchable getSearcher() throws IOException, SDXException {
        return new RemoteSearchable(lIndex.getSearcher());
    }

    public Field getField(String name) {
        return lIndex.getField(name);
    }

    public Field getDefaultField() {
        return lIndex.getDefaultField();
    }

    public QueryParser getQueryParser() throws IOException, SDXException {
        //query parser is not serializable so we return null always
        return null;
    }

    protected String getClassNameSuffix() {
        return Index.CLASS_NAME_SUFFIX;
    }

}

