/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.style;

import com.icl.saxon.Context;
import com.icl.saxon.Mode;
import com.icl.saxon.ParameterSet;
import com.icl.saxon.expr.ContextNodeExpression;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.PathExpression;
import com.icl.saxon.expr.Step;
import com.icl.saxon.om.Name;
import com.icl.saxon.om.NamespaceException;
import com.icl.saxon.om.Navigator;
import com.icl.saxon.pattern.AnyNodeTest;
import com.icl.saxon.style.StandardNames;
import com.icl.saxon.style.StyleElement;
import com.icl.saxon.style.XSLSort;
import com.icl.saxon.style.XSLWithParam;
import com.icl.saxon.tree.AttributeCollection;
import com.icl.saxon.tree.NodeImpl;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Node;

public class XSLApplyTemplates
extends StyleElement {
    private Expression select;
    private boolean usesParams;
    private int modeNameCode = -1;
    private Mode mode;
    private String modeAttribute;

    public boolean isInstruction() {
        return true;
    }

    public void prepareAttributes() throws TransformerConfigurationException {
        StandardNames standardNames = this.getStandardNames();
        AttributeCollection attributeCollection = this.getAttributeList();
        String string = null;
        int n = 0;
        while (n < attributeCollection.getLength()) {
            int n2 = attributeCollection.getNameCode(n);
            int n3 = n2 & 0xFFFFF;
            if (n3 == standardNames.MODE) {
                this.modeAttribute = attributeCollection.getValue(n);
            } else if (n3 == standardNames.SELECT) {
                string = attributeCollection.getValue(n);
            } else {
                this.checkUnknownAttribute(n2);
            }
            ++n;
        }
        if (this.modeAttribute != null) {
            if (!Name.isQName(this.modeAttribute)) {
                this.compileError("Mode name is not a valid QName");
            }
            try {
                this.modeNameCode = this.makeNameCode(this.modeAttribute, false);
            }
            catch (NamespaceException namespaceException) {
                this.compileError(namespaceException.getMessage());
            }
        }
        if (string != null) {
            this.select = this.makeExpression(string);
        }
    }

    public void validate() throws TransformerConfigurationException {
        this.checkWithinTemplate();
        this.mode = this.getPrincipalStyleSheet().getRuleManager().getMode(this.modeNameCode);
        boolean bl = false;
        NodeImpl nodeImpl = (NodeImpl)this.getFirstChild();
        while (nodeImpl != null) {
            if (nodeImpl instanceof XSLSort) {
                bl = true;
            } else if (nodeImpl instanceof XSLWithParam) {
                this.usesParams = true;
            } else if (nodeImpl.getNodeType() == 3) {
                if (!Navigator.isWhite(nodeImpl.getStringValue())) {
                    this.compileError("No character data allowed within xsl:apply-templates");
                }
            } else {
                this.compileError("Invalid element within xsl:apply-templates: ");
            }
            nodeImpl = (NodeImpl)nodeImpl.getNextSibling();
        }
        if (this.select == null && bl) {
            this.select = new PathExpression(new ContextNodeExpression(), new Step(3, AnyNodeTest.getInstance()));
        }
        if (this.select != null) {
            this.select = this.handleSortKeys(this.select);
        }
    }

    public void process(Context context) throws TransformerException {
        ParameterSet parameterSet = null;
        if (this.usesParams) {
            parameterSet = new ParameterSet();
            Node node = this.getFirstChild();
            while (node != null) {
                if (node instanceof XSLWithParam) {
                    XSLWithParam xSLWithParam = (XSLWithParam)node;
                    parameterSet.put(xSLWithParam.getVariableFingerprint(), xSLWithParam.getParamValue(context));
                }
                node = node.getNextSibling();
            }
        }
        context.getController().applyTemplates(context, this.select, this.mode, parameterSet);
    }
}

