/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pcl;

import org.apache.avalon.framework.configuration.Configuration;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.render.PrintRendererConfigurator;
import org.apache.fop.render.Renderer;
import org.apache.fop.render.pcl.PCLRenderer;

public class PCLRendererConfigurator
extends PrintRendererConfigurator {
    public PCLRendererConfigurator(FOUserAgent userAgent) {
        super(userAgent);
    }

    public void configure(Renderer renderer) throws FOPException {
        Configuration cfg = super.getRendererConfig(renderer);
        if (cfg != null) {
            PCLRenderer pclRenderer = (PCLRenderer)renderer;
            String rendering = cfg.getChild("rendering").getValue(null);
            if ("quality".equalsIgnoreCase(rendering)) {
                pclRenderer.setQualityBeforeSpeed(true);
            } else if ("speed".equalsIgnoreCase(rendering)) {
                pclRenderer.setQualityBeforeSpeed(false);
            } else if (rendering != null) {
                throw new FOPException("Valid values for 'rendering' are 'quality' and 'speed'. Value found: " + rendering);
            }
            String textRendering = cfg.getChild("text-rendering").getValue(null);
            if ("bitmap".equalsIgnoreCase(textRendering)) {
                pclRenderer.setAllTextAsBitmaps(true);
            } else if ("auto".equalsIgnoreCase(textRendering)) {
                pclRenderer.setAllTextAsBitmaps(false);
            } else if (textRendering != null) {
                throw new FOPException("Valid values for 'text-rendering' are 'auto' and 'bitmap'. Value found: " + textRendering);
            }
        }
    }
}

