/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.language.programming.java;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.apache.cocoon.components.language.programming.CompilerError;
import org.apache.cocoon.components.language.programming.java.AbstractJavaCompiler;
import org.apache.commons.lang.SystemUtils;
import sun.tools.javac.Main;

public class Javac
extends AbstractJavaCompiler {
    public boolean compile() throws IOException {
        boolean result;
        ByteArrayOutputStream err = new ByteArrayOutputStream();
        if (!SystemUtils.IS_JAVA_1_3) {
            PrintWriter pw = new PrintWriter(err);
            result = com.sun.tools.javac.Main.compile(this.toStringArray(this.fillArguments(new ArrayList())), pw) == 0;
        } else {
            Main compiler = new Main((OutputStream)err, "javac");
            result = compiler.compile(this.toStringArray(this.fillArguments(new ArrayList())));
        }
        this.errors = new ByteArrayInputStream(err.toByteArray());
        return result;
    }

    protected List parseStream(BufferedReader input) throws IOException {
        ArrayList<CompilerError> errors = new ArrayList<CompilerError>();
        String line = null;
        StringBuffer buffer = null;
        while (true) {
            buffer = new StringBuffer();
            do {
                if ((line = input.readLine()) == null) {
                    if (buffer.length() > 0) {
                        errors.add(new CompilerError("\n" + buffer.toString()));
                    }
                    return errors;
                }
                buffer.append(line);
                buffer.append('\n');
            } while (!line.endsWith("^"));
            errors.add(this.parseModernError(buffer.toString()));
        }
    }

    private CompilerError parseModernError(String error) {
        StringTokenizer tokens = new StringTokenizer(error, ":");
        try {
            String pointer;
            int startcolumn;
            String file = tokens.nextToken();
            if (file.length() == 1) {
                file = file + ":" + tokens.nextToken();
            }
            int line = Integer.parseInt(tokens.nextToken());
            String message = tokens.nextToken("\n").substring(1);
            String context = tokens.nextToken("\n");
            int endcolumn = context.indexOf(" ", startcolumn = (pointer = tokens.nextToken("\n")).indexOf("^"));
            if (endcolumn == -1) {
                endcolumn = context.length();
            }
            return new CompilerError(file, false, line, startcolumn, line, endcolumn, message);
        }
        catch (NoSuchElementException nse) {
            return new CompilerError("no more tokens - could not parse error message: " + error);
        }
        catch (Exception nse) {
            return new CompilerError("could not parse error message: " + error);
        }
    }

    public String toString() {
        return "Sun Javac Compiler";
    }
}

