/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.xscript;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.util.Date;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.xscript.XScriptManager;
import org.apache.cocoon.components.xscript.XScriptManagerImpl;
import org.apache.cocoon.components.xscript.XScriptObjectResult;
import org.apache.cocoon.xml.EmbeddedXMLPipe;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.xml.sax.SAXParser;
import org.apache.excalibur.xml.xslt.XSLTProcessor;
import org.apache.excalibur.xml.xslt.XSLTProcessorException;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class XScriptObject
implements Source,
Serviceable {
    Date lastModifiedDate = new Date();
    XScriptManager xscriptManager;
    protected ServiceManager serviceManager;

    public XScriptObject(XScriptManager manager) {
        this.xscriptManager = manager;
        ((XScriptManagerImpl)this.xscriptManager).register(this);
    }

    public void service(ServiceManager manager) throws ServiceException {
        this.serviceManager = manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XScriptObject transform(XScriptObject stylesheet, Parameters params) throws IllegalArgumentException, ProcessingException {
        try {
            CharArrayWriter writer = new CharArrayWriter();
            StreamResult result = new StreamResult(writer);
            XSLTProcessor transformer = (XSLTProcessor)this.serviceManager.lookup(XSLTProcessor.ROLE);
            try {
                transformer.transform((Source)this, (Source)stylesheet, params, (Result)result);
            }
            finally {
                this.serviceManager.release((Object)transformer);
            }
            return new XScriptObjectResult(this.xscriptManager, writer.toString());
        }
        catch (XSLTProcessorException ex) {
            throw new ProcessingException((Exception)((Object)ex));
        }
        catch (Exception ex) {
            throw new ProcessingException(ex);
        }
    }

    public void toEmbeddedSAX(ContentHandler handler) throws SAXException {
        this.toSAX((ContentHandler)new EmbeddedXMLPipe(handler));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void toSAX(ContentHandler handler) throws SAXException {
        SAXParser parser = null;
        try {
            try {
                parser = (SAXParser)this.serviceManager.lookup(SAXParser.ROLE);
                InputSource source = this.getInputSource();
                parser.parse(source, handler);
            }
            catch (SAXException e) {
                throw e;
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
            Object var5_6 = null;
            if (parser == null) return;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            if (parser == null) throw throwable;
            this.serviceManager.release((Object)parser);
            throw throwable;
        }
        this.serviceManager.release((Object)parser);
    }

    public long getLastModified() {
        return this.lastModifiedDate.getTime();
    }

    public abstract long getContentLength();

    public InputSource getInputSource() throws ProcessingException, IOException {
        InputSource is = new InputSource(this.getInputStream());
        is.setSystemId(this.getURI());
        return is;
    }

    public void recycle() {
    }

    public String getScheme() {
        return "xscript";
    }

    public void refresh() {
    }

    public String getMimeType() {
        return "text/xml";
    }

    public SourceValidity getValidity() {
        return null;
    }

    public boolean exists() {
        return true;
    }
}

