/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.dom;

import org.eclipse.jdt.core.dom.BindingResolver;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.impl.ReferenceContext;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;

class VariableBinding
implements IVariableBinding {
    private org.eclipse.jdt.internal.compiler.lookup.VariableBinding binding;
    private BindingResolver resolver;
    private String name;
    private ITypeBinding declaringClass;
    private ITypeBinding type;
    private String key;

    VariableBinding(BindingResolver resolver, org.eclipse.jdt.internal.compiler.lookup.VariableBinding binding) {
        this.resolver = resolver;
        this.binding = binding;
    }

    public boolean isField() {
        return this.binding instanceof FieldBinding;
    }

    public String getName() {
        if (this.name == null) {
            this.name = new String(this.binding.name);
        }
        return this.name;
    }

    public ITypeBinding getDeclaringClass() {
        if (this.isField()) {
            if (this.declaringClass == null) {
                FieldBinding fieldBinding = (FieldBinding)this.binding;
                this.declaringClass = this.resolver.getTypeBinding(fieldBinding.declaringClass);
            }
            return this.declaringClass;
        }
        return null;
    }

    public ITypeBinding getType() {
        if (this.type == null) {
            this.type = this.resolver.getTypeBinding(this.binding.type);
        }
        return this.type;
    }

    public int getKind() {
        return 3;
    }

    public int getModifiers() {
        if (this.isField()) {
            return ((FieldBinding)this.binding).getAccessFlags();
        }
        if (this.binding.isFinal()) {
            return 16;
        }
        return 0;
    }

    public boolean isDeprecated() {
        if (this.isField()) {
            return ((FieldBinding)this.binding).isDeprecated();
        }
        return false;
    }

    public boolean isSynthetic() {
        if (this.isField()) {
            return ((FieldBinding)this.binding).isSynthetic();
        }
        return false;
    }

    public String getKey() {
        if (this.key == null) {
            if (this.isField()) {
                StringBuffer buffer = new StringBuffer();
                if (this.getDeclaringClass() != null) {
                    buffer.append(this.getDeclaringClass().getKey());
                    buffer.append('/');
                }
                buffer.append(this.getName());
                this.key = buffer.toString();
            } else {
                SourceTypeBinding internalBinding;
                ITypeBinding typeBinding;
                StringBuffer buffer = new StringBuffer();
                LocalVariableBinding localVarBinding = (LocalVariableBinding)this.binding;
                BlockScope scope = localVarBinding.declaringScope;
                MethodScope methodScope = scope instanceof MethodScope ? (MethodScope)scope : scope.enclosingMethodScope();
                ReferenceContext referenceContext = methodScope.referenceContext;
                if (referenceContext instanceof AbstractMethodDeclaration) {
                    MethodBinding internalBinding2 = ((AbstractMethodDeclaration)referenceContext).binding;
                    IMethodBinding methodBinding = this.resolver.getMethodBinding(internalBinding2);
                    if (methodBinding != null) {
                        buffer.append(methodBinding.getKey());
                    }
                } else if (referenceContext instanceof TypeDeclaration && (typeBinding = this.resolver.getTypeBinding(internalBinding = ((TypeDeclaration)referenceContext).binding)) != null) {
                    buffer.append(typeBinding.getKey());
                }
                this.getKey(scope, buffer);
                buffer.append('/');
                buffer.append(this.getName());
                this.key = buffer.toString();
            }
        }
        return this.key;
    }

    private void getKey(BlockScope scope, StringBuffer buffer) {
        int scopeIndex = scope.scopeIndex();
        if (scopeIndex != -1) {
            this.getKey((BlockScope)scope.parent, buffer);
            buffer.append('/');
            buffer.append(scopeIndex);
        }
    }

    public int getVariableId() {
        return this.binding.id;
    }

    public Object getConstantValue() {
        if (!this.binding.isConstantValue() || this.binding.constant == null) {
            return null;
        }
        Constant c = this.binding.constant;
        switch (c.typeID()) {
            case 5: {
                return c.booleanValue();
            }
            case 3: {
                return new Byte(c.byteValue());
            }
            case 2: {
                return new Character(c.charValue());
            }
            case 8: {
                return new Double(c.doubleValue());
            }
            case 9: {
                return new Float(c.floatValue());
            }
            case 10: {
                return new Integer(c.intValue());
            }
            case 7: {
                return new Long(c.longValue());
            }
            case 4: {
                return new Short(c.shortValue());
            }
            case 11: {
                return c.stringValue();
            }
        }
        return null;
    }

    public String toString() {
        return this.binding.toString();
    }
}

