/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.treeprocessor;

import java.util.Map;
import org.apache.avalon.excalibur.component.RoleManageable;
import org.apache.avalon.excalibur.component.RoleManager;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.component.Recomposable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.container.ContainerUtil;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.Processor;
import org.apache.cocoon.components.CocoonComponentManager;
import org.apache.cocoon.components.ExtendedComponentSelector;
import org.apache.cocoon.components.LifecycleHelper;
import org.apache.cocoon.components.PropertyAwareSAXConfigurationHandler;
import org.apache.cocoon.components.pipeline.ProcessingPipeline;
import org.apache.cocoon.components.source.SourceUtil;
import org.apache.cocoon.components.source.impl.DelayedRefreshSourceWrapper;
import org.apache.cocoon.components.treeprocessor.ConcreteTreeProcessor;
import org.apache.cocoon.components.treeprocessor.ProcessingNode;
import org.apache.cocoon.components.treeprocessor.TreeBuilder;
import org.apache.cocoon.environment.Environment;
import org.apache.cocoon.util.Settings;
import org.apache.cocoon.util.SettingsHelper;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.xml.sax.ContentHandler;

public class TreeProcessor
extends AbstractLogEnabled
implements ThreadSafe,
Processor,
Composable,
Configurable,
RoleManageable,
Contextualizable,
Disposable {
    public static final String COCOON_REDIRECT_ATTR = "sitemap:cocoon-redirect";
    private static final String XCONF_URL = "resource://org/apache/cocoon/components/treeprocessor/treeprocessor-builtins.xml";
    protected TreeProcessor parent;
    protected Context context;
    protected ComponentManager manager;
    protected RoleManager roleManager;
    protected ExtendedComponentSelector builderSelector;
    protected long lastModified = 0L;
    protected DelayedRefreshSourceWrapper source;
    protected long lastModifiedDelay;
    protected Configuration currentLanguage;
    protected boolean checkReload;
    protected SourceResolver resolver;
    ConcreteTreeProcessor concreteProcessor;

    public TreeProcessor() {
        this.checkReload = true;
        this.lastModifiedDelay = 1000L;
    }

    protected TreeProcessor(TreeProcessor parent, ComponentManager manager) {
        this.parent = parent;
        this.enableLogging(parent.getLogger());
        this.context = parent.context;
        this.roleManager = parent.roleManager;
        this.builderSelector = parent.builderSelector;
        this.checkReload = parent.checkReload;
        this.lastModifiedDelay = parent.lastModifiedDelay;
        this.manager = manager;
    }

    public TreeProcessor createChildProcessor(ComponentManager manager, String actualSource, boolean checkReload) throws Exception {
        TreeProcessor child = new TreeProcessor(this, manager);
        child.checkReload = checkReload;
        child.resolver = (SourceResolver)manager.lookup(SourceResolver.ROLE);
        child.source = new DelayedRefreshSourceWrapper(child.resolver.resolveURI(actualSource), this.lastModifiedDelay);
        return child;
    }

    public void contextualize(Context context) throws ContextException {
        this.context = context;
    }

    public void compose(ComponentManager manager) throws ComponentException {
        this.manager = manager;
        this.resolver = (SourceResolver)this.manager.lookup(SourceResolver.ROLE);
    }

    public void setRoleManager(RoleManager rm) {
        this.roleManager = rm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configure(Configuration config) throws ConfigurationException {
        Configuration builtin;
        this.checkReload = config.getAttributeAsBoolean("check-reload", true);
        String xconfURL = config.getAttribute("config", XCONF_URL);
        this.lastModifiedDelay = config.getChild("reload").getAttributeAsLong("delay", 1000L);
        String fileName = config.getAttribute("file", "sitemap.xmap");
        try {
            this.source = new DelayedRefreshSourceWrapper(this.resolver.resolveURI(fileName), this.lastModifiedDelay);
        }
        catch (Exception e) {
            throw new ConfigurationException("Cannot resolve " + fileName, (Throwable)e);
        }
        try {
            Source source = this.resolver.resolveURI(xconfURL);
            try {
                Settings settings = SettingsHelper.getSettings(this.context);
                PropertyAwareSAXConfigurationHandler handler = new PropertyAwareSAXConfigurationHandler(settings, this.getLogger());
                SourceUtil.toSAX(this.manager, source, null, (ContentHandler)((Object)handler));
                builtin = handler.getConfiguration();
            }
            finally {
                this.resolver.release(source);
            }
        }
        catch (Exception e) {
            String msg = "Error while reading " + xconfURL + ": " + e.getMessage();
            throw new ConfigurationException(msg, (Throwable)e);
        }
        this.builderSelector = new ExtendedComponentSelector(Thread.currentThread().getContextClassLoader());
        try {
            LifecycleHelper.setupComponent((Object)this.builderSelector, this.getLogger(), this.context, this.manager, this.roleManager, builtin);
        }
        catch (ConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigurationException("Could not setup builder selector", (Throwable)e);
        }
    }

    public boolean process(Environment environment) throws Exception {
        this.setupConcreteProcessor(environment);
        return this.concreteProcessor.process(environment);
    }

    public ProcessingPipeline buildPipeline(Environment environment) throws Exception {
        this.setupConcreteProcessor(environment);
        return this.concreteProcessor.buildPipeline(environment);
    }

    public Processor getRootProcessor() {
        TreeProcessor result = this;
        while (result.parent != null) {
            result = result.parent;
        }
        return result;
    }

    public void setComponentConfigurations(Configuration componentConfigurations) {
        this.concreteProcessor.setComponentConfigurations(componentConfigurations);
    }

    public Map getComponentConfigurations() {
        return this.concreteProcessor.getComponentConfigurations();
    }

    private void setupConcreteProcessor(Environment env) throws Exception {
        if (this.parent == null) {
            env.changeContext("", this.source.getURI());
        }
        if (this.concreteProcessor == null || this.checkReload && this.source.getLastModified() != this.lastModified) {
            this.buildConcreteProcessor(env);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void buildConcreteProcessor(Environment env) throws Exception {
        long newLastModified;
        if (this.concreteProcessor != null && this.source.getLastModified() == this.lastModified) {
            return;
        }
        long startTime = System.currentTimeMillis();
        if (this.concreteProcessor != null) {
            this.concreteProcessor.markForDisposal();
        }
        TreeBuilder builder = (TreeBuilder)this.builderSelector.select("sitemap");
        ConcreteTreeProcessor newProcessor = new ConcreteTreeProcessor(this);
        this.setupLogger(newProcessor);
        CocoonComponentManager.enterEnvironment(env, this.manager, this);
        try {
            if (builder instanceof Recomposable) {
                ((Recomposable)builder).recompose(this.manager);
            }
            builder.setProcessor(newProcessor);
            newLastModified = this.source.getLastModified();
            ProcessingNode root = builder.build(this.source);
            newProcessor.setProcessorData(builder.getSitemapComponentManager(), root, builder.getDisposableNodes());
        }
        finally {
            CocoonComponentManager.leaveEnvironment();
            this.builderSelector.release(builder);
        }
        if (this.getLogger().isDebugEnabled()) {
            double time = (double)(this.lastModified - startTime) / 1000.0;
            this.getLogger().debug("TreeProcessor built in " + time + " secs from " + this.source.getURI());
        }
        this.concreteProcessor = newProcessor;
        this.lastModified = newLastModified;
    }

    public void dispose() {
        ContainerUtil.dispose((Object)this.concreteProcessor);
        this.concreteProcessor = null;
        if (this.manager != null) {
            if (this.source != null) {
                this.resolver.release(this.source.getSource());
                this.source = null;
            }
            if (this.parent == null) {
                this.builderSelector.dispose();
                this.builderSelector = null;
            }
            this.manager.release((Component)this.resolver);
            this.resolver = null;
            this.manager = null;
        }
    }

    public String toString() {
        return "TreeProcessor - " + (this.source == null ? "[unknown location]" : this.source.getURI());
    }
}

