/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnant.commands;

import java.io.File;
import java.util.Stack;
import java.util.Vector;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.FileSet;
import org.tigris.subversion.svnant.SvnAntException;
import org.tigris.subversion.svnant.SvnAntValidationException;
import org.tigris.subversion.svnant.commands.SvnCommand;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNStatusKind;
import org.tigris.subversion.svnclientadapter.utils.SVNStatusUtils;

public class Commit
extends SvnCommand {
    private String message = null;
    private File file = null;
    private File dir = null;
    private boolean recurse = true;
    private Vector filesets = new Vector();

    public void execute() throws SvnAntException {
        if (this.file != null) {
            this.svnCommitFile(this.file);
        }
        if (this.dir != null) {
            this.svnCommitDir(this.dir, this.recurse);
        }
        if (this.filesets.size() > 0) {
            for (int i = 0; i < this.filesets.size(); ++i) {
                FileSet fileSet = (FileSet)this.filesets.elementAt(i);
                this.svnCommitFileSet(fileSet);
            }
        }
    }

    protected void validateAttributes() throws SvnAntValidationException {
        if (this.file == null && this.dir == null && this.filesets.size() == 0) {
            throw new SvnAntValidationException("file, url or fileset must be set");
        }
        if (this.file != null && (this.dir != null || this.filesets.size() != 0)) {
            throw new SvnAntValidationException("dir and fileset must not be set when file attribute is present");
        }
        if (this.dir != null && (this.file != null || this.filesets.size() != 0)) {
            throw new SvnAntValidationException("file and fileset must not be set when dir attribute is present");
        }
        if (this.message == null) {
            throw new SvnAntValidationException("Message must be set");
        }
    }

    private void svnCommitFile(File file) throws SvnAntException {
        if (file.exists()) {
            if (file.isDirectory()) {
                this.logWarning("Directory " + file.getAbsolutePath() + " cannot be commited using the file attribute.  " + "Use dir instead.");
            } else {
                try {
                    this.svnClient.commit(new File[]{file}, this.message, false);
                }
                catch (Exception exception) {
                    throw new SvnAntException("Can't commit file " + file.getAbsolutePath(), exception);
                }
            }
        } else {
            throw new SvnAntException("Warning: Could not find file " + file.getAbsolutePath() + " to commit to the repository.");
        }
    }

    private void svnCommitDir(File file, boolean bl) throws SvnAntException {
        if (file.exists()) {
            if (!file.isDirectory()) {
                this.logWarning("File " + file.getAbsolutePath() + " cannot be commited using the dir attribute.  " + "Use file instead.");
            } else {
                try {
                    this.svnClient.commit(new File[]{file}, this.message, bl);
                }
                catch (Exception exception) {
                    throw new SvnAntException("Can't commit directory " + file.getAbsolutePath(), exception);
                }
            }
        } else {
            throw new SvnAntException("Warning: Could not find directory " + file.getAbsolutePath() + " to add to the repository.");
        }
    }

    private void svnPrepareCommitFileWithDirs(Vector vector, File file, File file2) throws SvnAntException {
        Stack<File> stack;
        if (vector.contains(file)) {
            return;
        }
        try {
            if (!SVNStatusUtils.isManaged((ISVNStatus)this.svnClient.getSingleStatus(file))) {
                return;
            }
        }
        catch (SVNClientException sVNClientException) {
            throw new SvnAntException("Cannot get status of file :" + file.toString(), sVNClientException);
        }
        File file3 = null;
        try {
            stack = new Stack<File>();
            ISVNStatus iSVNStatus = this.svnClient.getSingleStatus(file3);
            for (file3 = file.getParentFile(); file3 != null && iSVNStatus.getTextStatus() == SVNStatusKind.ADDED && !file3.equals(file2); file3 = file3.getParentFile()) {
                stack.push(file3);
                iSVNStatus = this.svnClient.getSingleStatus(file3);
            }
        }
        catch (SVNClientException sVNClientException) {
            throw new SvnAntException("Cannot get status of directory :" + file3, sVNClientException);
        }
        while (stack.size() > 0) {
            file3 = (File)stack.pop();
            if (vector.contains(file3)) continue;
            vector.add(file3);
        }
        vector.add(file);
    }

    private void svnCommitFileSet(FileSet fileSet) throws SvnAntException {
        File file;
        int n;
        DirectoryScanner directoryScanner = fileSet.getDirectoryScanner(this.getProject());
        File file2 = fileSet.getDir(this.getProject());
        String[] stringArray = directoryScanner.getIncludedFiles();
        String[] stringArray2 = directoryScanner.getIncludedDirectories();
        Vector vector = new Vector();
        for (n = 0; n < stringArray2.length; ++n) {
            file = new File(file2, stringArray2[n]);
            this.svnPrepareCommitFileWithDirs(vector, file, file2);
        }
        for (n = 0; n < stringArray.length; ++n) {
            file = new File(file2, stringArray[n]);
            this.svnPrepareCommitFileWithDirs(vector, file, file2);
        }
        File[] fileArray = new File[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            fileArray[i] = (File)vector.get(i);
        }
        try {
            this.svnClient.commit(fileArray, this.message, false);
        }
        catch (Exception exception) {
            throw new SvnAntException("Can't commit fileset : ", exception);
        }
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setDir(File file) {
        this.dir = file;
    }

    public void setRecurse(boolean bl) {
        this.recurse = bl;
    }

    public void setMessage(String string) {
        this.message = string;
    }

    public void addFileset(FileSet fileSet) {
        this.filesets.addElement(fileSet);
    }

    public void add(FileSet fileSet) {
        this.filesets.addElement(fileSet);
    }
}

