/*
Copyright (C) 2000-2010  Ministere de la culture et de la communication (France), AJLSM
See LICENCE file
*/
package fr.gouv.culture.sdx.pipeline;


/**A transformation using an XSLTProcessorImpl from Cocoon
 *
 * Basically a wrapper to provide a certain configuration option
 * (stylesheet specification) and forwards events to a consumer
 * after the transformation has been executed.
 *
 * This class uses the Saxon processor through the role
 * "org.apache.excalibur.xml.xslt.XSLTProcessor/saxon". The component
 * MUST be declared in the cocoon.xconf file.
 *
 */
public class SAXONXSLTTransformation extends AbstractXSLTTransformation {

    /**Creates the transformation
     *
     * If logging is desired the super.getLog() should be set after creation.
     *
     * This transformation should be composed, properties set, and then configured.
     *
     * @see #enableLogging
     * @see #service
     * @see #contextualize
     * @see #configure
     */
    public SAXONXSLTTransformation() {
    }

    /**
     * Returns the XSLT processor factory to use. We return the explicit
     * factory class name for Saxon (8).
     */
    public String getTransformerFactory() {
//        return "com.icl.saxon.TransformerFactoryImpl";	// saxon 6
        return "net.sf.saxon.TransformerFactoryImpl";		// saxon 8
    }
}
