<?xml version="1.0" encoding="UTF-8"?>
<!--
Copyright (C) 2000-2010  Ministere de la culture et de la communication (France), AJLSM
See LICENCE file
-->
<!--+
    | Formatage de la réponse de l'entrepôt OAI
    +-->
<xsl:stylesheet version="1.0"
xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
xmlns:oai2="http://www.openarchives.org/OAI/2.0/"
xmlns:sdx="http://www.culture.gouv.fr/ns/sdx/sdx"
xmlns:sdxoai="http://www.culture.gouv.fr/ns/oai/"
xmlns:xsp="http://apache.org/xsp"
exclude-result-prefixes="sdx sdxoai xsp">

	<xsl:template match="/">
		<xsl:apply-templates />
	</xsl:template>

	<xsl:template match="oai2:OAI-PMH">
		<xsl:copy>
			<xsl:apply-templates select="@*" />
			<xsl:apply-templates select="oai2:responseDate" />
			<xsl:apply-templates select="oai2:request" />
			<xsl:apply-templates select="node()[not(self::oai2:responseDate) and not(self::oai2:request)]" />
		</xsl:copy>
	</xsl:template>

	<xsl:template match="oai2:request/@verb">
    <xsl:if test=".!='IllegalVerb'">
      <xsl:copy><xsl:value-of select="."/></xsl:copy>
    </xsl:if>
  </xsl:template>

	<xsl:template match="oai2:record[not(oai2:metadata/*) and not(oai2:header/@status='deleted')]">
		<xsl:element name="error" namespace="http://www.openarchives.org/OAI/2.0/">An error occured with the document <xsl:value-of select="oai2:header/oai2:identifier" /></xsl:element>
	</xsl:template>

	<xsl:template match="*[local-name()='dummyRoot']" priority="+2">
		<xsl:apply-templates />
	</xsl:template>

	<xsl:template match="*">
		<xsl:element name="{local-name()}">
			<xsl:apply-templates select="@* | node()" />
		</xsl:element>
	</xsl:template>

  <xsl:template match="@xml:*">
    <xsl:copy-of select="." copy-namespaces="no"/>
  </xsl:template>

	<xsl:template match="@*">
		<xsl:attribute name="{local-name()}">
			<xsl:value-of select="." />
		</xsl:attribute>
	</xsl:template>

	<xsl:template match="text()|processing-instruction()">
		<xsl:copy/>
	</xsl:template>

</xsl:stylesheet>
