/*
 * Decompiled with CFR 0.152.
 */
package org.grlea.log;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class DebugLevel {
    public static final DebugLevel L1_FATAL = new DebugLevel(1, "Fatal");
    public static final DebugLevel L2_ERROR = new DebugLevel(2, "Error");
    public static final DebugLevel L3_WARN = new DebugLevel(3, "Warn");
    public static final DebugLevel L4_INFO = new DebugLevel(4, "Info");
    public static final DebugLevel L5_DEBUG = new DebugLevel(5, "Debug");
    public static final DebugLevel L6_VERBOSE = new DebugLevel(6, "Verbose");
    public static final DebugLevel L7_LUDICROUS = new DebugLevel(7, "Ludicrous");
    static final DebugLevel FAKE_TRACE = new DebugLevel(Integer.MAX_VALUE, "Trace");
    private static final Map levelsByName;
    private final int level;
    private final String name;

    private DebugLevel(int n, String string) {
        this.level = n;
        this.name = string;
    }

    boolean shouldLog(DebugLevel debugLevel) {
        return debugLevel.level <= this.level;
    }

    public static DebugLevel fromInt(int n) {
        switch (n) {
            case 1: {
                return L1_FATAL;
            }
            case 2: {
                return L2_ERROR;
            }
            case 3: {
                return L3_WARN;
            }
            case 4: {
                return L4_INFO;
            }
            case 5: {
                return L5_DEBUG;
            }
            case 6: {
                return L6_VERBOSE;
            }
            case 7: {
                return L7_LUDICROUS;
            }
        }
        if (n < 1) {
            return L1_FATAL;
        }
        return L7_LUDICROUS;
    }

    static DebugLevel fromName(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("name cannot be null.");
        }
        DebugLevel debugLevel = (DebugLevel)levelsByName.get(string.toLowerCase());
        if (debugLevel == null) {
            throw new IllegalArgumentException("Unrecognised DebugLevel name: '" + string + "'");
        }
        return debugLevel;
    }

    public int hashCode() {
        return this.level;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !object.getClass().equals(this.getClass())) {
            return false;
        }
        return this.level == ((DebugLevel)object).level;
    }

    public String toString() {
        return this.name;
    }

    static {
        HashMap<String, DebugLevel> hashMap = new HashMap<String, DebugLevel>(10, 0.8f);
        hashMap.put("fatal", L1_FATAL);
        hashMap.put("error", L2_ERROR);
        hashMap.put("warn", L3_WARN);
        hashMap.put("info", L4_INFO);
        hashMap.put("debug", L5_DEBUG);
        hashMap.put("verbose", L6_VERBOSE);
        hashMap.put("ludicrous", L7_LUDICROUS);
        levelsByName = Collections.unmodifiableMap(hashMap);
    }
}

