/*
 * Decompiled with CFR 0.152.
 */
package org.grlea.log.rollover;

import java.io.IOException;
import java.util.Date;
import java.util.Map;
import org.grlea.log.rollover.RolloverStrategy;

class FileSizeRolloverStrategy
implements RolloverStrategy {
    private static final String KEY_FILE_SIZE = "simplelog.rollover.fileSize.size";
    private static final String FILE_SIZE_DEFAULT = "100M";
    private static final char[] factorUnits = new char[]{'B', 'K', 'M', 'G', 'T'};
    private long rolloverSize;
    private boolean rolloverSizeSetProgramatically = false;

    FileSizeRolloverStrategy() {
        this.rolloverSize = -1L;
    }

    public FileSizeRolloverStrategy(long l) {
        this.setRolloverSize(l);
    }

    public void configure(Map map) throws IOException {
        if (this.rolloverSizeSetProgramatically) {
            return;
        }
        String string = (String)map.get(KEY_FILE_SIZE);
        string = string == null ? FILE_SIZE_DEFAULT : string.trim();
        if (string.length() == 0) {
            string = FILE_SIZE_DEFAULT;
        }
        long l = this.decodeFileSize(string);
        this.setRolloverSizeInernal(l);
    }

    private long decodeFileSize(String string) throws IOException {
        try {
            int n = string.length() - 1;
            String string2 = string.substring(0, n);
            long l = Long.parseLong(string2);
            char c = string.charAt(n);
            c = Character.toUpperCase(c);
            boolean bl = false;
            for (int i = 0; !bl && i < factorUnits.length; ++i) {
                char c2 = factorUnits[i];
                if (c != c2) continue;
                bl = true;
                l *= 1L << i * 10;
            }
            if (!bl) {
                throw new IOException("The specified file size does not conform to the required pattern: " + string);
            }
            return l;
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException("Specified file size does not conform to the required pattern: " + string);
        }
    }

    public boolean rolloverNow(Date date, long l) {
        if (this.rolloverSize == -1L) {
            throw new IllegalStateException("FileSizeRolloverStrategy has not been configured.");
        }
        return l >= this.rolloverSize;
    }

    public long getRolloverSize() {
        return this.rolloverSize;
    }

    public void setRolloverSize(long l) {
        this.setRolloverSizeInernal(l);
        this.rolloverSizeSetProgramatically = true;
    }

    private void setRolloverSizeInernal(long l) {
        if (l < 1L) {
            throw new IllegalArgumentException("rolloverSize must be > 0");
        }
        this.rolloverSize = l;
    }
}

