/*
 * Decompiled with CFR 0.152.
 */
package org.ahunt.simpleRowLog.common;

import java.text.MessageFormat;
import java.util.Date;
import org.ahunt.simpleRowLog.common.GroupInfo;
import org.ahunt.simpleRowLog.conf.Configuration;

public class MemberInfo {
    private int key;
    private String surname;
    private String forename;
    private Date dob;
    private GroupInfo groupInfo;

    public MemberInfo(int key, String surname, String forename, Date dob, GroupInfo groupInfo) {
        this.key = key;
        if (surname == null || surname.length() == 0) {
            throw new IllegalArgumentException("Member surname cannot be null or empty.");
        }
        this.surname = surname;
        this.forename = forename != null ? forename : "";
        if (dob == null) {
            throw new IllegalArgumentException("Date of birth cannot be null.");
        }
        this.dob = dob;
        if (groupInfo == null) {
            throw new IllegalArgumentException("groupInfo cannot be null.");
        }
        this.groupInfo = groupInfo;
    }

    public int getKey() {
        return this.key;
    }

    public String getSurname() {
        return this.surname;
    }

    public String getForename() {
        return this.forename;
    }

    public Date getDob() {
        return this.dob;
    }

    public GroupInfo getGroupInfo() {
        return this.groupInfo;
    }

    public String getName() {
        if (this.forename.length() == 0) {
            return this.surname;
        }
        try {
            Configuration c = Configuration.getConf("main");
            return MessageFormat.format(c.getProperty("srl.name_format"), this.surname, this.forename);
        }
        catch (Exception exception) {
            return this.surname + "," + this.forename;
        }
    }
}

