/*
 * Decompiled with CFR 0.152.
 */
package org.ahunt.simpleRowLog.gui.simpleGUI;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.IOException;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.ResourceBundle;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.MaskFormatter;
import org.ahunt.simpleRowLog.common.BoatInfo;
import org.ahunt.simpleRowLog.common.MemberInfo;
import org.ahunt.simpleRowLog.common.OutingInfo;
import org.ahunt.simpleRowLog.db.simpleDB.Database;
import org.ahunt.simpleRowLog.gui.simpleGUI.SuggestiveTextField;

public class OutingDialog
extends JDialog {
    private JDialog dialog = this;
    private boolean isNewOuting;
    private DateFormat format = new SimpleDateFormat("HH:mm");
    private BoatInfo[] boats;
    private MemberInfo[] members;
    private SuggestiveTextField boatEntry;
    private JLabel boatEntryLabel = new JLabel();
    private SuggestiveTextField[] rowerEntry = new SuggestiveTextField[8];
    private JLabel[] rowerEntryLabel = new JLabel[8];
    private SuggestiveTextField coxEntry;
    private JLabel coxEntryLabel;
    private FormattedTimeField timeOutEntry;
    private JLabel timeOutEntryLabel;
    private FormattedTimeField timeInEntry;
    private JLabel timeInEntryLabel;
    private JFormattedTextField distanceEntry = new JFormattedTextField((Object)1);
    private JLabel distanceEntryLabel = new JLabel();
    private JTextArea destinationEntry = new JTextArea(3, 32);
    private JLabel destinationEntryLabel = new JLabel();
    private JTextArea commentEntry = new JTextArea(3, 32);
    private JLabel commentEntryLabel = new JLabel();
    private JButton confirmButton = new JButton();
    private JButton cancelButton = new JButton();
    private OutingInfo outing;
    private boolean validDistance = true;
    private static final long serialVersionUID = 1L;
    private org.ahunt.simpleRowLog.interfaces.Database db;
    private ResourceBundle rb;

    public static void main(String[] args) throws Exception {
        OutingInfo[] outings;
        UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
        try {
            Runtime.getRuntime().exec("rm -rf ./database/srl");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Database d = Database.getInstance();
        d.addBoat("Andy", "4x+", true);
        d.addBoat("Andrew", "4x+", true);
        d.addMember("Hunt", "Andrew", new Date(), 1);
        d.addMember("Hunt", "James", new Date(), 1);
        d.addMember("Cricket", "Andrew", new Date(), 1);
        d.addMember("Hunt", "Kenneth", new Date(), 1);
        d.addMember("Hunt", "Kasia", new Date(), 1);
        d.addMember("Random", "Guy", new Date(), 1);
        d.addMember("Random", "Girl", new Date(), 1);
        System.out.println("2");
        OutingDialog od = new OutingDialog(d);
        od.doNewOuting();
        for (OutingInfo o : outings = d.getOutings(new Date())) {
            System.out.println(o.getBoat().getName() + ":" + o.getRowers()[0].getName());
        }
        od.doNewOuting();
        for (OutingInfo o : outings = d.getOutings(new Date())) {
            System.out.println(o.getBoat().getName() + ":" + o.getRowers()[0].getName());
        }
        System.exit(0);
    }

    public OutingDialog(org.ahunt.simpleRowLog.interfaces.Database db) {
        this.db = db;
        this.rb = ResourceBundle.getBundle("gui");
        this.confirmButton.setIcon(new ImageIcon("img/icons/gnome-confirm-24.png"));
        this.cancelButton.setIcon(new ImageIcon("img/icons/gnome-cancel-24.png"));
        this.boatEntryLabel.setText("<html><b>" + this.rb.getString("outing.boat") + ":</b></html>");
        this.boatEntry = new SuggestiveTextField(this, true, null, 16);
        this.confirmButton.setText(this.rb.getString("outing.confirm"));
        this.confirmButton.addActionListener(new ButtonListener());
        this.cancelButton.addActionListener(new ButtonListener());
        this.distanceEntry.setValue(new Integer(0));
        JPanel rowerPanel = this.setupRowerPanel();
        JPanel infoPanel = this.setupInfoPanel();
        GroupLayout l = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(l);
        l.setAutoCreateGaps(true);
        l.setAutoCreateContainerGaps(true);
        l.setHorizontalGroup(l.createSequentialGroup().addGroup(l.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(l.createSequentialGroup().addComponent(this.boatEntryLabel).addComponent(this.boatEntry).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE)).addComponent(rowerPanel).addComponent(infoPanel).addGroup(l.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.confirmButton).addComponent(this.cancelButton))));
        l.setVerticalGroup(l.createSequentialGroup().addGroup(l.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.boatEntryLabel).addComponent(this.boatEntry)).addComponent(rowerPanel).addComponent(infoPanel).addGroup(l.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.confirmButton).addComponent(this.cancelButton)));
        this.setModal(true);
        this.pack();
        this.setResizable(false);
        this.setAlwaysOnTop(true);
    }

    private JPanel setupRowerPanel() {
        JPanel rowerPanel = new JPanel();
        for (int i = 0; i < 8; ++i) {
            if (i == 0) {
                this.rowerEntry[i] = new SuggestiveTextField(rowerPanel, true, null, 32);
                this.rowerEntry[i].addFocusListener(new NameEntryListener(this.rowerEntry[i]));
            } else {
                this.rowerEntry[i] = new SuggestiveTextField(rowerPanel, false, null, 32);
                this.rowerEntry[i].addFocusListener(new NameEntryListener(this.rowerEntry[i]));
            }
            this.rowerEntryLabel[i] = new JLabel("<html><b>" + MessageFormat.format(this.rb.getString("outing.rowerNum") + ":</b></html>", i + 1));
        }
        this.coxEntry = new SuggestiveTextField(rowerPanel, false, null, 32);
        this.coxEntry.addFocusListener(new NameEntryListener(this.coxEntry));
        this.coxEntryLabel = new JLabel("<html><b><i>" + this.rb.getString("outing.cox") + ":</i></b></html>");
        rowerPanel.setBorder(new TitledBorder(new LineBorder(Color.BLACK), this.rb.getString("outing.rowers")));
        GroupLayout r = new GroupLayout(rowerPanel);
        rowerPanel.setLayout(r);
        r.setHorizontalGroup(r.createSequentialGroup().addGroup(r.createParallelGroup().addComponent(this.rowerEntryLabel[0]).addComponent(this.rowerEntryLabel[1]).addComponent(this.rowerEntryLabel[2]).addComponent(this.rowerEntryLabel[3]).addComponent(this.rowerEntryLabel[4]).addComponent(this.rowerEntryLabel[5]).addComponent(this.rowerEntryLabel[6]).addComponent(this.rowerEntryLabel[7]).addComponent(this.coxEntryLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(r.createParallelGroup().addComponent(this.rowerEntry[0]).addComponent(this.rowerEntry[1]).addComponent(this.rowerEntry[2]).addComponent(this.rowerEntry[3]).addComponent(this.rowerEntry[4]).addComponent(this.rowerEntry[5]).addComponent(this.rowerEntry[6]).addComponent(this.rowerEntry[7]).addComponent(this.coxEntry)));
        r.setVerticalGroup(r.createSequentialGroup().addGroup(r.createParallelGroup().addComponent(this.rowerEntryLabel[0]).addComponent(this.rowerEntry[0])).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(r.createParallelGroup().addComponent(this.rowerEntryLabel[1]).addComponent(this.rowerEntry[1])).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(r.createParallelGroup().addComponent(this.rowerEntryLabel[2]).addComponent(this.rowerEntry[2])).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(r.createParallelGroup().addComponent(this.rowerEntryLabel[3]).addComponent(this.rowerEntry[3])).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(r.createParallelGroup().addComponent(this.rowerEntryLabel[4]).addComponent(this.rowerEntry[4])).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(r.createParallelGroup().addComponent(this.rowerEntryLabel[5]).addComponent(this.rowerEntry[5])).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(r.createParallelGroup().addComponent(this.rowerEntryLabel[6]).addComponent(this.rowerEntry[6])).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(r.createParallelGroup().addComponent(this.rowerEntryLabel[7]).addComponent(this.rowerEntry[7])).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(r.createParallelGroup().addComponent(this.coxEntryLabel).addComponent(this.coxEntry)));
        return rowerPanel;
    }

    private JPanel setupInfoPanel() {
        JPanel ret = new JPanel();
        this.distanceEntryLabel.setText("<html><b>" + this.rb.getString("outing.distance") + ":</b></html>");
        this.destinationEntryLabel.setText("<html><b>" + this.rb.getString("outing.destination") + ":</b></html>");
        this.commentEntryLabel.setText("<html><b>" + this.rb.getString("outing.comment") + ":</b></html>");
        this.destinationEntry.setLineWrap(true);
        this.destinationEntry.setWrapStyleWord(true);
        this.commentEntry.setLineWrap(true);
        this.commentEntry.setWrapStyleWord(true);
        HashSet<KeyStroke> strokes = new HashSet<KeyStroke>(Arrays.asList(KeyStroke.getKeyStroke("pressed TAB")));
        this.destinationEntry.setFocusTraversalKeys(0, strokes);
        this.commentEntry.setFocusTraversalKeys(0, strokes);
        JScrollPane destinationEntryScrollPane = new JScrollPane(this.destinationEntry);
        destinationEntryScrollPane.setVerticalScrollBarPolicy(22);
        destinationEntryScrollPane.setHorizontalScrollBarPolicy(31);
        JScrollPane commentEntryScrollPane = new JScrollPane(this.commentEntry);
        commentEntryScrollPane.setVerticalScrollBarPolicy(22);
        commentEntryScrollPane.setHorizontalScrollBarPolicy(31);
        try {
            this.timeOutEntry = new FormattedTimeField(true);
        }
        catch (Exception e) {
            // empty catch block
        }
        this.timeOutEntry.setHorizontalAlignment(0);
        this.timeOutEntryLabel = new JLabel("<html><b>" + this.rb.getString("outing.timeOut") + ":</b></html>");
        try {
            this.timeInEntry = new FormattedTimeField(false);
        }
        catch (Exception e) {
            // empty catch block
        }
        this.timeInEntry.setHorizontalAlignment(0);
        this.timeInEntryLabel = new JLabel("<html><b>" + this.rb.getString("outing.timeIn") + ":</b></html>");
        GroupLayout l = new GroupLayout(ret);
        ret.setLayout(l);
        l.setAutoCreateGaps(true);
        l.setHorizontalGroup(l.createSequentialGroup().addGroup(l.createParallelGroup().addComponent(this.distanceEntryLabel).addComponent(this.timeOutEntryLabel).addComponent(this.destinationEntryLabel).addComponent(this.commentEntryLabel)).addGroup(l.createParallelGroup().addGroup(l.createSequentialGroup().addComponent(this.distanceEntry).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE)).addGroup(l.createSequentialGroup().addComponent(this.timeOutEntry).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.timeInEntryLabel).addComponent(this.timeInEntry).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, -1, Short.MAX_VALUE)).addComponent(destinationEntryScrollPane).addComponent(commentEntryScrollPane)));
        l.setVerticalGroup(l.createSequentialGroup().addGroup(l.createParallelGroup().addComponent(this.distanceEntryLabel).addComponent(this.distanceEntry)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(l.createParallelGroup().addComponent(this.timeOutEntryLabel).addComponent(this.timeOutEntry).addComponent(this.timeInEntryLabel).addComponent(this.timeInEntry)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(l.createParallelGroup().addComponent(this.destinationEntryLabel).addComponent(destinationEntryScrollPane)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(l.createParallelGroup().addComponent(this.commentEntryLabel).addComponent(commentEntryScrollPane)));
        return ret;
    }

    public void doNewOuting() {
        this.outing = null;
        this.isNewOuting = true;
        this.setTitle(this.rb.getString("outingDialog.title.newOuting"));
        this.cancelButton.setText(this.rb.getString("outing.cancel_new"));
        this.boatEntry.setText("");
        for (int i = 0; i < 8; ++i) {
            this.rowerEntry[i].setText("");
        }
        this.distanceEntry.setText("");
        this.timeOutEntry.setText("");
        this.timeInEntry.setText("");
        this.coxEntry.setText("");
        this.destinationEntry.setText("");
        this.commentEntry.setText("");
        this.updateDBInfo();
        this.boatEntry.setBackground(Color.YELLOW);
        this.rowerEntry[0].setBackground(Color.YELLOW);
        this.timeOutEntry.setBackground(Color.YELLOW);
        this.boatEntry.requestFocusInWindow();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(screenSize.width / 2 - this.getSize().width / 2, screenSize.height / 2 - this.getSize().height / 2);
        this.setVisible(true);
    }

    public void doModifyOuting(OutingInfo outing) {
        this.outing = outing;
        this.updateDBInfo();
        this.isNewOuting = false;
        this.cancelButton.setText(this.rb.getString("outing.cancel_modify"));
        this.boatEntry.setText(outing.getBoat().getName());
        for (int i = 0; i < 8; ++i) {
            if (outing.getRowers()[i] != null) {
                this.rowerEntry[i].setText(outing.getRowers()[i].getName());
                continue;
            }
            this.rowerEntry[i].setText("");
        }
        this.distanceEntry.setValue(outing.getDistance());
        this.timeOutEntry.setText(this.format.format(outing.getOut()));
        if (outing.getIn() != null) {
            this.timeInEntry.setText(this.format.format(outing.getIn()));
        } else {
            this.timeInEntry.setText("");
        }
        if (outing.getCox() != null) {
            this.coxEntry.setText(outing.getCox().getName());
        } else {
            this.coxEntry.setText("");
        }
        this.destinationEntry.setText(outing.getDestination());
        this.commentEntry.setText(outing.getComment());
        this.distanceEntry.requestFocusInWindow();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(screenSize.width / 2 - this.getSize().width / 2, screenSize.height / 2 - this.getSize().height / 2);
        this.setVisible(true);
    }

    private void updateDBInfo() {
        this.boats = this.db.getBoats(true);
        ArrayList<String> a = new ArrayList<String>();
        for (BoatInfo b : this.boats) {
            a.add(b.getName());
        }
        this.boatEntry.setOptions(a.toArray(new String[0]));
        this.members = this.db.getMembers();
        a.clear();
        for (MemberInfo m : this.members) {
            a.add(m.getName());
        }
        String[] options = a.toArray(new String[0]);
        for (SuggestiveTextField t : this.rowerEntry) {
            t.setOptions(options);
        }
        this.coxEntry.setOptions(options);
    }

    private boolean isValidInput() {
        return this.boatEntry.isValid() && this.coxEntry.isValid() && this.rowerEntry[0].isValid() && this.rowerEntry[1].isValid() && this.rowerEntry[2].isValid() && this.rowerEntry[3].isValid() && this.rowerEntry[4].isValid() && this.rowerEntry[5].isValid() && this.rowerEntry[6].isValid() && this.rowerEntry[7].isValid() && this.timeOutEntry.isValid() && this.timeInEntry.isValid() && this.validDistance;
    }

    private int getRowerForName(String s) {
        if (s.equals("")) {
            return 0;
        }
        for (MemberInfo m : this.members) {
            if (!m.getName().equals(s)) continue;
            return m.getKey();
        }
        return 1;
    }

    private class NameEntryListener
    implements FocusListener {
        private SuggestiveTextField entry;

        public NameEntryListener(SuggestiveTextField entry) {
            this.entry = entry;
        }

        @Override
        public void focusGained(FocusEvent arg0) {
        }

        @Override
        public void focusLost(FocusEvent arg0) {
            if (!this.entry.isValid()) {
                // empty if block
            }
        }
    }

    private class InvalidEntryException
    extends Exception {
        public InvalidEntryException(String string) {
            super(string);
        }
    }

    private class ButtonListener
    implements ActionListener {
        private ButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            if (arg0.getSource() == OutingDialog.this.cancelButton && OutingDialog.this.isNewOuting) {
                System.out.println("deleting new outing");
                OutingDialog.this.setVisible(false);
            } else if (arg0.getSource() == OutingDialog.this.cancelButton && !OutingDialog.this.isNewOuting) {
                OutingDialog.this.setVisible(false);
            } else if (arg0.getSource() == OutingDialog.this.confirmButton) {
                if (OutingDialog.this.isValidInput()) {
                    System.out.println("Saving new outing");
                    try {
                        int distance = OutingDialog.this.distanceEntry.getText().equals("") ? 0 : Integer.parseInt(OutingDialog.this.distanceEntry.getText());
                        if (OutingDialog.this.isNewOuting) {
                            System.out.println("new outing");
                            OutingDialog.this.db.addOuting(new Date(), new int[]{OutingDialog.this.getRowerForName(OutingDialog.this.rowerEntry[0].getText()), OutingDialog.this.getRowerForName(OutingDialog.this.rowerEntry[1].getText()), OutingDialog.this.getRowerForName(OutingDialog.this.rowerEntry[2].getText()), OutingDialog.this.getRowerForName(OutingDialog.this.rowerEntry[3].getText()), OutingDialog.this.getRowerForName(OutingDialog.this.rowerEntry[4].getText()), OutingDialog.this.getRowerForName(OutingDialog.this.rowerEntry[5].getText()), OutingDialog.this.getRowerForName(OutingDialog.this.rowerEntry[6].getText()), OutingDialog.this.getRowerForName(OutingDialog.this.rowerEntry[7].getText())}, OutingDialog.this.getRowerForName(OutingDialog.this.coxEntry.getText()), OutingDialog.this.timeOutEntry.getTime(), OutingDialog.this.timeInEntry.getTime(), OutingDialog.this.commentEntry.getText(), OutingDialog.this.destinationEntry.getText(), OutingDialog.this.boatEntry.getText(), distance);
                        } else {
                            System.out.println("modify");
                            OutingDialog.this.db.modifyOuting(OutingDialog.this.outing.getId(), OutingDialog.this.outing.getDay().getTime(), new int[]{OutingDialog.this.getRowerForName(OutingDialog.this.rowerEntry[0].getText()), OutingDialog.this.getRowerForName(OutingDialog.this.rowerEntry[1].getText()), OutingDialog.this.getRowerForName(OutingDialog.this.rowerEntry[2].getText()), OutingDialog.this.getRowerForName(OutingDialog.this.rowerEntry[3].getText()), OutingDialog.this.getRowerForName(OutingDialog.this.rowerEntry[4].getText()), OutingDialog.this.getRowerForName(OutingDialog.this.rowerEntry[5].getText()), OutingDialog.this.getRowerForName(OutingDialog.this.rowerEntry[6].getText()), OutingDialog.this.getRowerForName(OutingDialog.this.rowerEntry[7].getText())}, OutingDialog.this.getRowerForName(OutingDialog.this.coxEntry.getText()), OutingDialog.this.timeOutEntry.getTime(), OutingDialog.this.timeInEntry.getTime(), OutingDialog.this.commentEntry.getText(), OutingDialog.this.destinationEntry.getText(), OutingDialog.this.boatEntry.getText(), distance);
                        }
                        OutingDialog.this.setVisible(false);
                    }
                    catch (InvalidEntryException invalidEntryException) {}
                } else {
                    JOptionPane.showMessageDialog(null, OutingDialog.this.rb.getString("outing.invalid_input"), OutingDialog.this.rb.getString("outing.invalid_input.title"), 0);
                }
            }
        }
    }

    private class FormattedTimeField
    extends JFormattedTextField
    implements DocumentListener {
        private boolean mustBeFilled;
        private boolean isValid;
        private boolean isFilled;

        public FormattedTimeField(boolean mustBeFilled) throws ParseException {
            super(new MaskFormatter("##:##"));
            this.mustBeFilled = mustBeFilled;
            this.isValid = !mustBeFilled;
            this.getDocument().addDocumentListener(this);
            this.setFocusLostBehavior(3);
        }

        public Date getTime() throws InvalidEntryException {
            if (!this.isValid()) {
                throw new InvalidEntryException("Time field must be valid.");
            }
            if (this.isValid() && this.isFilled) {
                try {
                    return OutingDialog.this.format.parse(this.getText());
                }
                catch (ParseException e) {
                    return null;
                }
            }
            return null;
        }

        @Override
        public void changedUpdate(DocumentEvent arg0) {
            try {
                OutingDialog.this.format.parse(this.getText());
                this.isValid = true;
            }
            catch (ParseException e) {
                this.isValid = false;
            }
            String s = this.getText();
            int length = s.length();
            int colonPosition = s.indexOf(":");
            if (colonPosition != -1) {
                try {
                    int hours = Integer.parseInt(s.substring(0, colonPosition));
                    int minutes = Integer.parseInt(s.substring(colonPosition + 1, length));
                    if (hours >= 23 || minutes >= 60) {
                        this.isValid = false;
                    }
                }
                catch (NumberFormatException e) {
                    this.isValid = false;
                }
            } else {
                this.isValid = false;
            }
            if (!this.mustBeFilled && this.getText().equals("  :  ")) {
                this.isValid = true;
            }
            this.isFilled = !this.getText().equals("  :  ");
            if (this.getText().equals("  :  ") && !this.mustBeFilled) {
                this.setBackground(Color.WHITE);
            } else if (this.mustBeFilled && this.getText().equals("  :  ")) {
                this.setBackground(Color.YELLOW);
            } else if (this.isValid) {
                this.setBackground(Color.WHITE);
            } else {
                this.setBackground(Color.RED);
            }
        }

        @Override
        public void insertUpdate(DocumentEvent arg0) {
            this.changedUpdate(arg0);
        }

        @Override
        public void removeUpdate(DocumentEvent arg0) {
            this.changedUpdate(arg0);
        }

        @Override
        public boolean isValid() {
            return this.isValid;
        }

        public boolean isFilled() {
            return this.isFilled;
        }
    }
}

