/*
 * Decompiled with CFR 0.152.
 */
package org.ahunt.simpleRowLog.gui.simpleGUI;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileNotFoundException;
import java.text.SimpleDateFormat;
import java.util.ResourceBundle;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.ahunt.simpleRowLog.common.MemberInfo;
import org.ahunt.simpleRowLog.common.OutingInfo;
import org.ahunt.simpleRowLog.conf.Configuration;
import org.ahunt.simpleRowLog.gui.simpleGUI.AboutDialog;
import org.ahunt.simpleRowLog.gui.simpleGUI.AddMemberDialog;
import org.ahunt.simpleRowLog.gui.simpleGUI.DaySelectionPanel;
import org.ahunt.simpleRowLog.gui.simpleGUI.ErrorHandler;
import org.ahunt.simpleRowLog.gui.simpleGUI.OutingDialog;
import org.ahunt.simpleRowLog.interfaces.Database;

public class SimpleGUI
extends JFrame
implements ChangeListener {
    static final long serialVersionUID = 1L;
    private ResourceBundle rb = ResourceBundle.getBundle("gui");
    private Configuration conf;
    private JMenu menuFile = new JMenu();
    private JMenuItem menuFileExit = new JMenuItem();
    private JMenuItem menuFileNewMember = new JMenuItem();
    private JMenu menuOptions = new JMenu();
    private JMenuItem menuOptionsAdmin = new JMenuItem();
    private JMenu menuHelp = new JMenu();
    private JMenuItem menuHelpHelp = new JMenuItem();
    private JMenuItem menuHelpAbout = new JMenuItem();
    private JScrollPane outingTablePane;
    private JTable outingTable;
    private OutingTableManager outingTableManager;
    private JButton editOutingButton = new JButton();
    private JButton newOutingButton = new JButton();
    private JLabel windowFooter = new JLabel();
    private OutingDialog outingDialog;
    private AboutDialog aboutDialog = new AboutDialog();
    private AddMemberDialog addMemberDialog;
    private Database db;
    private DaySelectionPanel daySelection = new DaySelectionPanel();

    public SimpleGUI(Database db) {
        System.out.println("Starting gui");
        try {
            this.conf = Configuration.getConf("simpleGUI");
        }
        catch (FileNotFoundException e) {
            ErrorHandler.handleError(e);
        }
        this.db = db;
        this.setupMenus();
        this.updateLanguages();
        this.reloadConfig();
        this.outingDialog = new OutingDialog(db);
        this.addMemberDialog = new AddMemberDialog(db);
        this.newOutingButton.addActionListener(new ButtonListener());
        this.editOutingButton.addActionListener(new ButtonListener());
        this.daySelection.addChangeListener(this);
        this.outingTableManager = new OutingTableManager();
        this.outingTable = new JTable(this.outingTableManager){
            private static final long serialVersionUID = 1L;

            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
                Component c = super.prepareRenderer(renderer, row, column);
                if (!c.getBackground().equals(this.getSelectionBackground())) {
                    Object timeOut = this.getModel().getValueAt(row, 3);
                    c.setBackground(timeOut == null ? Color.LIGHT_GRAY : Color.WHITE);
                }
                return c;
            }
        };
        this.outingTable.setAutoResizeMode(4);
        int vColIndex = 1;
        TableColumn col = this.outingTable.getColumnModel().getColumn(vColIndex);
        int width = 200;
        col.setPreferredWidth(width);
        this.outingTable.getColumnModel().getColumn(0).setPreferredWidth(50);
        this.outingTablePane = new JScrollPane(this.outingTable);
        this.outingTable.setRowHeight(100);
        this.outingTablePane.setVerticalScrollBarPolicy(22);
        this.outingTablePane.setHorizontalScrollBarPolicy(31);
        this.outingTable.addMouseListener(new ClickListener());
        this.outingTablePane.addMouseListener(new ClickListener());
        this.setupLayout();
        this.setDefaultCloseOperation(0);
        this.windowFooter.setText("Rowing logbook of the Gobi desert rowing club [http://gobi.desertrowing.com/]");
    }

    private void setupLayout() {
        Container p = this.getContentPane();
        GroupLayout l = new GroupLayout(p);
        p.setLayout(l);
        l.setAutoCreateGaps(true);
        l.setAutoCreateContainerGaps(true);
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        l.setVerticalGroup(l.createSequentialGroup().addComponent(this.outingTablePane, 300, d.height, d.height).addGroup(l.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.daySelection).addGroup(l.createSequentialGroup().addGroup(l.createParallelGroup().addComponent(this.newOutingButton).addComponent(this.editOutingButton)).addComponent(this.windowFooter))));
        l.setHorizontalGroup(l.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.outingTablePane, 400, d.width, d.width).addGroup(l.createSequentialGroup().addComponent(this.daySelection).addGroup(l.createParallelGroup().addGroup(l.createSequentialGroup().addComponent(this.newOutingButton).addComponent(this.editOutingButton)).addComponent(this.windowFooter, GroupLayout.Alignment.TRAILING))));
    }

    private void reloadConfig() {
        if (this.conf.getProperty("fullscreen").equals("true")) {
            this.setFullScreen(true);
        }
    }

    private void setupMenus() {
        this.setJMenuBar(new JMenuBar());
        JMenuBar mb = this.getJMenuBar();
        MenuListener ml = new MenuListener();
        mb.add(this.menuFile);
        this.menuFile.add(this.menuFileNewMember);
        this.menuFileNewMember.addActionListener(ml);
        this.menuFile.add(this.menuFileExit);
        this.menuFileExit.addActionListener(ml);
        mb.add(this.menuOptions);
        this.menuOptions.add(this.menuOptionsAdmin);
        this.menuOptionsAdmin.addActionListener(ml);
        mb.add(this.menuHelp);
        this.menuHelp.add(this.menuHelpHelp);
        this.menuHelpHelp.addActionListener(ml);
        this.menuHelp.add(this.menuHelpAbout);
        this.menuHelpAbout.addActionListener(ml);
    }

    private void setFullScreen(boolean setFullScreen) {
        this.setUndecorated(setFullScreen);
        this.setResizable(!setFullScreen);
        this.setSize(Toolkit.getDefaultToolkit().getScreenSize());
        this.setLocation(0, 0);
    }

    private void updateMenuLanguages() {
        this.menuFile.setText(this.rb.getString("file"));
        this.menuFileExit.setText(this.rb.getString("file.exit"));
        this.menuFileNewMember.setText(this.rb.getString("file.newMember"));
        this.menuOptions.setText(this.rb.getString("options"));
        this.menuOptionsAdmin.setText(this.rb.getString("options.admin"));
        this.menuHelp.setText(this.rb.getString("help"));
        this.menuHelpHelp.setText(this.rb.getString("help.help"));
        this.menuHelpAbout.setText(this.rb.getString("help.about"));
    }

    private void updateLanguages() {
        this.updateMenuLanguages();
        String prepend = "<html><font size=+2>";
        String append = "</font></html>";
        this.editOutingButton.setText(prepend + this.rb.getString("main.editOuting") + append);
        this.newOutingButton.setText(prepend + this.rb.getString("main.newOuting") + append);
    }

    @Override
    public void stateChanged(ChangeEvent arg0) {
        this.outingTableManager.updateOutings();
    }

    static /* synthetic */ ResourceBundle access$800(SimpleGUI x0) {
        return x0.rb;
    }

    private class MenuListener
    implements ActionListener {
        private MenuListener() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            if (arg0.getSource() == SimpleGUI.this.menuHelpAbout) {
                SimpleGUI.this.aboutDialog.setVisible(true);
            } else if (arg0.getSource() == SimpleGUI.this.menuFileNewMember) {
                int n = SimpleGUI.this.addMemberDialog.addMember();
            } else if (arg0.getSource() == SimpleGUI.this.menuFileExit) {
                System.exit(0);
            }
        }
    }

    private class ClickListener
    implements MouseListener {
        private ClickListener() {
        }

        @Override
        public void mouseClicked(MouseEvent arg0) {
            if (arg0.getClickCount() != 2) {
                return;
            }
            if (arg0.getSource() == SimpleGUI.this.outingTablePane) {
                SimpleGUI.this.outingDialog.doNewOuting();
            } else if (arg0.getSource() == SimpleGUI.this.outingTable) {
                SimpleGUI.this.outingTableManager.editOutingAt(SimpleGUI.this.outingTable.getSelectedRow());
            }
            SimpleGUI.this.outingTableManager.updateOutings();
        }

        @Override
        public void mouseEntered(MouseEvent arg0) {
        }

        @Override
        public void mouseExited(MouseEvent arg0) {
        }

        @Override
        public void mousePressed(MouseEvent arg0) {
        }

        @Override
        public void mouseReleased(MouseEvent arg0) {
        }
    }

    private class OutingTableManager
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        private OutingInfo[] outings;
        private String columnNamePrepend = "<html><font size=+1>";
        private String columnNameAppend = "</font></html>";
        private String[] columnNames = new String[]{SimpleGUI.access$800(SimpleGUI.this).getString("outing.boat"), SimpleGUI.access$800(SimpleGUI.this).getString("outing.rowers"), SimpleGUI.access$800(SimpleGUI.this).getString("outing.timeOut"), SimpleGUI.access$800(SimpleGUI.this).getString("outing.timeIn"), SimpleGUI.access$800(SimpleGUI.this).getString("outing.comment"), SimpleGUI.access$800(SimpleGUI.this).getString("outing.destination"), SimpleGUI.access$800(SimpleGUI.this).getString("outing.distance")};

        public OutingTableManager() {
            this.updateOutings();
        }

        @Override
        public int getColumnCount() {
            return 7;
        }

        @Override
        public int getRowCount() {
            return this.outings.length;
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNamePrepend + this.columnNames[col].toString() + this.columnNameAppend;
        }

        public void editOutingAt(int row) {
            SimpleGUI.this.outingDialog.doModifyOuting(this.outings[row]);
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (col == 0) {
                return this.outings[row].getBoat().getName();
            }
            if (col == 1) {
                StringBuffer buff = new StringBuffer();
                buff.append("<html><table align=top>");
                MemberInfo[] rowers = this.outings[row].getRowers();
                for (int i = 0; i < 4; i = (int)((short)(i + 1))) {
                    if (i >= rowers.length || rowers[i] == null) continue;
                    buff.append("<tr><td>");
                    buff.append(rowers[i].getName());
                    buff.append("</td>");
                    if (i < rowers.length + 4 && rowers[i + 4] != null) {
                        buff.append("<td>");
                        buff.append(rowers[i + 4].getName());
                        buff.append("</td>");
                    }
                    buff.append("</tr>");
                }
                if (this.outings[row].getCox() != null) {
                    buff.append("<tr><td><i>" + this.outings[row].getCox().getName() + "</i></td</tr");
                }
                buff.append("</table></html>");
                return buff.toString();
            }
            if (col == 2) {
                SimpleDateFormat df = new SimpleDateFormat(SimpleGUI.this.conf.getProperty("time_format_outings"));
                return df.format(this.outings[row].getOut());
            }
            if (col == 3) {
                if (this.outings[row].getIn() != null) {
                    SimpleDateFormat df = new SimpleDateFormat(SimpleGUI.this.conf.getProperty("time_format_outings"));
                    return df.format(this.outings[row].getIn());
                }
            } else {
                if (col == 4) {
                    return this.outings[row].getDestination();
                }
                if (col == 5) {
                    return this.outings[row].getComment();
                }
                if (col == 6) {
                    int d = this.outings[row].getDistance();
                    if (d != 0) {
                        return d;
                    }
                    return null;
                }
            }
            return null;
        }

        public void updateOutings() {
            try {
                this.outings = SimpleGUI.this.db.getOutings(SimpleGUI.this.daySelection.getDate());
                this.fireTableDataChanged();
            }
            catch (Exception e) {
                ErrorHandler.handleError(e);
            }
        }
    }

    private class ExitListener
    extends WindowAdapter {
        private ExitListener() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            this.onClose();
        }

        private void onClose() {
            System.out.println("onClose()");
        }
    }

    private class ButtonListener
    implements ActionListener {
        private ButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            if (arg0.getSource() == SimpleGUI.this.newOutingButton) {
                SimpleGUI.this.outingDialog.doNewOuting();
            } else if (arg0.getSource() == SimpleGUI.this.editOutingButton && SimpleGUI.this.outingTable.getSelectedRow() >= 0) {
                SimpleGUI.this.outingTableManager.editOutingAt(SimpleGUI.this.outingTable.getSelectedRow());
            }
            SimpleGUI.this.outingTableManager.updateOutings();
        }
    }
}

