// bmp2aviDlg.cpp : implementation file
//

#include "stdafx.h"
#include "bmp2avi.h"
#include "bmp2aviDlg.h"
#include "WriteAVI.h"
#include "cimage.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CBmp2aviDlg dialog

CBmp2aviDlg::CBmp2aviDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CBmp2aviDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CBmp2aviDlg)
	m_AVIFileName = _T("");
	m_FrameRate = 50;
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CBmp2aviDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CBmp2aviDlg)
	DDX_Control(pDX, IDC_FILELIST, m_FileList);
	DDX_Text(pDX, IDC_AVIFILENAME, m_AVIFileName);
	DDX_Text(pDX, IDC_FRAMERATE, m_FrameRate);
	DDV_MinMaxUInt(pDX, m_FrameRate, 1, 1000);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CBmp2aviDlg, CDialog)
	//{{AFX_MSG_MAP(CBmp2aviDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_MAKEAVI, OnMakeavi)
	ON_BN_CLICKED(IDC_ADDBITMAPS, OnAddbitmaps)
	ON_BN_CLICKED(IDC_CLEARLIST, OnClearlist)
	ON_BN_CLICKED(IDC_BROWSE, OnBrowse)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CBmp2aviDlg message handlers

BOOL CBmp2aviDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	UpdateData(FALSE);
	((CSpinButtonCtrl*)GetDlgItem(IDC_SPINDOCTOR))->SetRange(1,1000);
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CBmp2aviDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CBmp2aviDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CBmp2aviDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CBmp2aviDlg::OnMakeavi() 
{
	// TODO: Add your control notification handler code here
	UpdateData();
	if (m_AVIFileName.IsEmpty()) {
		AfxMessageBox("You must specify an output file name.",IDOK);
		return;
	}

	CString search_string(m_AVIFileName);
	search_string.MakeLower();
	if (search_string.Find(".avi")==-1)
		m_AVIFileName += ".avi";

	CAVIFile aviFile(m_AVIFileName);
	aviFile.SetFrameRate(m_FrameRate);
	int count = m_FileList.GetCount();
	int index=0;
	
	if (m_FileList.GetCount()==0) {
		AfxMessageBox("You haven't selected any files yet!",IDOK);
		return;
	}

	BeginWaitCursor();
		while (index < count) {
			RestoreWaitCursor();
			CBitmap* aBmp;
			CString filename;
			m_FileList.GetText(index++, filename);

			CString search_string(filename);
			search_string.MakeLower();

			if (search_string.Find(".bmp")!=-1) {
				aBmp = GetBitmapFromBMPFile(filename);
			}
			else if (search_string.Find(".png")!=-1) {
				aBmp = GetBitmapFromPNGFile(filename);
			}
			else {
				AfxMessageBox("Unsupported graphics file format.",IDOK);
				return;
			}

			aviFile.AddFrame(*aBmp);
			aBmp->DeleteObject();
			delete aBmp;
		}
	EndWaitCursor();

	if (aviFile.IsOK())
		AfxMessageBox("Avi file created successfully.");
	else
		AfxMessageBox("Problems encountered.  The resulting\n"
					  "avi file is quite likely not valid.");
}

void CBmp2aviDlg::OnAddbitmaps() 
{
	// TODO: Add your control notification handler code here
	CFileDialog  dlg(TRUE,
					 NULL,
					 NULL,
					 OFN_HIDEREADONLY
						| OFN_PATHMUSTEXIST
						| OFN_ALLOWMULTISELECT,
					 _T("Portable Network Graphics (*.png)|*.png|Windows bitmap (*.bmp)|*.bmp|All Files|*.*||"));

	m_lpstrFile = new TCHAR[20480];
	m_lpstrFile[0] = '\0';
	dlg.m_ofn.lpstrFile = m_lpstrFile;
	dlg.m_ofn.nMaxFile = 20480;
	
	CString file_name;
	if (dlg.DoModal() == IDOK) {
		POSITION p = dlg.GetStartPosition();
		while (p!=NULL) {
			file_name=dlg.GetNextPathName(p);
			m_FileList.AddString(file_name);
		}
	}
}

void CBmp2aviDlg::OnClearlist() 
{
	while(m_FileList.DeleteString(0));
}


CBitmap* CBmp2aviDlg::GetBitmapFromPNGFile(CString filename)
{
	CImage img;
	img.ReadFile(filename, CIMAGE_FORMAT_PNG);
	return img.MakeBitmap();
}

CBitmap* CBmp2aviDlg::GetBitmapFromBMPFile(CString filename)
{
	CImage img;
	img.ReadFile(filename, CIMAGE_FORMAT_BMP);
	return img.MakeBitmap();
}

void CBmp2aviDlg::OnBrowse() 
{
	CFileDialog  dlg(FALSE,
					 "avi",
					 NULL,
					 OFN_HIDEREADONLY
						| OFN_PATHMUSTEXIST,
					 _T("AVI files (*.avi)|*.avi||"));

	if (dlg.DoModal() == IDOK) {
		m_AVIFileName = dlg.GetPathName();
		UpdateData(FALSE);
	}
}
