//  Swarm library. Copyright (C) 1996 Santa Fe Institute.
// This library is distributed without any warranty; 
// without even the implied warranty of merchantability 
// or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.

/*
Name:            RandomBitDistribution.h
Description:     Distribution object returning fair (?) coin tosses
Library:         random
Original Author: Nelson Minar
Modified by:     Sven Thommesen
Date:            1997-01-15
*/

/*
123456789|123456789|123456789|123456789|123456789|123456789|123456789|123456789|
*/


#import <random/RandomDefs.h>
#import <random/ProbabilityDistribution.h>

@interface RandomBitDistribution: ProbabilityDistribution //<RandomBits>

{

// Parameters:

   unsigned theMask;

// Working variables:


}

// Methods that conform to the RandomBits protocol:

- (BOOL) getCoinToss;

// Methods that conform to the IntegerDistribution protocol:

-(int) getIntegerSample;

// Methods that override superclass methods:

// -(void) getState: (void *) state;
// -(void) setState: (void *) state;

// -initState;
// -resetState;

// temporary methods:

-(int) getAlternateIntegerSample;

@end
