//  Swarm library. Copyright (C) 1996 Santa Fe Institute.
// This library is distributed without any warranty; 
// without even the implied warranty of merchantability 
// or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.

/*
Name:            ExponentialDistribution.h
Description:     Exponential distribution returning double values
Library:         random
Original Author: Sven Thommesen
Date:            1997-01-15
*/

/*
123456789|123456789|123456789|123456789|123456789|123456789|123456789|123456789|
*/


#import <random/RandomDefs.h>
#import <random/ProbabilityDistribution.h>

@interface ExponentialDistribution: ProbabilityDistribution //<Exponential>

{

// Parameters:

   double theMean;

// Working variables:


}

// Methods that conform to the Normal protocol:

+create: aZone setGenerator: generator
	setMean: (double) mean;

-(void) setMean: (double) mean;

-(double) getMean;

-(double) getSampleWithMean: (double) mean;

// Methods that conform to the DoubleDistribution protocol:

-(double) getDoubleSample;

// Methods that override superclass methods:

// -(void) getState: (void *) state;
// -(void) setState: (void *) state;

// -initState;
// -resetState;

@end
