// Swarm library. Copyright (C) 1996 Santa Fe Institute.
// This library is distributed without any warranty; without even the
// implied warranty of merchantability or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.


#include <string.h>
#include <stdio.h>
#include <stdlib.h>

#import <swarmgraph/Entry.h>

@implementation Entry

-createEnd {
  [super createEnd];
#ifdef _TK_
  // create the Entry
  [globalTkInterp eval: "entry %s; %s configure -width 10 -relief sunken;", widgetName, widgetName];
  [globalTkInterp eval: "%s configure -textvariable %s;", widgetName, variableName];
#endif
  return self;
}


-setValue: (char *) t {
#ifdef _TK_
  [globalTkInterp eval: "%s delete 0 end; %s insert 0 \"%s\"",
		  widgetName, widgetName, t];
#endif
  return self;
}

// ignore the height: doesn't work for entries.
-setWidth: (unsigned) w Height: (unsigned) h {
#ifdef _TK_
  [globalTkInterp eval: "%s configure -width %u", widgetName, w];
#endif
  return self;
}

@end

