
#import <swarmgraph/global.h>

#import <swarmgraph/JavaClass.h>
#import <swarmgraph/JavaBar.h>

@implementation JavaBar;

- init  {

  // look up our class id
  id jBarClass = [JavaClass new: "JavaJBar"];

  // call the constructor that takes a width and height
  jobject barobj = [jBarClass construct];

  // establish the JavaObject of this class backed by this real object
  [super init: jBarClass : barobj];

  _reset = 0;
  _addBar = 0;
  _update = 0;
  return self;
}

// start a fresh graph
-reset {
  if (_reset == 0)
    _reset = [classid findMethod: "reset" signature: "()V"];

  [self callVoidMethod: _reset];
  return self;
}

// add the next bar value
-addBar: (char *)label value: (double)dval color: (char *)color {
  if (_addBar == 0)
    _addBar = [classid findMethod: "addBar" signature: "(Ljava/lang/String;Ljava/lang/String;D)V"];

  [self callVoidMethod: _addBar S: label S: color D: dval];

#if 0
  //  XXX until we figure out where it should really happen
  [self update];
#endif
  return self;
}

// show the current graphed bars on the screen
-update {
  if (_update == 0)
    _update = [classid findMethod: "update" signature: "()V"];

  [self callVoidMethod: _update];
  return self;
}


@end
