
#import <swarmgraph/global.h>

#import <swarmgraph/JavaClass.h>
#import <swarmgraph/JavaGraph.h>

@implementation JavaGraph;

- initW: (int)w H: (int)h  {

  // look up our class id
  id jRasterClass = [JavaClass new: "JavaJGraph"];

  // call the constructor that takes a width and height
  jobject graphobj = [jRasterClass construct: (int)w : (int)h];

  // establish the JavaObject of this class backed by this real object
  [super init: jRasterClass : graphobj];

  _setRanges = 0;
  _setTitle = 0;
  _setAxisLabels = 0;
  _setScaleMode = 0;
  _setElemLen = 0;
  _createElem = 0;
  _addElem = 0;
  _dropElem = 0;
  _setColor = 0;

  _update = 0;

  return self;
}

// set the minimum/maximum values
-setRangesXMin: (double)minx Max: (double)maxx 
	YMin: (double)miny Max: (double)maxy {
  if (_setRanges == 0)
    _setRanges = [classid findMethod: "setRanges" signature: "(DDDD)V"];

  [self callVoidMethod: _setRanges D: minx D: maxx D: miny D: maxy];
  return self;
}

// set the scale
-setScaleModeX: (int)x Y: (int)y { 
  if (_setScaleMode == 0)
    _setScaleMode = [classid findMethod: "setScaleMode" signature: "(II)V"];

  [self callVoidMethod: _setScaleMode D: x D: y];
  return self;
}


- title: (char *)t {
  if (_setTitle == 0)
    _setTitle = [classid findMethod: "setTitle" signature: "(Ljava/lang/String;)V"];

  [self callVoidMethod: _setTitle S: t];
  return self;
}


// draw a point on our backing image
- axisLabelsX: (char *) xl Y: (char *) yl {
  if (_setAxisLabels == 0)
    _setAxisLabels = [classid findMethod: "setAxisLabels" signature: "(Ljava/lang/String;Ljava/lang/String;)V"];

  [self callVoidMethod: _setAxisLabels S: xl S: yl];
  return self;
}

// draw a rectangle on our backing image
- setElem: (char *)name Len: (int)n {
  if (_setElemLen == 0)
    _setElemLen = [classid findMethod: "setElemLen" 
			      signature: "(Ljava/lang/String;I)V"];

  [self callVoidMethod: _setElemLen S: name I: n];
  return self;
}

// add a data set (line) to the graph
- createElement: (char *)name {
  if (_createElem == 0)
    _createElem = [classid findMethod: "createElement" signature: "(Ljava/lang/String;)V"];
  [self callVoidMethod: _createElem S: name];
  return self;
}

// add another datum to the graph
- addElem: (char *)name X: (double)x Y: (double)y {
  if (_addElem == 0)
    _addElem = [classid findMethod: "addElem" signature: "(Ljava/lang/String;DD)V"];
  [self callVoidMethod: _addElem S: name D: x D: y];
  return self;
}

// add another datum to the graph
- dropElem: (char *)name {
  if (_dropElem == 0)
    _dropElem = [classid findMethod: "dropElem" signature: "(Ljava/lang/String;)V"];
  [self callVoidMethod: _dropElem S: name];
  return self;
}

// set the line color for one of our data streams
- setColor: (char *)name Color: (char *)color {
  if (_setColor == 0)
    _setColor = [classid findMethod: "setColor" signature: "(Ljava/lang/String;Ljava/lang/String;)V"];
  [self callVoidMethod: _setColor S: name S: color];
  return self;
}

// update the graph on the screen
- update {
  if (_update == 0)
    _update = [classid findMethod: "update" signature: "()V"];
  [self callVoidMethod: _update];
  return self;
}

@end
