###--- >>> `deriv' <<<----- Symbolic and Algorithmic Derivatives of Simple Expressions

	## alias	 help(D)
	## alias	 help(deriv)
	## alias	 help(deriv.default)
	## alias	 help(deriv.formula)

##___ Examples ___:

## formula argument :
dx2x <- deriv(~ x^2, "x") ; dx2x
##Don't run: expression({
##D          .value <- x^2
##D          .grad <- array(0, c(length(.value), 1), list(NULL, c("x")))
##D          .grad[, "x"] <- 2 * x
##D          attr(.value, "gradient") <- .grad
##D          .value
##D })
mode(dx2x)
x <- -1:2
eval(dx2x)

## Something `tougher':
trig.exp <- expression(sin(cos(x + y^2)))
( D.sc <- D(trig.exp, c("x", "y")) )

( dxy <- deriv(trig.exp, c("x", "y")) )
y <- 1
eval(dxy)
eval(D.sc)

## Keywords: 'math', 'nonlinear'.


