/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.CodeAttr;
import gnu.bytecode.Label;
import gnu.expr.Compilation;
import gnu.expr.ConditionalTarget;
import gnu.expr.ExitExp;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.IgnoreTarget;
import gnu.expr.Interpreter;
import gnu.expr.QuoteExp;
import gnu.expr.ReferenceExp;
import gnu.expr.Target;
import gnu.mapping.Environment;
import gnu.mapping.Values;
import java.io.PrintWriter;

public class IfExp
extends Expression {
    Expression test;
    Expression then_clause;
    Expression else_clause;

    public IfExp(Expression expression, Expression expression2, Expression expression3) {
        this.test = expression;
        this.then_clause = expression2;
        this.else_clause = expression3;
    }

    public void compile(Compilation compilation, Target target) {
        IfExp.compile(this.test, this.then_clause, this.else_clause == null ? QuoteExp.voidExp : this.else_clause, compilation, target);
    }

    public static void compile(Expression expression, Expression expression2, Expression expression3, Compilation compilation, Target target) {
        Label label;
        boolean bl;
        Label label2;
        Object object2;
        boolean bl2;
        Interpreter interpreter = compilation.getInterpreter();
        CodeAttr codeAttr = compilation.getCode();
        if (target instanceof ConditionalTarget && expression3 instanceof QuoteExp) {
            bl2 = true;
            object2 = ((QuoteExp)expression3).getValue();
            label2 = interpreter.isTrue(object2) ? ((ConditionalTarget)target).ifTrue : ((ConditionalTarget)target).ifFalse;
        } else if (expression3 instanceof ExitExp && ((ExitExp)expression3).result instanceof QuoteExp && ((ExitExp)expression3).block.subTarget instanceof IgnoreTarget) {
            bl2 = true;
            label2 = ((ExitExp)expression3).block.exitLabel;
        } else {
            bl2 = false;
            label2 = new Label(codeAttr);
        }
        if (expression == expression2 && target instanceof ConditionalTarget && expression2 instanceof ReferenceExp) {
            bl = true;
            label = ((ConditionalTarget)target).ifTrue;
        } else {
            bl = false;
            label = new Label(codeAttr);
        }
        object2 = new ConditionalTarget(label, label2, interpreter);
        if (bl) {
            ((ConditionalTarget)object2).trueBranchComesFirst = false;
        }
        expression.compile(compilation, (Target)object2);
        codeAttr.emitIfThen();
        if (!bl) {
            label.define(codeAttr);
            expression2.compileWithPosition(compilation, target);
        }
        if (!bl2) {
            codeAttr.emitElse();
            label2.define(codeAttr);
            if (expression3 == null) {
                compilation.compileConstant(Values.empty, target);
            } else {
                expression3.compileWithPosition(compilation, target);
            }
        } else {
            codeAttr.setUnreachable();
        }
        codeAttr.emitFi();
    }

    public Object eval(Environment environment) {
        Interpreter interpreter = this.getInterpreter();
        if (interpreter.isTrue(this.test.eval(environment))) {
            return this.then_clause.eval(environment);
        }
        if (this.else_clause != null) {
            return this.else_clause.eval(environment);
        }
        return interpreter.noValue();
    }

    protected final Interpreter getInterpreter() {
        return Interpreter.defaultInterpreter;
    }

    public void print(PrintWriter printWriter) {
        printWriter.print("(#%if ");
        this.test.print(printWriter);
        printWriter.print(" ");
        this.then_clause.print(printWriter);
        if (this.else_clause != null) {
            printWriter.print(" ");
            this.else_clause.print(printWriter);
        }
        printWriter.print(")");
    }

    Object walk(ExpWalker expWalker) {
        return expWalker.walkIfExp(this);
    }
}

