/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.CodeAttr;
import gnu.bytecode.PrimType;
import gnu.bytecode.Type;
import gnu.expr.Compilation;
import gnu.expr.Target;
import gnu.mapping.Values;

public class StackTarget
extends Target {
    Type type;

    public StackTarget(Type type) {
        this.type = type;
    }

    public void compileFromStack(Compilation compilation, Type type) {
        if (!this.compileFromStack0(compilation, type)) {
            this.type.emitCoerceFromObject(compilation.getCode());
        }
    }

    protected boolean compileFromStack0(Compilation compilation, Type type) {
        if (this.type == type) {
            return true;
        }
        CodeAttr codeAttr = compilation.getCode();
        if (type.isVoid()) {
            compilation.compileConstant(Values.empty);
            type = Type.pointer_type;
        } else if (type instanceof PrimType && this.type instanceof PrimType) {
            codeAttr.emitConvert(type, this.type);
            return true;
        }
        if (type.isSubtype(this.type)) {
            return true;
        }
        type.emitCoerceToObject(codeAttr);
        return false;
    }

    public static Target getInstance(Type type) {
        return type == Type.pointer_type ? Target.pushObject : new StackTarget(type);
    }

    public Type getType() {
        return this.type;
    }
}

