/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.CodeAttr;
import gnu.bytecode.Type;
import gnu.expr.Compilation;
import gnu.expr.StackTarget;
import gnu.expr.Target;

public class TailTarget
extends StackTarget {
    public TailTarget(Type type) {
        super(type);
    }

    public void compileFromStack(Compilation compilation, Type type) {
        if (!compilation.curLambda.isHandlingTailCalls()) {
            super.compileFromStack(compilation, type);
        } else if (compilation.method.reachableHere()) {
            CodeAttr codeAttr = compilation.getCode();
            Target.pushObject.compileFromStack(compilation, type);
            codeAttr.emitLoad(compilation.callStackContext);
            codeAttr.emitSwap();
            codeAttr.emitPutField(Compilation.valueCallStackField);
            codeAttr.emitReturn();
        }
    }

    public static Target getInstance(Type type) {
        return type == Type.pointer_type ? Target.returnObject : new TailTarget(type);
    }
}

