/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.util;

import gnu.kawa.util.Sequence;
import gnu.kawa.util.UniformVector;
import gnu.math.IntNum;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.PrintWriter;

public class U16Vector
extends UniformVector
implements Externalizable {
    short[] data;

    public U16Vector() {
    }

    public U16Vector(int n) {
        this.data = new short[n];
    }

    public U16Vector(int n, short s) {
        short[] sArray = new short[n];
        this.data = sArray;
        while (--n >= 0) {
            sArray[n] = s;
        }
    }

    public U16Vector(Sequence sequence) {
        this.data = new short[sequence.length()];
        this.copy(sequence);
    }

    public U16Vector(short[] sArray) {
        this.data = sArray;
    }

    public final Object get(int n) {
        return IntNum.make(this.data[n] & 0xFFFF);
    }

    public final String getTag() {
        return "s16";
    }

    public final int intValue(int n) {
        return this.data[n] & 0xFFFF;
    }

    public final int length() {
        return this.data.length;
    }

    public final void print(int n, PrintWriter printWriter) {
        printWriter.print(this.intValue(n));
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        short[] sArray = new short[n];
        int n2 = 0;
        while (n2 < n) {
            sArray[n2] = objectInput.readShort();
            ++n2;
        }
        this.data = sArray;
    }

    public final void set(int n, short s) {
        this.data[n] = s;
    }

    public final void setElementAt(Object object2, int n) {
        this.data[n] = (short)((Number)object2).intValue();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        int n = this.data.length;
        objectOutput.writeInt(n);
        int n2 = 0;
        while (n2 < n) {
            objectOutput.writeShort(this.data[n2]);
            ++n2;
        }
    }
}

