/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.util;

import gnu.kawa.util.Sequence;
import gnu.kawa.util.UniformVector;
import gnu.math.IntNum;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.PrintWriter;

public class U32Vector
extends UniformVector
implements Externalizable {
    int[] data;

    public U32Vector() {
    }

    public U32Vector(int n) {
        this.data = new int[n];
    }

    public U32Vector(int n, int n2) {
        int[] nArray = new int[n];
        this.data = nArray;
        while (--n >= 0) {
            nArray[n] = n2;
        }
    }

    public U32Vector(Sequence sequence) {
        this.data = new int[sequence.length()];
        this.copy(sequence);
    }

    public U32Vector(int[] nArray) {
        this.data = nArray;
    }

    public final Object get(int n) {
        return IntNum.make(this.longValue(n));
    }

    public final String getTag() {
        return "u32";
    }

    public final int intValue(int n) {
        return this.data[n];
    }

    public final int length() {
        return this.data.length;
    }

    public final long longValue(int n) {
        return (long)this.data[n] & 0xFFFFFFFFL;
    }

    public final void print(int n, PrintWriter printWriter) {
        printWriter.print(this.longValue(n));
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = objectInput.readInt();
            ++n2;
        }
        this.data = nArray;
    }

    public final void set(int n, int n2) {
        this.data[n] = n2;
    }

    public final void set(int n, long l) {
        this.data[n] = (int)l;
    }

    public final void setElementAt(Object object2, int n) {
        this.data[n] = ((Number)object2).intValue();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        int n = this.data.length;
        objectOutput.writeInt(n);
        int n2 = 0;
        while (n2 < n) {
            objectOutput.writeInt(this.data[n2]);
            ++n2;
        }
    }
}

