/*
 * Decompiled with CFR 0.152.
 */
package gnu.math;

import gnu.math.DFloNum;
import gnu.math.IntFraction;
import gnu.math.IntNum;
import gnu.math.Numeric;
import gnu.math.RealNum;

public abstract class RatNum
extends RealNum {
    public static RatNum add(RatNum ratNum, RatNum ratNum2, int n) {
        IntNum intNum = ratNum.numerator();
        IntNum intNum2 = ratNum.denominator();
        IntNum intNum3 = ratNum2.numerator();
        IntNum intNum4 = ratNum2.denominator();
        if (IntNum.equals(intNum2, intNum4)) {
            return RatNum.make(IntNum.add(intNum, intNum3, n), intNum2);
        }
        return RatNum.make(IntNum.add(IntNum.times(intNum4, intNum), IntNum.times(intNum3, intNum2), n), IntNum.times(intNum2, intNum4));
    }

    public static int compare(RatNum ratNum, RatNum ratNum2) {
        return IntNum.compare(IntNum.times(ratNum.numerator(), ratNum2.denominator()), IntNum.times(ratNum2.numerator(), ratNum.denominator()));
    }

    public abstract IntNum denominator();

    public static RatNum divide(RatNum ratNum, RatNum ratNum2) {
        return RatNum.make(IntNum.times(ratNum.numerator(), ratNum2.denominator()), IntNum.times(ratNum.denominator(), ratNum2.numerator()));
    }

    public static boolean equals(RatNum ratNum, RatNum ratNum2) {
        return IntNum.equals(ratNum.numerator(), ratNum2.numerator()) && IntNum.equals(ratNum.denominator(), ratNum2.denominator());
    }

    public boolean equals(Object object2) {
        if (object2 == null || !(object2 instanceof RatNum)) {
            return false;
        }
        return RatNum.equals(this, (RatNum)object2);
    }

    public static RatNum infinity(int n) {
        return new IntFraction(IntNum.make(n), IntNum.zero());
    }

    public boolean isExact() {
        return true;
    }

    public boolean isZero() {
        return this.numerator().isZero();
    }

    public static RatNum make(IntNum intNum, IntNum intNum2) {
        IntNum intNum3 = IntNum.gcd(intNum, intNum2);
        if (intNum2.isNegative()) {
            intNum3 = IntNum.neg(intNum3);
        }
        if (!intNum3.isOne()) {
            intNum = IntNum.quotient(intNum, intNum3);
            intNum2 = IntNum.quotient(intNum2, intNum3);
        }
        return intNum2.isOne() ? intNum : new IntFraction(intNum, intNum2);
    }

    public abstract IntNum numerator();

    public Numeric power(IntNum intNum) {
        boolean bl;
        if (intNum.isNegative()) {
            bl = true;
            intNum = IntNum.neg(intNum);
        } else {
            bl = false;
        }
        if (intNum.words == null) {
            IntNum intNum2 = IntNum.power(this.numerator(), intNum.ival);
            IntNum intNum3 = IntNum.power(this.denominator(), intNum.ival);
            return bl ? RatNum.make(intNum3, intNum2) : RatNum.make(intNum2, intNum3);
        }
        double d = this.doubleValue();
        boolean bl2 = d < 0.0 && intNum.isOdd();
        d = Math.pow(d, intNum.doubleValue());
        if (bl) {
            d = 1.0 / d;
        }
        return new DFloNum(bl2 ? -d : d);
    }

    public static RealNum rationalize(RealNum realNum, RealNum realNum2) {
        if (realNum.grt(realNum2)) {
            return RatNum.simplest_rational2(realNum2, realNum);
        }
        if (!realNum2.grt(realNum)) {
            return realNum;
        }
        if (realNum.sign() > 0) {
            return RatNum.simplest_rational2(realNum, realNum2);
        }
        if (realNum2.isNegative()) {
            return (RealNum)RatNum.simplest_rational2((RealNum)realNum2.neg(), (RealNum)realNum.neg()).neg();
        }
        return IntNum.zero();
    }

    private static RealNum simplest_rational2(RealNum realNum, RealNum realNum2) {
        RealNum realNum3 = realNum.toInt(1);
        RealNum realNum4 = realNum2.toInt(1);
        if (!realNum.grt(realNum3)) {
            return realNum3;
        }
        if (realNum3.equals(realNum4)) {
            RealNum realNum5 = (RealNum)IntNum.one().div(realNum2.sub(realNum4));
            RealNum realNum6 = (RealNum)IntNum.one().div(realNum.sub(realNum3));
            return (RealNum)realNum3.add(IntNum.one().div(RatNum.simplest_rational2(realNum5, realNum6)), 1);
        }
        return (RealNum)realNum3.add(IntNum.one(), 1);
    }

    public static RatNum times(RatNum ratNum, RatNum ratNum2) {
        return RatNum.make(IntNum.times(ratNum.numerator(), ratNum2.numerator()), IntNum.times(ratNum.denominator(), ratNum2.denominator()));
    }

    public final RatNum toExact() {
        return this;
    }

    public IntNum toExactInt(int n) {
        return IntNum.quotient(this.numerator(), this.denominator(), n);
    }

    public RealNum toInt(int n) {
        return IntNum.quotient(this.numerator(), this.denominator(), n);
    }
}

