/*
 * Decompiled with CFR 0.152.
 */
package gnu.text;

import gnu.math.IntNum;
import gnu.math.RealNum;
import gnu.text.EnglishIntegerFormat;
import gnu.text.ReportFormat;
import gnu.text.RomanIntegerFormat;
import java.io.IOException;
import java.io.Writer;
import java.text.FieldPosition;
import java.text.Format;

public class IntegerFormat
extends ReportFormat {
    int base = 10;
    int minWidth = 1;
    int padChar = 32;
    int commaChar = 44;
    int commaInterval = 3;
    int flags = 0;
    public static final int SHOW_GROUPS = 1;
    public static final int SHOW_PLUS = 2;
    public static final int SHOW_SPACE = 4;
    public static final int SHOW_BASE = 8;
    public static final int PAD_RIGHT = 16;
    public static final int UPPERCASE = 32;
    private static IntegerFormat plainDecimalFormat;

    static IntNum asInteger(Object object2) {
        try {
            if (object2 instanceof RealNum) {
                return ((RealNum)object2).toExactInt(4);
            }
            if (object2 instanceof Long) {
                return IntNum.make((Long)object2);
            }
            if (object2 instanceof Number) {
                return RealNum.toExactInt(((Number)object2).doubleValue(), 4);
            }
        }
        catch (Exception exception) {}
        return null;
    }

    public int format(Object[] objectArray, int n, Writer writer, FieldPosition fieldPosition) throws IOException {
        int n2 = ReportFormat.getParam(this.minWidth, 1, objectArray, n);
        if (this.minWidth == -1610612736) {
            ++n;
        }
        char c = ReportFormat.getParam(this.padChar, ' ', objectArray, n);
        if (this.padChar == -1610612736) {
            ++n;
        }
        char c2 = ReportFormat.getParam(this.commaChar, ',', objectArray, n);
        if (this.commaChar == -1610612736) {
            ++n;
        }
        int n3 = ReportFormat.getParam(this.commaInterval, 3, objectArray, n);
        if (this.commaInterval == -1610612736) {
            ++n;
        }
        boolean bl = (this.flags & 1) != 0;
        boolean bl2 = (this.flags & 0x10) != 0;
        boolean bl3 = c == '0';
        Object object2 = objectArray[n];
        IntNum intNum = IntegerFormat.asInteger(object2);
        if (intNum != null) {
            boolean bl4;
            String string = intNum.toString(this.base);
            char c3 = string.charAt(0);
            boolean bl5 = c3 == '-';
            int n4 = string.length();
            int n5 = bl5 ? n4 - 1 : n4;
            int n6 = bl ? (n5 - 1) / n3 : 0;
            int n7 = n5 + n6;
            if (bl5 || (this.flags & 6) != 0) {
                ++n7;
            }
            if ((this.flags & 8) != 0) {
                if (this.base == 16) {
                    n7 += 2;
                } else if (this.base == 8 && c3 != '0') {
                    ++n7;
                }
            }
            if (!bl2 && !bl3) {
                while (n2 > n7) {
                    writer.write(c);
                    --n2;
                }
            }
            int n8 = 0;
            if (bl5) {
                writer.write(45);
                ++n8;
                --n4;
            } else if ((this.flags & 2) != 0) {
                writer.write(43);
            } else if ((this.flags & 4) != 0) {
                writer.write(32);
            }
            boolean bl6 = bl4 = this.base > 10 && (this.flags & 0x20) != 0;
            if ((this.flags & 8) != 0) {
                if (this.base == 16) {
                    writer.write(48);
                    writer.write(bl4 ? 88 : 120);
                } else if (this.base == 8 && c3 != '0') {
                    writer.write(48);
                }
            }
            if (bl3) {
                while (n2 > n7) {
                    writer.write(c);
                    --n2;
                }
            }
            while (true) {
                char c4 = string.charAt(n8++);
                if (bl4) {
                    c4 = Character.toUpperCase(c4);
                }
                writer.write(c4);
                if (--n4 == 0) break;
                if (!bl || n4 % n3 != 0) continue;
                writer.write(c2);
            }
            if (bl2) {
                while (n2 > n7) {
                    writer.write(c);
                    --n2;
                }
            }
        } else {
            ReportFormat.print(writer, object2.toString());
        }
        return n + 1;
    }

    public static IntegerFormat getInstance() {
        if (plainDecimalFormat == null) {
            plainDecimalFormat = new IntegerFormat();
        }
        return plainDecimalFormat;
    }

    public static Format getInstance(int n, int n2, int n3, int n4, int n5, int n6) {
        if (n == -1073741824) {
            if (n3 == -1073741824 && n3 == -1073741824 && n4 == -1073741824 && n5 == -1073741824) {
                boolean bl;
                boolean bl2 = bl = (n6 & 1) != 0;
                if ((n6 & 2) != 0) {
                    return RomanIntegerFormat.getInstance(bl);
                }
                return EnglishIntegerFormat.getInstance(bl);
            }
            n = 10;
        }
        if (n2 == -1073741824) {
            n2 = 1;
        }
        if (n3 == -1073741824) {
            n3 = 32;
        }
        if (n4 == -1073741824) {
            n4 = 44;
        }
        if (n5 == -1073741824) {
            n5 = 3;
        }
        if (n == 10 && n2 == 1 && n3 == 32 && n4 == 44 && n5 == 3 && n6 == 0) {
            return IntegerFormat.getInstance();
        }
        IntegerFormat integerFormat = new IntegerFormat();
        integerFormat.base = n;
        integerFormat.minWidth = n2;
        integerFormat.padChar = n3;
        integerFormat.commaChar = n4;
        integerFormat.commaInterval = n5;
        integerFormat.flags = n6;
        return integerFormat;
    }
}

