/*
 * Decompiled with CFR 0.152.
 */
package org.treebind;

import java.util.Iterator;
import java.util.Vector;
import org.treebind.Name;
import org.treebind.NotImplementedException;
import org.treebind.Property;

public abstract class DefaultPropertyImplementation
implements Property {
    Name nature;
    Vector properties;
    Name role;
    Object value;

    public void addProperty(int position, Property property) throws NotImplementedException {
        if (this.properties == null) {
            this.properties = new Vector();
        }
        this.properties.add(position, property);
    }

    public void addProperty(Property property) throws NotImplementedException {
        if (this.properties == null) {
            this.properties = new Vector();
        }
        this.properties.add(property);
    }

    public Name getNature() {
        return this.nature;
    }

    public Iterator getProperties() {
        if (this.properties == null) {
            return null;
        }
        return this.properties.iterator();
    }

    public Iterator getPropertiesWithNature(Name nature) {
        Vector<Property> properties = new Vector<Property>();
        Iterator iterator = this.getProperties();
        while (iterator.hasNext()) {
            Property property = (Property)iterator.next();
            if (!nature.equals(property.getNature())) continue;
            properties.add(property);
        }
        return properties.iterator();
    }

    public Iterator getPropertiesWithRole(Name role) {
        Vector<Property> properties = new Vector<Property>();
        Iterator iterator = this.getProperties();
        while (iterator.hasNext()) {
            Property property = (Property)iterator.next();
            if (!role.equals(property.getRole())) continue;
            properties.add(property);
        }
        return properties.iterator();
    }

    public Iterator getPropertiesWithRoleAndNature(Name role, Name nature) {
        Vector<Property> properties = new Vector<Property>();
        Iterator iterator = this.getProperties();
        while (iterator.hasNext()) {
            Property property = (Property)iterator.next();
            if (!role.equals(property.getRole()) || !nature.equals(property.getNature())) continue;
            properties.add(property);
        }
        return properties.iterator();
    }

    public Name getRole() {
        return this.role;
    }

    public Object getValue() {
        return this.value;
    }

    public int nbProperties() {
        if (this.properties == null) {
            return 0;
        }
        return this.properties.size();
    }

    public void setNature(Name nature) {
        this.nature = nature;
    }

    public void setRole(Name role) {
        this.role = role;
    }

    public void setValue(Object value) throws NotImplementedException {
        this.value = value;
    }
}

