/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.title;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.jfree.chart.Spacer;
import org.jfree.chart.event.TitleChangeEvent;
import org.jfree.chart.title.Title;
import org.jfree.io.SerialUtilities;
import org.jfree.text.G2TextMeasurer;
import org.jfree.text.TextBlock;
import org.jfree.text.TextBlockAnchor;
import org.jfree.text.TextMeasurer;
import org.jfree.text.TextUtilities;
import org.jfree.ui.HorizontalAlignment;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.VerticalAlignment;
import org.jfree.util.ObjectUtils;

public class TextTitle
extends Title
implements Serializable,
Cloneable {
    public static final Font DEFAULT_FONT = new Font("SansSerif", 1, 12);
    public static final Paint DEFAULT_TEXT_PAINT = Color.black;
    private String text;
    private Font font;
    private transient Paint paint;
    private transient Paint backgroundPaint;

    public TextTitle() {
        this("");
    }

    public TextTitle(String string) {
        this(string, DEFAULT_FONT, DEFAULT_TEXT_PAINT, Title.DEFAULT_POSITION, Title.DEFAULT_HORIZONTAL_ALIGNMENT, Title.DEFAULT_VERTICAL_ALIGNMENT, Title.DEFAULT_SPACER);
    }

    public TextTitle(String string, Font font) {
        this(string, font, DEFAULT_TEXT_PAINT, Title.DEFAULT_POSITION, Title.DEFAULT_HORIZONTAL_ALIGNMENT, Title.DEFAULT_VERTICAL_ALIGNMENT, Title.DEFAULT_SPACER);
    }

    public TextTitle(String string, Font font, Paint paint) {
        this(string, font, paint, Title.DEFAULT_POSITION, Title.DEFAULT_HORIZONTAL_ALIGNMENT, Title.DEFAULT_VERTICAL_ALIGNMENT, Title.DEFAULT_SPACER);
    }

    public TextTitle(String string, Font font, HorizontalAlignment horizontalAlignment) {
        this(string, font, DEFAULT_TEXT_PAINT, Title.DEFAULT_POSITION, horizontalAlignment, Title.DEFAULT_VERTICAL_ALIGNMENT, Title.DEFAULT_SPACER);
    }

    public TextTitle(String string, Font font, Paint paint, RectangleEdge rectangleEdge, HorizontalAlignment horizontalAlignment, VerticalAlignment verticalAlignment, Spacer spacer) {
        super(rectangleEdge, horizontalAlignment, verticalAlignment, spacer);
        if (string == null) {
            throw new NullPointerException("TextTitle(..): Text is null");
        }
        if (font == null) {
            throw new NullPointerException("TextTitle(..): Font is null");
        }
        if (paint == null) {
            throw new NullPointerException("TextTitle(..): Paint is null");
        }
        this.text = string;
        this.font = font;
        this.paint = paint;
        this.backgroundPaint = null;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        if (string == null) {
            throw new NullPointerException("TextTitle.setText(..): Text is null");
        }
        if (!this.text.equals(string)) {
            this.text = string;
            this.notifyListeners(new TitleChangeEvent(this));
        }
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("TextTitle.setFont(...): null font not permitted.");
        }
        if (!this.font.equals(font)) {
            this.font = font;
            this.notifyListeners(new TitleChangeEvent(this));
        }
    }

    public Paint getPaint() {
        return this.paint;
    }

    public void setPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("TextTitle.setPaint(...): null paint not permitted.");
        }
        if (!this.paint.equals(paint)) {
            this.paint = paint;
            this.notifyListeners(new TitleChangeEvent(this));
        }
    }

    public Paint getBackgroundPaint() {
        return this.backgroundPaint;
    }

    public void setBackgroundPaint(Paint paint) {
        this.backgroundPaint = paint;
        this.notifyListeners(new TitleChangeEvent(this));
    }

    public float getPreferredWidth(Graphics2D graphics2D, float f) {
        float f2 = 0.0f;
        graphics2D.setFont(this.font);
        TextBlock textBlock = TextUtilities.createTextBlock((String)this.text, (Font)this.font, (float)f, (TextMeasurer)new G2TextMeasurer(graphics2D));
        Dimension dimension = textBlock.calculateDimensions(graphics2D);
        f2 = (float)this.getSpacer().getAdjustedWidth(dimension.getHeight());
        return f2;
    }

    public float getPreferredHeight(Graphics2D graphics2D, float f) {
        float f2 = 0.0f;
        graphics2D.setFont(this.font);
        TextBlock textBlock = TextUtilities.createTextBlock((String)this.text, (Font)this.font, (float)f, (TextMeasurer)new G2TextMeasurer(graphics2D));
        Dimension dimension = textBlock.calculateDimensions(graphics2D);
        f2 = (float)this.getSpacer().getAdjustedHeight(dimension.getHeight());
        return f2;
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        RectangleEdge rectangleEdge;
        if (this.text.equals("")) {
            return;
        }
        if (this.backgroundPaint != null) {
            graphics2D.setPaint(this.backgroundPaint);
            graphics2D.fill(rectangle2D);
        }
        if ((rectangleEdge = this.getPosition()) == RectangleEdge.TOP || rectangleEdge == RectangleEdge.BOTTOM) {
            this.drawHorizontal(graphics2D, rectangle2D);
        } else if (rectangleEdge == RectangleEdge.LEFT || rectangleEdge == RectangleEdge.RIGHT) {
            this.drawVertical(graphics2D, rectangle2D);
        }
    }

    public void drawHorizontal(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        Rectangle2D rectangle2D2 = (Rectangle2D)rectangle2D.clone();
        this.getSpacer().trim(rectangle2D2);
        graphics2D.setFont(this.font);
        graphics2D.setPaint(this.paint);
        TextBlock textBlock = TextUtilities.createTextBlock((String)this.text, (Font)this.font, (float)((float)rectangle2D2.getWidth()), (TextMeasurer)new G2TextMeasurer(graphics2D));
        TextBlockAnchor textBlockAnchor = null;
        float f = 0.0f;
        HorizontalAlignment horizontalAlignment = this.getHorizontalAlignment();
        if (horizontalAlignment == HorizontalAlignment.LEFT) {
            f = (float)rectangle2D2.getX();
            textBlockAnchor = TextBlockAnchor.TOP_LEFT;
        } else if (horizontalAlignment == HorizontalAlignment.RIGHT) {
            f = (float)rectangle2D2.getMaxX();
            textBlockAnchor = TextBlockAnchor.TOP_RIGHT;
        } else if (horizontalAlignment == HorizontalAlignment.CENTER) {
            f = (float)rectangle2D2.getCenterX();
            textBlockAnchor = TextBlockAnchor.TOP_CENTER;
        }
        float f2 = 0.0f;
        RectangleEdge rectangleEdge = this.getPosition();
        if (rectangleEdge == RectangleEdge.TOP) {
            f2 = (float)rectangle2D2.getY();
        } else if (rectangleEdge == RectangleEdge.BOTTOM) {
            f2 = (float)rectangle2D2.getMaxY();
            if (horizontalAlignment == HorizontalAlignment.LEFT) {
                textBlockAnchor = TextBlockAnchor.BOTTOM_LEFT;
            } else if (horizontalAlignment == HorizontalAlignment.CENTER) {
                textBlockAnchor = TextBlockAnchor.BOTTOM_CENTER;
            } else if (horizontalAlignment == HorizontalAlignment.RIGHT) {
                textBlockAnchor = TextBlockAnchor.BOTTOM_RIGHT;
            }
        }
        textBlock.draw(graphics2D, f, f2, textBlockAnchor);
    }

    public void drawVertical(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        Rectangle2D rectangle2D2 = (Rectangle2D)rectangle2D.clone();
        this.getSpacer().trim(rectangle2D2);
        graphics2D.setFont(this.font);
        graphics2D.setPaint(this.paint);
        TextBlock textBlock = TextUtilities.createTextBlock((String)this.text, (Font)this.font, (float)((float)rectangle2D2.getHeight()), (TextMeasurer)new G2TextMeasurer(graphics2D));
        TextBlockAnchor textBlockAnchor = null;
        float f = 0.0f;
        VerticalAlignment verticalAlignment = this.getVerticalAlignment();
        if (verticalAlignment == VerticalAlignment.TOP) {
            f = (float)rectangle2D2.getY();
            textBlockAnchor = TextBlockAnchor.TOP_RIGHT;
        } else if (verticalAlignment == VerticalAlignment.BOTTOM) {
            f = (float)rectangle2D2.getMaxY();
            textBlockAnchor = TextBlockAnchor.TOP_LEFT;
        } else if (verticalAlignment == VerticalAlignment.CENTER) {
            f = (float)rectangle2D2.getCenterY();
            textBlockAnchor = TextBlockAnchor.TOP_CENTER;
        }
        float f2 = 0.0f;
        RectangleEdge rectangleEdge = this.getPosition();
        if (rectangleEdge == RectangleEdge.LEFT) {
            f2 = (float)rectangle2D2.getX();
        } else if (rectangleEdge == RectangleEdge.RIGHT) {
            f2 = (float)rectangle2D2.getMaxX();
            if (verticalAlignment == VerticalAlignment.TOP) {
                textBlockAnchor = TextBlockAnchor.BOTTOM_RIGHT;
            } else if (verticalAlignment == VerticalAlignment.CENTER) {
                textBlockAnchor = TextBlockAnchor.BOTTOM_CENTER;
            } else if (verticalAlignment == VerticalAlignment.BOTTOM) {
                textBlockAnchor = TextBlockAnchor.BOTTOM_LEFT;
            }
        }
        textBlock.draw(graphics2D, f2, f, textBlockAnchor, f2, f, -1.5707963267948966);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof TextTitle) {
            TextTitle textTitle = (TextTitle)object;
            if (super.equals(object)) {
                if (!ObjectUtils.equal((Object)this.text, (Object)textTitle.text)) {
                    return false;
                }
                if (!ObjectUtils.equal((Object)this.font, (Object)textTitle.font)) {
                    return false;
                }
                return ObjectUtils.equal((Object)this.paint, (Object)textTitle.paint);
            }
        }
        return false;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writePaint((Paint)this.paint, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writePaint((Paint)this.backgroundPaint, (ObjectOutputStream)objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.paint = SerialUtilities.readPaint((ObjectInputStream)objectInputStream);
        this.backgroundPaint = SerialUtilities.readPaint((ObjectInputStream)objectInputStream);
    }
}

