/*
 * Decompiled with CFR 0.152.
 */
package jsynoptic.builtin;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedMap;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import jsynoptic.base.Linkable;
import jsynoptic.base.Plugin;
import jsynoptic.builtin.AutomatonShape;
import jsynoptic.builtin.ConnectionShape;
import jsynoptic.builtin.EllipseShape;
import jsynoptic.builtin.GaussianRandomSource;
import jsynoptic.builtin.HistoryShape;
import jsynoptic.builtin.ImageShape;
import jsynoptic.builtin.LinesShape;
import jsynoptic.builtin.Plot;
import jsynoptic.builtin.PolygonShape;
import jsynoptic.builtin.RandomSourceProvider;
import jsynoptic.builtin.RangeSource;
import jsynoptic.builtin.RangeSourceProvider;
import jsynoptic.builtin.RectangleShape;
import jsynoptic.builtin.TextArrayShape;
import jsynoptic.builtin.TextShape;
import jsynoptic.builtin.UniformRandomSource;
import jsynoptic.data.DataSourceAnimator;
import jsynoptic.data.DataSourceAnimatorProvider;
import jsynoptic.data.DataSourceCollectionAnimator;
import jsynoptic.data.DataSourceCollectionAnimatorProvider;
import jsynoptic.ui.JSynoptic;
import jsynoptic.ui.JSynopticBatch;
import jsynoptic.ui.ShapesContainer;
import simtools.data.AsciiFileDataSourceCollection;
import simtools.data.AsciiFileDataSourceProvider;
import simtools.data.BasicDataSourceProvider;
import simtools.data.DataInfo;
import simtools.data.DataSource;
import simtools.data.DataSourceCollection;
import simtools.data.DataSourcePool;
import simtools.data.buffer.Buffer;
import simtools.data.buffer.DelayedBuffer;
import simtools.data.buffer.ResizeableBuffer;
import simtools.diagram.DiagramComponent;
import simtools.shapes.AbstractShape;
import simtools.ui.ActionCheckBox;
import simtools.ui.BasicMessageWriter;
import simtools.ui.ColorMapper;
import simtools.ui.ImageMapper;
import simtools.ui.MenuResourceBundle;
import simtools.ui.NumberField;
import simtools.ui.ResourceFinder;
import simtools.ui.TextMapper;

public class Builtin
extends Plugin {
    public static MenuResourceBundle resources = ResourceFinder.getMenu(class$jsynoptic$builtin$Builtin == null ? (class$jsynoptic$builtin$Builtin = Builtin.class$("jsynoptic.builtin.Builtin")) : class$jsynoptic$builtin$Builtin);
    public static BasicMessageWriter messageWriter = ResourceFinder.getMessages(class$jsynoptic$builtin$Builtin == null ? (class$jsynoptic$builtin$Builtin = Builtin.class$("jsynoptic.builtin.Builtin")) : class$jsynoptic$builtin$Builtin);
    protected static MenuResourceBundle.FileFilter jsynopticFilter = resources.getFileFilter("jsynopticFilter");
    protected static MenuResourceBundle.FileFilter asciiFileFilter;
    protected static FileFilter[] bothFilters;
    protected static FileFilter[] jsynopticOnlyFilters;
    protected static String[] providedComponents;
    protected static boolean hasAlreadyPutProviders;
    protected ASCIIFileOptionComponent optionPanel;
    private File runFile;
    private int runAction;
    protected static String[] providedSources;
    static /* synthetic */ Class class$jsynoptic$builtin$Builtin;

    public Builtin() {
        if (hasAlreadyPutProviders) {
            return;
        }
        DataSourcePool.global.addProvider(new BasicDataSourceProvider());
        DataSourcePool.global.addProvider(new DataSourceCollectionAnimatorProvider());
        DataSourcePool.global.addProvider(new DataSourceAnimatorProvider());
        DataSourcePool.global.addProvider(new RangeSourceProvider());
        DataSourcePool.global.addProvider(new RandomSourceProvider());
        DataSourcePool.global.addProvider(new AsciiFileDataSourceProvider(){

            public File chooseFile(String string, String string2) {
                if (JSynoptic.gui == null) {
                    File file = super.chooseFile(string, string2);
                    if (file == null) {
                        System.out.print(messageWriter.print2args("enterFile", string2, string));
                        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
                        try {
                            return new File(bufferedReader.readLine());
                        }
                        catch (IOException iOException) {
                            return null;
                        }
                    }
                    return file;
                }
                File file = new File(string);
                File file2 = file.getParentFile();
                if (file2 == null) {
                    file2 = new File(System.getProperty("user.home"));
                }
                JFileChooser jFileChooser = new JFileChooser(file2);
                jFileChooser.setSelectedFile(file);
                jFileChooser.setDialogTitle(messageWriter.print1args("asciiFileChooserTitle", string2));
                jFileChooser.setApproveButtonText(resources.getStringValue("approveText"));
                jFileChooser.setAcceptAllFileFilterUsed(false);
                jFileChooser.addChoosableFileFilter(asciiFileFilter);
                jFileChooser.setFileFilter(asciiFileFilter);
                if (jFileChooser.showDialog(JSynoptic.gui, null) == 0) {
                    this.setChooseFileAgain(true);
                    return jFileChooser.getSelectedFile();
                }
                this.setChooseFileAgain(false);
                return null;
            }

            public boolean chooseUseCollection(DataSourceCollection dataSourceCollection, String string, String string2) {
                int n;
                if (JSynoptic.gui != null && (n = JOptionPane.showConfirmDialog(JSynoptic.gui, new String[]{messageWriter.print0args("dscReplaceMsg1"), string2, messageWriter.print0args("dscReplaceMsg2"), DataInfo.getId(dataSourceCollection), messageWriter.print0args("dscReplaceMsg3"), string}, messageWriter.print0args("dscReplaceTitle"), 0, 3)) == 0) {
                    return true;
                }
                if (JSynopticBatch.batch != null) {
                    System.out.println(messageWriter.printNargs("dscReplaceMsg", new Object[]{string2, DataInfo.getId(dataSourceCollection), string}));
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
                    try {
                        if (messageWriter.print0args("dscReplaceYes").compareToIgnoreCase(bufferedReader.readLine()) == 0) {
                            return true;
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                return false;
            }

            public DataSource provide(String string, String string2, Object object, DataSourcePool dataSourcePool) {
                DataSource dataSource = super.provide(string, string2, object, dataSourcePool);
                if (dataSourcePool != null) {
                    DataSourceCollection dataSourceCollection = null;
                    int n = -1;
                    Set set = dataSourcePool.dataSourceCollections();
                    Iterator iterator = set.iterator();
                    while (iterator.hasNext()) {
                        DataSourceCollection dataSourceCollection2 = (DataSourceCollection)iterator.next();
                        int n2 = dataSourceCollection2.indexOf(dataSource);
                        if (n2 == -1) continue;
                        n = n2;
                        dataSourceCollection = dataSourceCollection2;
                        break;
                    }
                    if (dataSourceCollection != null) {
                        dataSourcePool.bufferize(dataSourceCollection, (Buffer)new ResizeableBuffer(resources.getIntValue("maxBufferSize")));
                        return (DataSource)dataSourceCollection.get(n);
                    }
                }
                return dataSource;
            }
        });
        hasAlreadyPutProviders = true;
    }

    public void newComponent(Component component) {
        if (component == null) {
            return;
        }
        if (!(component instanceof ShapesContainer.ShapesComponent)) {
            return;
        }
        ShapesContainer shapesContainer = (ShapesContainer)((ShapesContainer.ShapesComponent)component).getContainer();
        if (shapesContainer == null) {
            return;
        }
    }

    public String[] getShapes() {
        return providedComponents;
    }

    public AbstractShape createShape(String string, DiagramComponent diagramComponent) {
        if (string.equals(resources.getStringValue("plot"))) {
            return new Plot(0, 0, resources.getIntValue("defaultPlotWidth"), resources.getIntValue("defaultPlotHeight"));
        }
        if (string.equals(resources.getString("Text"))) {
            return new TextShape(resources.getString("Text"), 150, 50);
        }
        if (string.equals(resources.getString("TextArray"))) {
            return new TextArrayShape(resources.getString("Text"), 150, 50);
        }
        if (string.equals(resources.getString("History"))) {
            return new HistoryShape(5, 150, 50);
        }
        if (string.equals(resources.getString("Polygon"))) {
            return new PolygonShape(0, 0, 100, 100);
        }
        if (string.equals(resources.getString("Ellipse"))) {
            return new EllipseShape(0, 0, 100, 100);
        }
        if (string.equals(resources.getString("Rectangle"))) {
            return new RectangleShape(0, 0, 100, 50);
        }
        if (string.equals(resources.getString("Lines"))) {
            return new LinesShape(0, 0, 100, 100);
        }
        if (string.equals(resources.getString("Image"))) {
            return new ImageShape(0, 0, 100, 100);
        }
        if (string.equals(resources.getString("Automaton"))) {
            return new AutomatonShape(0, 0, 5, 5, 100, 100);
        }
        if (string.equals(resources.getString("Connection"))) {
            return new ConnectionShape(0, 0, 50, 0);
        }
        return null;
    }

    public FileFilter[] getFileFilters(int n) {
        if (n == 2) {
            return jsynopticOnlyFilters;
        }
        return bothFilters;
    }

    protected boolean processJSynopticFile(File file, int n) {
        switch (n) {
            case 1: {
                Object object;
                int n2 = 0;
                if (JSynoptic.gui != null) {
                    n2 = JSynoptic.gui.getFilePanel().getFileCount();
                }
                for (int i = 0; i < n2; ++i) {
                    object = JSynoptic.gui.getFilePanel().getFile(i);
                    if (object == null || !((File)object).equals(file)) continue;
                    JSynoptic.gui.getFilePanel().selectComponent(JSynoptic.gui.getFilePanel().getComponentAt(i));
                    return true;
                }
                JSynoptic.setStatus(messageWriter.print1args("loading", file.getName()));
                try {
                    Object object2;
                    Iterator iterator;
                    String string;
                    FileInputStream fileInputStream = new FileInputStream(file);
                    object = new ObjectInputStream(fileInputStream);
                    Object object3 = ((ObjectInputStream)object).readObject();
                    if (object3 == null || !(object3 instanceof ShapesContainer)) {
                        throw new IOException();
                    }
                    ShapesContainer shapesContainer = (ShapesContainer)object3;
                    String string2 = file.getName();
                    if (string2.endsWith(string = resources.getStringValue("jsynopticFilterExtension"))) {
                        string2 = string2.substring(0, string2.length() - string.length() - 1);
                    }
                    shapesContainer.getComponent().setName(string2);
                    object3 = ((ObjectInputStream)object).readObject();
                    if (object3 != null && object3 instanceof Vector) {
                        iterator = ((Vector)object3).iterator();
                        while (iterator.hasNext()) {
                            object2 = iterator.next();
                            if (!(object2 instanceof ColorMapper)) continue;
                            if (ColorMapper.colorMappers == null) {
                                ColorMapper.colorMappers = new Vector();
                            }
                            if (ColorMapper.colorMappers.contains(object2)) continue;
                            ColorMapper.colorMappers.add(object2);
                        }
                    }
                    if ((object3 = ((ObjectInputStream)object).readObject()) != null && object3 instanceof Vector) {
                        iterator = ((Vector)object3).iterator();
                        while (iterator.hasNext()) {
                            object2 = iterator.next();
                            if (!(object2 instanceof TextMapper)) continue;
                            if (TextMapper.textMappers == null) {
                                TextMapper.textMappers = new Vector();
                            }
                            if (TextMapper.textMappers.contains(object2)) continue;
                            TextMapper.textMappers.add(object2);
                        }
                    }
                    if ((object3 = ((ObjectInputStream)object).readObject()) != null && object3 instanceof Vector) {
                        iterator = ((Vector)object3).iterator();
                        while (iterator.hasNext()) {
                            object2 = iterator.next();
                            if (!(object2 instanceof ImageMapper)) continue;
                            if (ImageMapper.imageMappers == null) {
                                ImageMapper.imageMappers = new Vector();
                            }
                            if (ImageMapper.imageMappers.contains(object2)) continue;
                            ImageMapper.imageMappers.add(object2);
                        }
                    }
                    ((ObjectInputStream)object).close();
                    fileInputStream.close();
                    iterator = shapesContainer.iterator();
                    while (iterator.hasNext()) {
                        try {
                            String string3;
                            object2 = (AbstractShape)iterator.next();
                            ((AbstractShape)object2).addListener(shapesContainer.getComponent());
                            if (!(object2 instanceof Linkable)) continue;
                            Linkable linkable = (Linkable)object2;
                            File file2 = file.getParentFile();
                            if (file2 == null) {
                                file2 = new File("./");
                            }
                            if ((string3 = linkable.getLink()) == null || string3.equals("")) continue;
                            File file3 = new File(file2, string3);
                            linkable.setLink(file3.getCanonicalPath());
                        }
                        catch (ClassCastException classCastException) {}
                    }
                    if (JSynoptic.gui != null) {
                        JSynoptic.gui.addContainer(shapesContainer, file);
                    }
                    if (JSynopticBatch.batch != null) {
                        JSynopticBatch.batch.addContainer(shapesContainer);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    if (JSynoptic.gui != null) {
                        JOptionPane.showMessageDialog(JSynoptic.gui, messageWriter.print1args("cannotLoadFile", file.getName()), resources.getStringValue("IOError"), 0);
                    }
                    if (JSynopticBatch.batch != null) {
                        System.err.println(messageWriter.print1args("cannotLoadFile", file.getName()));
                    }
                    JSynoptic.setStatus(messageWriter.print1args("cannotLoadFile", file.getName()));
                    return false;
                }
                JSynoptic.setStatus(messageWriter.print1args("loadOK", file.getName()));
                return true;
            }
            case 2: {
                if (JSynoptic.gui == null) {
                    return false;
                }
                JSynoptic.setStatus(messageWriter.print1args("saving", file.getName()));
                try {
                    Object object;
                    Object object4;
                    Object object5;
                    Object object6;
                    Object object7;
                    String string;
                    Object object8;
                    ShapesContainer shapesContainer = JSynoptic.gui.getActiveContainer();
                    if (shapesContainer == null) {
                        return false;
                    }
                    Object object9 = shapesContainer.iterator();
                    while (object9.hasNext()) {
                        object8 = object9.next();
                        if (!(object8 instanceof Linkable) || (string = (object7 = (Linkable)object8).getLink()) == null) continue;
                        object6 = new File(string);
                        object5 = file.getCanonicalPath();
                        object4 = ((File)object6).getCanonicalPath();
                        int n3 = -1;
                        int n4 = -1;
                        while (n3 < ((String)object4).length() && n3 < ((String)object5).length() && (n3 == -1 || ((String)object5).substring(0, n3).equals(((String)object4).substring(0, n3)))) {
                            n4 = n3;
                            if ((n3 = ((String)object4).indexOf(File.separator, n3 + 1)) != -1) continue;
                        }
                        object = ((String)object5).substring(n4 + 1, ((String)object5).length());
                        String string4 = ((String)object4).substring(n4 + 1, ((String)object4).length());
                        String string5 = "";
                        n3 = -1;
                        while ((n3 = ((String)object).indexOf(File.separator, n3 + 1)) != -1) {
                            string5 = string5 + "../";
                        }
                        string = string5 + string4;
                        string = string.replaceAll("\\\\", "/");
                        object7.setLink(string);
                    }
                    object9 = new FileOutputStream(file);
                    object8 = new ObjectOutputStream((OutputStream)object9);
                    ((ObjectOutputStream)object8).writeObject(shapesContainer);
                    ((ObjectOutputStream)object8).writeObject(ColorMapper.colorMappers);
                    ((ObjectOutputStream)object8).writeObject(TextMapper.textMappers);
                    ((ObjectOutputStream)object8).writeObject(ImageMapper.imageMappers);
                    ((ObjectOutputStream)object8).flush();
                    ((ObjectOutputStream)object8).close();
                    ((FileOutputStream)object9).close();
                    object7 = file.getName();
                    string = resources.getStringValue("jsynopticFilterExtension");
                    if (((String)object7).endsWith(string)) {
                        object7 = ((String)object7).substring(0, ((String)object7).length() - string.length() - 1);
                    }
                    shapesContainer.getComponent().setName((String)object7);
                    object6 = shapesContainer.iterator();
                    while (object6.hasNext()) {
                        try {
                            String string6;
                            object5 = (AbstractShape)object6.next();
                            ((AbstractShape)object5).addListener(shapesContainer.getComponent());
                            if (!(object5 instanceof Linkable)) continue;
                            object4 = (Linkable)object5;
                            File file4 = file.getParentFile();
                            if (file4 == null) {
                                file4 = new File("./");
                            }
                            if ((string6 = object4.getLink()) == null || string6.equals("")) continue;
                            object = new File(file4, string6);
                            object4.setLink(((File)object).getCanonicalPath());
                        }
                        catch (ClassCastException classCastException) {}
                    }
                    JSynoptic.gui.setFile(shapesContainer, file);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    JOptionPane.showMessageDialog(JSynoptic.gui, messageWriter.print1args("cannotSaveFile", file.getName()), resources.getStringValue("IOError"), 0);
                    JSynoptic.setStatus(messageWriter.print1args("cannotSaveFile", file.getName()));
                    return false;
                }
                JSynoptic.setStatus(messageWriter.print1args("saveOK", file.getName()));
                return true;
            }
        }
        return false;
    }

    protected boolean processAsciiFile(File file, int n) {
        if (n != 1) {
            return false;
        }
        try {
            AsciiFileDataSourceCollection asciiFileDataSourceCollection = this.optionPanel != null && this.optionPanel.isSubSampled() ? new AsciiFileDataSourceCollection(file, (int)this.optionPanel.getSubSampleValue(), this.optionPanel.getChartsetName()) : (this.optionPanel != null ? new AsciiFileDataSourceCollection(file, this.optionPanel.getChartsetName()) : new AsciiFileDataSourceCollection(file));
            if (this.optionPanel != null && this.optionPanel.isDynamic()) {
                DataSourceCollectionAnimator dataSourceCollectionAnimator = new DataSourceCollectionAnimator(asciiFileDataSourceCollection);
                dataSourceCollectionAnimator.bufferize(new DelayedBuffer(this.optionPanel.getBufferSize()));
                dataSourceCollectionAnimator.setPeriod(this.optionPanel.getDynamicRefreshValue());
                DataSourcePool.global.addDataSourceCollection(dataSourceCollectionAnimator);
            } else {
                asciiFileDataSourceCollection.bufferize(new ResizeableBuffer(resources.getIntValue("maxBufferSize")));
                DataSourcePool.global.addDataSourceCollection(asciiFileDataSourceCollection);
            }
        }
        catch (Exception exception) {
            if (JSynoptic.gui == null) {
                System.err.println(messageWriter.print1args("cannotLoadFile", file.getName()));
            } else {
                JOptionPane.showMessageDialog(JSynoptic.gui, messageWriter.print1args("cannotLoadFile", file.getName()), resources.getStringValue("IOError"), 0);
            }
            return false;
        }
        JSynoptic.setStatus(messageWriter.print1args("loadOK", file.getName()));
        return true;
    }

    public boolean processFile(File file, int n) {
        if (JSynoptic.gui == null) {
            if (file.isDirectory()) {
                try {
                    System.setProperty("user.dir", file.getAbsolutePath());
                }
                catch (Exception exception) {
                    return false;
                }
                return true;
            }
            if (jsynopticFilter.accept(file)) {
                return this.processJSynopticFile(file, n);
            }
            if (asciiFileFilter.accept(file)) {
                return this.processAsciiFile(file, n);
            }
            return false;
        }
        if (file.isDirectory()) {
            JSynoptic.gui.setPath(file);
            return true;
        }
        if (n == 2 && jsynopticFilter.accept(file)) {
            return this.processJSynopticFile(file, n);
        }
        long l = jsynopticFilter.accept(file) ? 3L : 0L;
        this.runFile = file;
        this.runAction = n;
        if (jsynopticFilter.accept(this.runFile)) {
            this.processJSynopticFile(this.runFile, this.runAction);
        } else if (asciiFileFilter.accept(this.runFile)) {
            this.processAsciiFile(this.runFile, this.runAction);
        }
        return false;
    }

    public JComponent getOptionPanelForFilter(FileFilter fileFilter) {
        System.out.println(fileFilter);
        if (fileFilter == null) {
            this.optionPanel = new ASCIIFileOptionComponent();
            return this.optionPanel;
        }
        if (asciiFileFilter.equals(fileFilter)) {
            this.optionPanel = new ASCIIFileOptionComponent();
            return this.optionPanel;
        }
        return null;
    }

    public String about() {
        return null;
    }

    public String[] getSources() {
        return providedSources;
    }

    public DataSource createSource(String string, String string2) {
        if (string == null) {
            return null;
        }
        if (string.equals(resources.getString("UniformRandom"))) {
            UniformRandomSource.OptionPanel optionPanel = new UniformRandomSource.OptionPanel();
            int n = JOptionPane.showConfirmDialog(null, optionPanel, resources.getString("SourceOptionPanelTitle"), 2, -1);
            if (n == 0) {
                return optionPanel.createSource(string2);
            }
            return null;
        }
        if (string.equals(resources.getString("GaussianRandom"))) {
            GaussianRandomSource.OptionPanel optionPanel = new GaussianRandomSource.OptionPanel();
            int n = JOptionPane.showConfirmDialog(null, optionPanel, resources.getString("SourceOptionPanelTitle"), 2, -1);
            if (n == 0) {
                return optionPanel.createSource(string2);
            }
            return null;
        }
        if (string.equals(resources.getString("RangeSource"))) {
            RangeSource.OptionPanel optionPanel = new RangeSource.OptionPanel();
            int n = JOptionPane.showConfirmDialog(null, optionPanel, resources.getString("SourceOptionPanelTitle"), 2, -1);
            if (n == 0) {
                return optionPanel.createSource(string2);
            }
            return null;
        }
        if (string.equals(resources.getString("NaturalNumbers"))) {
            return new DataSourceAnimator(new RangeSource(string2, 0L, Long.MAX_VALUE, 1L));
        }
        return super.createSource(string, string2);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        jsynopticFilter.setAcceptDirectory(true);
        asciiFileFilter = resources.getFileFilter("asciiFileFilter");
        bothFilters = new FileFilter[]{jsynopticFilter, asciiFileFilter};
        jsynopticOnlyFilters = new FileFilter[]{jsynopticFilter};
        providedComponents = new String[]{resources.getStringValue("plot"), resources.getString("Text"), resources.getString("TextArray"), resources.getString("History"), resources.getString("Polygon"), resources.getString("Ellipse"), resources.getString("Rectangle"), resources.getString("Lines"), resources.getString("Image"), resources.getString("Automaton"), resources.getString("Connection")};
        hasAlreadyPutProviders = false;
        providedSources = new String[]{resources.getString("UniformRandom"), resources.getString("GaussianRandom"), resources.getString("RangeSource")};
    }

    public static class ASCIIFileOptionComponent
    extends JPanel {
        protected NumberField nfsubsample;
        protected NumberField nfdelay;
        protected NumberField nfbuffersize;
        protected ActionCheckBox cbsubsample;
        protected ActionCheckBox cbdynamic;
        protected JLabel ldynamic;
        protected JLabel lsubsample;
        protected JLabel ldynamicbuffersize;
        protected JComboBox cbxCharset;

        public ASCIIFileOptionComponent() {
            Box box = new Box(1);
            Box box2 = Box.createHorizontalBox();
            this.cbsubsample = new ActionCheckBox(this, resources.getStringValue("asciiOptionSubSampling"), false){
                private final /* synthetic */ ASCIIFileOptionComponent this$0;
                {
                    this.this$0 = aSCIIFileOptionComponent;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$0.nfsubsample.setEnabled(this.isSelected());
                    this.this$0.lsubsample.setEnabled(this.isSelected());
                    if (!this.isSelected()) {
                        this.this$0.nfsubsample.setValue(1L);
                    }
                }
            };
            box2.add(this.cbsubsample);
            box2.add(Box.createHorizontalGlue());
            box.add(box2);
            box2 = Box.createHorizontalBox();
            this.lsubsample = new JLabel(resources.getStringValue("asciiOptionSubSamplingText"));
            box2.add(this.lsubsample);
            box2.add(Box.createHorizontalGlue());
            this.nfsubsample = new NumberField(1L, 5);
            box2.add(this.nfsubsample);
            box.add(box2);
            this.cbsubsample.apply();
            box2 = Box.createHorizontalBox();
            this.cbdynamic = new ActionCheckBox(this, resources.getStringValue("asciiOptionDynamic"), false){
                private final /* synthetic */ ASCIIFileOptionComponent this$0;
                {
                    this.this$0 = aSCIIFileOptionComponent;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$0.nfdelay.setEnabled(this.isSelected());
                    this.this$0.ldynamic.setEnabled(this.isSelected());
                    this.this$0.nfbuffersize.setEnabled(this.isSelected());
                    this.this$0.ldynamicbuffersize.setEnabled(this.isSelected());
                    if (!this.isSelected()) {
                        this.this$0.nfdelay.setValue(1000L);
                    }
                    if (!this.isSelected()) {
                        this.this$0.nfbuffersize.setValue(100L);
                    }
                }
            };
            box2.add(this.cbdynamic);
            box2.add(Box.createHorizontalGlue());
            box.add(box2);
            box2 = Box.createHorizontalBox();
            this.ldynamic = new JLabel(resources.getStringValue("asciiOptionDynamicPeriod"));
            box2.add(this.ldynamic);
            box2.add(Box.createHorizontalGlue());
            this.nfdelay = new NumberField(1000L, 5);
            box2.add(this.nfdelay);
            box.add(box2);
            box2 = Box.createHorizontalBox();
            this.ldynamicbuffersize = new JLabel(resources.getStringValue("asciiOptionDynamicBufferSize"));
            box2.add(this.ldynamicbuffersize);
            box2.add(Box.createHorizontalGlue());
            this.nfbuffersize = new NumberField(100L, 5);
            box2.add(this.nfbuffersize);
            box.add(box2);
            this.cbdynamic.apply();
            box2 = Box.createHorizontalBox();
            box2.add(new JLabel(resources.getStringValue("asciiOptionCharset")));
            box2.add(Box.createHorizontalGlue());
            this.cbxCharset = new JComboBox();
            box2.add(this.cbxCharset);
            this.cbxCharset.addItem(resources.getStringValue("asciiOptionNoCharset"));
            SortedMap<String, Charset> sortedMap = Charset.availableCharsets();
            Iterator<String> iterator = sortedMap.keySet().iterator();
            while (iterator.hasNext()) {
                this.cbxCharset.addItem(iterator.next());
            }
            this.cbxCharset.setSelectedIndex(0);
            box.add(box2);
            this.add(box);
            this.nfsubsample.setMaximumSize(this.nfsubsample.getPreferredSize());
            this.nfdelay.setMaximumSize(this.nfdelay.getPreferredSize());
            this.nfbuffersize.setMaximumSize(this.nfbuffersize.getPreferredSize());
        }

        public boolean isDynamic() {
            return this.cbdynamic.isSelected();
        }

        public boolean isSubSampled() {
            return this.cbsubsample.isSelected();
        }

        public long getSubSampleValue() {
            return this.nfsubsample.getLongValue();
        }

        public long getDynamicRefreshValue() {
            return this.nfdelay.getLongValue();
        }

        public int getBufferSize() {
            return (int)this.nfbuffersize.getLongValue();
        }

        public String getChartsetName() {
            int n = this.cbxCharset.getSelectedIndex();
            if (n <= 0) {
                return null;
            }
            return this.cbxCharset.getSelectedItem().toString();
        }
    }
}

