/*
 * Decompiled with CFR 0.152.
 */
package simtools.data.async;

import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Date;
import java.util.TimeZone;
import simtools.data.DataException;
import simtools.data.DataInfo;
import simtools.data.DataSourceCollection;
import simtools.data.UnsupportedOperation;
import simtools.data.async.TimeStampedDataSource;

public abstract class TimeStampedDataSourceCollection
extends DataSourceCollection {
    public static final String ID_MARKER = "TimeStamped:";
    public static final String ID_DATE_FORMAT = "dd/MM/yy HH:mm:ss.SSS";
    protected Date _start = null;
    protected Date _end = null;
    protected CollectionContainer _container;
    static /* synthetic */ Class class$java$lang$Double;

    public TimeStampedDataSourceCollection(Date date, Date date2) throws IOException, InvalidFormatException {
        this.setStart(date);
        this.setEnd(date2);
        this._container = new CollectionContainer();
    }

    public TimeStampedDataSourceCollection() throws IOException, InvalidFormatException {
        this(null, null);
    }

    public Object computeMax(int n) throws UnsupportedOperation {
        TimeStampedDataSource timeStampedDataSource = (TimeStampedDataSource)this.get(n);
        if (!timeStampedDataSource.isMinmax()) {
            timeStampedDataSource.computeMinMax();
        }
        return timeStampedDataSource.getMax();
    }

    public Object computeMin(int n) throws UnsupportedOperation {
        TimeStampedDataSource timeStampedDataSource = (TimeStampedDataSource)this.get(n);
        if (!timeStampedDataSource.isMinmax()) {
            timeStampedDataSource.computeMinMax();
        }
        return timeStampedDataSource.getMin();
    }

    public Object getMax(int n) throws UnsupportedOperation {
        TimeStampedDataSource timeStampedDataSource = (TimeStampedDataSource)this.get(n);
        if (!timeStampedDataSource.isMinmax()) {
            timeStampedDataSource.computeMinMax();
        }
        return timeStampedDataSource.getMax();
    }

    public Object getMin(int n) throws UnsupportedOperation {
        TimeStampedDataSource timeStampedDataSource = (TimeStampedDataSource)this.get(n);
        if (!timeStampedDataSource.isMinmax()) {
            timeStampedDataSource.computeMinMax();
        }
        return timeStampedDataSource.getMin();
    }

    public abstract Object getValue(int var1, long var2) throws DataException;

    public abstract double getDoubleValue(int var1, long var2) throws DataException;

    public Class valueClass(int n) {
        return class$java$lang$Double == null ? (class$java$lang$Double = TimeStampedDataSourceCollection.class$("java.lang.Double")) : class$java$lang$Double;
    }

    public abstract DataInfo getInformation();

    public DataInfo getInformation(int n) {
        Object e = this.get(n);
        if (e instanceof TimeStampedDataSource) {
            TimeStampedDataSource timeStampedDataSource = (TimeStampedDataSource)e;
            return timeStampedDataSource.getInfo();
        }
        TimeStampedDataSource.TimeSource timeSource = (TimeStampedDataSource.TimeSource)e;
        return timeSource.getInformation();
    }

    public DateFormat createDateFormat() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(ID_DATE_FORMAT);
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        return simpleDateFormat;
    }

    protected void setStart(Date date) {
        this._start = date;
    }

    public Date getStart() {
        return this._start;
    }

    protected void setEnd(Date date) {
        this._end = date;
    }

    public Date getEnd() {
        return this._end;
    }

    public Collection getCollectionContainers() {
        return this._container;
    }

    public boolean isCompound() {
        return true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class CollectionContainer
    extends AbstractList {
        CollectionContainer() {
        }

        public Object get(int n) {
            return TimeStampedDataSourceCollection.this.get(n * 2);
        }

        public int size() {
            return TimeStampedDataSourceCollection.this.size() / 2;
        }
    }

    public static class InvalidFormatException
    extends Exception {
        public InvalidFormatException(String string) {
            super(string);
        }
    }
}

