/*
 * Decompiled with CFR 0.152.
 */
package simtools.ui;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import simtools.ui.CustomizedLocale;
import simtools.ui.MenuResourceBundle;

public class LogDialog
extends JDialog
implements ActionListener {
    private static MenuResourceBundle _resources;
    private JButton _bDis;
    private JButton _bNext;
    private JButton _bPrev;
    private JTextArea _text;
    private ArrayList _pos;
    private int _posView;

    public LogDialog(String string) {
        super((Frame)null, string);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds(dimension.width / 2, 2 * dimension.height / 3, dimension.width / 2, dimension.height / 3);
        this._pos = new ArrayList();
        this._posView = 0;
        this._text = new JTextArea();
        this._text.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(this._text);
        this.getContentPane().add("Center", jScrollPane);
        JPanel jPanel = new JPanel(new FlowLayout());
        this._bDis = _resources.getButton("dismiss", this);
        jPanel.add(this._bDis);
        this._bNext = _resources.getButton("next", this);
        jPanel.add(this._bNext);
        this._bPrev = _resources.getButton("previous", this);
        jPanel.add(this._bPrev);
        this.getContentPane().add("South", jPanel);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                LogDialog.this.dispose();
            }
        });
        this.doLayout();
    }

    public void print(String string) {
        this._text.append(string);
        int n = this._pos.size();
        int n2 = 0;
        if (n != 0) {
            n2 = (Integer)this._pos.get(n - 1);
        }
        int n3 = this._text.getLineCount();
        try {
            int n4 = this._text.getLineEndOffset(n3 - 1);
            this._text.setSelectionStart(n2);
            this._text.setSelectionEnd(n4);
            this._pos.add(new Integer(n4));
            this._posView = n++;
        }
        catch (BadLocationException badLocationException) {
            System.err.println("LogDialog unexpected error :");
            badLocationException.printStackTrace(System.err);
            System.exit(0);
        }
    }

    public void clear() {
        this._text.setText(null);
        this._pos.clear();
        this._posView = 0;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this._bDis) {
            this.dispose();
        } else if (actionEvent.getSource() == this._bNext) {
            this.computePosView();
            if (this._posView + 1 < this._pos.size()) {
                ++this._posView;
            }
            this.selectPosView();
        } else if (actionEvent.getSource() == this._bPrev) {
            this.computePosView();
            if (this._posView - 1 >= 0) {
                --this._posView;
            }
            this.selectPosView();
        }
    }

    private void selectPosView() {
        if (this._posView == 0) {
            this._text.setSelectionStart(0);
        } else {
            this._text.setSelectionStart((Integer)this._pos.get(this._posView - 1));
        }
        this._text.setSelectionEnd((Integer)this._pos.get(this._posView));
    }

    private void computePosView() {
        if (this._posView >= this._pos.size()) {
            this._posView = 0;
            return;
        }
        Caret caret = this._text.getCaret();
        int n = caret.getDot();
        int n2 = 0;
        if (this._posView != 0) {
            n2 = (Integer)this._pos.get(this._posView - 1);
        }
        int n3 = (Integer)this._pos.get(this._posView);
        if (n >= n2 && n <= n3) {
            return;
        }
        if (n < n2) {
            for (int i = this._posView - 2; i >= 0; --i) {
                if ((Integer)this._pos.get(i) > n) continue;
                this._posView = i + 1;
                return;
            }
            this._posView = 0;
            return;
        }
        for (int i = this._posView + 1; i < this._pos.size(); ++i) {
            if ((Integer)this._pos.get(i) < n) continue;
            this._posView = i;
            return;
        }
        System.err.println("LogDialog unexpected error :");
        Thread.dumpStack();
        System.exit(0);
    }

    static {
        try {
            _resources = (MenuResourceBundle)ResourceBundle.getBundle("simtools.ui.resources.LogDialogResource", CustomizedLocale.get());
        }
        catch (Exception exception) {
            System.err.println("Can't load LogDialog resources");
            System.exit(0);
        }
    }
}

