/*
 * Decompiled with CFR 0.152.
 */
package jsynoptic.builtin;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import jsynoptic.builtin.Abstract1DShape;
import jsynoptic.builtin.Abstract2DShape;
import jsynoptic.ui.JSynoptic;
import jsynoptic.ui.JSynopticBatch;
import jsynoptic.ui.SourceTree;
import simtools.data.DataException;
import simtools.data.DataInfo;
import simtools.data.DataSource;
import simtools.data.DataSourcePool;
import simtools.data.EndNotificationListener;
import simtools.data.UnsupportedOperation;
import simtools.shapes.AbstractShape;
import simtools.ui.ActionCheckBox;
import simtools.ui.ColorMapper;
import simtools.ui.CustomizedLocale;
import simtools.ui.DynamicColorChooser;
import simtools.ui.GenericMapper;
import simtools.ui.MapperListener;
import simtools.ui.NumberField;
import simtools.ui.ResourceFinder;
import simtools.ui.TextMapper;

public class TextShape
extends Abstract2DShape
implements MapperListener {
    static final long serialVersionUID = -6782484932282488103L;
    public static ResourceBundle resources = ResourceFinder.get(class$jsynoptic$builtin$TextShape == null ? (class$jsynoptic$builtin$TextShape = TextShape.class$("jsynoptic.builtin.TextShape")) : class$jsynoptic$builtin$TextShape);
    public static final int FORMAT_STRING = 0;
    public static final int FORMAT_DECIMAL = 1;
    public static final int FORMAT_SCIENTIFIC = 2;
    public static final int FORMAT_HEXADECIMAL = 3;
    public static final int FORMAT_OCTAL = 4;
    public static final int FORMAT_BINARY = 5;
    public static final int FORMAT_MAPPER = 6;
    public static final int MIN_WIDTH = 40;
    public static final int MIN_HEIGHT = 20;
    public static final int MARGIN = 5;
    protected int format;
    protected NumberFormat decimalFormatter;
    protected NumberFormat scientificFormatter;
    protected TextMapper mapper;
    protected String displayPattern = "%v%_%u";
    protected String text;
    protected transient DataSource source;
    protected transient long sourceIndex;
    protected Color textColor = Color.black;
    protected transient Color textDynamicColor = null;
    protected ColorMapper textMapper;
    protected transient DataSource textMapperSource;
    protected transient long textMapperIndex;
    protected static int referenceHeight = -1;
    protected static int referenceWidth = -1;
    protected static int referenceBaseline = -1;
    protected static Font referenceFont = null;
    protected static Object referenceMutex = new Object();
    protected static Graphics referenceGraphics = null;
    protected transient int baseline;
    protected transient Font currentFont;
    protected transient boolean dirtyText = false;
    protected transient boolean dirtyColor = false;
    protected transient EndNotificationListener delegateEndNotificationListener;
    protected transient boolean dirtyState = false;
    protected boolean lockedFont;
    static /* synthetic */ Class class$jsynoptic$builtin$TextShape;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void computeReferences() {
        Object object = referenceMutex;
        synchronized (object) {
            if (referenceFont == null) {
                Graphics graphics;
                Component component = JSynoptic.gui != null ? JSynoptic.gui : (JSynopticBatch.batch != null ? (Component)((Object)JSynopticBatch.batch.getPrintable(0)) : null);
                referenceGraphics = graphics = component != null ? component.createImage(100, 100).getGraphics() : new BufferedImage(100, 100, 1).createGraphics();
                referenceFont = Font.decode("Monospaced");
                referenceFont = referenceFont.deriveFont(100.0f);
                FontMetrics fontMetrics = graphics.getFontMetrics(referenceFont);
                referenceBaseline = fontMetrics.getDescent();
                referenceHeight = fontMetrics.getAscent() + referenceBaseline;
                referenceWidth = fontMetrics.stringWidth("W");
            }
        }
    }

    public void setFormat(int n) {
        this.format = n;
    }

    public String getText() {
        return this.text;
    }

    public void setText(Object object) {
        if (this.format == 6) {
            this.text = this.mapper.getString(object);
            if (this.text == null || this.text.equals("")) {
                this.text = " ";
            }
            return;
        }
        if (object == null) {
            this.text = " ";
            return;
        }
        if (!(object instanceof Number)) {
            this.text = object.toString();
            return;
        }
        Number number = (Number)object;
        switch (this.format) {
            case 1: {
                this.text = this.decimalFormatter.format(number);
                break;
            }
            case 2: {
                this.text = this.scientificFormatter.format(number);
                break;
            }
            case 3: {
                this.text = "0x" + Long.toHexString(number.longValue()).toUpperCase();
                break;
            }
            case 4: {
                this.text = "0" + Long.toOctalString(number.longValue());
                break;
            }
            case 5: {
                this.text = Long.toBinaryString(number.longValue());
                break;
            }
            default: {
                this.text = number.toString();
            }
        }
    }

    protected Shape getDelegateShape() {
        return new Rectangle(this._ox, this._oy - this._h, this._w, this._h);
    }

    protected void constructor() {
        this.format = 0;
        this.decimalFormatter = NumberFormat.getNumberInstance(CustomizedLocale.get());
        this.scientificFormatter = NumberFormat.getNumberInstance(CustomizedLocale.get());
        if (this.scientificFormatter instanceof DecimalFormat) {
            ((DecimalFormat)this.scientificFormatter).applyPattern("0.000E0");
        }
        this.lockedFont = false;
    }

    public TextShape(String string, int n, int n2) {
        this(string, n, n2, true);
    }

    public TextShape(String string, int n, int n2, boolean bl) {
        this(string, 0, 0, n, n2, bl);
    }

    public TextShape(String string, int n, int n2, int n3, int n4) {
        this(string, n, n2, n3, n4, true);
    }

    public TextShape(String string, int n, int n2, int n3, int n4, boolean bl) {
        super(n, n2, n3, n4);
        this.drawColor = null;
        this.text = string;
        this.allowResize = bl;
        this.constructor();
        this.fitText();
        this.delegateEndNotificationListener = this;
    }

    public EndNotificationListener getDelegateEndNotificationListener() {
        return this.delegateEndNotificationListener;
    }

    public void setDelegateEndNotificationListener(EndNotificationListener endNotificationListener) {
        if (this.source != null) {
            this.source.removeEndNotificationListener(this.delegateEndNotificationListener);
        }
        if (this.textMapperSource != null) {
            this.textMapperSource.removeEndNotificationListener(this.delegateEndNotificationListener);
        }
        this.delegateEndNotificationListener = endNotificationListener;
        if (this.source != null) {
            this.source.addEndNotificationListener(this.delegateEndNotificationListener);
        }
        if (this.textMapperSource != null) {
            this.textMapperSource.addEndNotificationListener(this.delegateEndNotificationListener);
        }
    }

    protected void drawHook(Graphics2D graphics2D, boolean bl) {
        Color color;
        if (!bl) {
            return;
        }
        Object object = graphics2D.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        Rectangle rectangle = graphics2D.getClipBounds();
        graphics2D.setClip(this._ox, this._oy - this._h, this._w, this._h);
        Color color2 = color = this.textDynamicColor != null ? this.textDynamicColor : this.textColor;
        if (color != null) {
            graphics2D.setColor(color);
        }
        Font font = graphics2D.getFont();
        graphics2D.setFont(this.currentFont);
        graphics2D.drawString(this.text, this._ox + 5, this._oy - this.baseline);
        graphics2D.setFont(font);
        graphics2D.setClip(rectangle);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, object);
    }

    public void setDimensions(int n, int n2) {
        this._w = n;
        this._h = n2;
        if (this._w < MIN_SIZE) {
            this._w = MIN_SIZE;
        }
        if (this._h < MIN_SIZE) {
            this._h = MIN_SIZE;
        }
        this.ratio = (double)this._w / (double)this._h;
        this.fitText();
    }

    public void overrideDimensions(int n, int n2) {
        this._w = n;
        this._h = n2;
    }

    public void resize(int n, int n2) {
        super.resize(n, n2);
        this.fitText();
    }

    public void fitText() {
        if (this.lockedFont && !this.allowResize) {
            return;
        }
        double d = this._w - 10;
        double d2 = this._h - 10;
        if (d <= 0.0 || d2 <= 0.0) {
            return;
        }
        double d3 = d / (double)(this.text.length() * referenceWidth);
        double d4 = d2 / (double)referenceHeight;
        this.currentFont = referenceFont.deriveFont(AffineTransform.getScaleInstance(d3, d4));
        this.baseline = (int)((double)referenceBaseline * d4);
    }

    public static Font getFontToFitText(String string, int n, int n2) {
        double d = n - 10;
        double d2 = n2 - 10;
        if (d <= 0.0 || d2 <= 0.0) {
            return null;
        }
        double d3 = d / (double)(string.length() * referenceWidth);
        double d4 = d2 / (double)referenceHeight;
        return referenceFont.deriveFont(AffineTransform.getScaleInstance(d3, d4));
    }

    public boolean updateText() {
        Object object;
        String string;
        block26: {
            if (this.source == null) {
                return false;
            }
            string = this.text;
            try {
                String string2;
                String string3;
                this.setText(this.source.getValue(this.sourceIndex));
                if (this.displayPattern == null || this.displayPattern.equals("")) break block26;
                object = DataInfo.getUnit(this.source);
                if (object == null) {
                    object = "";
                }
                if ((string3 = DataInfo.getLabel(this.source)) == null) {
                    string3 = "";
                }
                if ((string2 = DataInfo.getComment(this.source)) == null) {
                    string2 = "";
                }
                if (this.text == null || this.text.equals(" ")) {
                    this.text = "";
                }
                StringBuffer stringBuffer = new StringBuffer(this.displayPattern);
                boolean bl = false;
                int n = stringBuffer.indexOf("%");
                while (n != -1 && n < stringBuffer.length() - 1) {
                    block27: {
                        switch (stringBuffer.charAt(n + 1)) {
                            case 'v': {
                                stringBuffer.replace(n, n + 2, this.text);
                                if (bl && !this.text.equals("")) {
                                    stringBuffer.insert(n++, " ");
                                }
                                n += this.text.length();
                                break;
                            }
                            case 'u': {
                                stringBuffer.replace(n, n + 2, (String)object);
                                if (bl && !((String)object).equals("")) {
                                    stringBuffer.insert(n++, " ");
                                }
                                n += ((String)object).length();
                                break;
                            }
                            case 'n': {
                                stringBuffer.replace(n, n + 2, string3);
                                if (bl && !string3.equals("")) {
                                    stringBuffer.insert(n++, " ");
                                }
                                n += string3.length();
                                break;
                            }
                            case 'c': {
                                stringBuffer.replace(n, n + 2, string2);
                                if (bl && !string2.equals("")) {
                                    stringBuffer.insert(n++, " ");
                                }
                                n += string2.length();
                                break;
                            }
                            case '%': {
                                stringBuffer.replace(n, n + 2, "%");
                                if (bl) {
                                    stringBuffer.insert(n++, " ");
                                }
                                ++n;
                                break;
                            }
                            case '_': {
                                bl = true;
                                stringBuffer.delete(n, n + 2);
                                break block27;
                            }
                            default: {
                                ++n;
                            }
                        }
                        bl = false;
                    }
                    n = stringBuffer.indexOf("%", n);
                }
                this.text = stringBuffer.toString();
                if (this.text == null || this.text.equals("")) {
                    this.text = " ";
                }
            }
            catch (DataException dataException) {
                return false;
            }
        }
        if (this.text.equals(string)) {
            return false;
        }
        if (this.allowResize) {
            object = this.getBounds();
            this._w = (this._w - 10) * this.text.length() / string.length() + 10;
            if (this._w < MIN_SIZE) {
                this._w = MIN_SIZE;
            }
            this.fitText();
            ((Rectangle2D)object).add(this.getBounds());
            this.dirtyRectangle = ((RectangularShape)object).getBounds();
        } else {
            this.fitText();
        }
        return true;
    }

    public void DataSourceValueChanged(DataSource dataSource, long l, long l2) {
        if (dataSource.equals(this.source) && this.sourceIndex >= l && this.sourceIndex <= l2) {
            this.dirtyText = true;
        }
        if (dataSource.equals(this.textMapperSource) && this.textMapperIndex >= l && this.textMapperIndex <= l2) {
            this.dirtyColor = true;
        }
        super.DataSourceValueChanged(dataSource, l, l2);
    }

    public void DataSourceIndexRangeChanged(DataSource dataSource, long l, long l2) {
        if (dataSource.equals(this.source)) {
            this.sourceIndex = l2;
            this.dirtyText = true;
        }
        if (dataSource.equals(this.textMapperSource)) {
            this.textMapperIndex = l2;
            this.dirtyColor = true;
        }
        super.DataSourceIndexRangeChanged(dataSource, l, l2);
    }

    public void notificationEnd(Object object) {
        if (this.dirtyText) {
            this.dirty |= this.updateText();
            this.dirtyText = false;
        }
        if (this.dirtyColor) {
            Color color = null;
            if (this.textMapper != null) {
                color = (Color)this.textMapper.getPaint(this.textMapperSource, this.textMapperIndex);
            }
            this.dirty = color == null ? (this.dirty |= this.textDynamicColor != null) : (this.dirty |= !color.equals(this.textDynamicColor));
            this.textDynamicColor = color;
            this.dirtyColor = false;
        }
        super.notificationEnd(object);
    }

    public String[] getActions(double d, double d2, Object object, int n) {
        if (n == 3) {
            return null;
        }
        if (n == 4) {
            return null;
        }
        if (n == 5) {
            return null;
        }
        Vector<String> vector = new Vector<String>();
        String[] stringArray = super.getActions(d, d2, object, n);
        for (int i = 0; i < stringArray.length; ++i) {
            vector.add(stringArray[i]);
        }
        if (n == 1 && object instanceof DataSource) {
            vector.add(resources.getString("SetSource"));
        }
        return vector.toArray(new String[vector.size()]);
    }

    public void setSource(DataSource dataSource) {
        if (this.source != null) {
            this.source.removeListener(this);
            this.source.removeEndNotificationListener(this.delegateEndNotificationListener);
        }
        this.source = dataSource;
        if (this.source == null) {
            return;
        }
        this.source.addListener(this);
        this.source.addEndNotificationListener(this.delegateEndNotificationListener);
        try {
            this.sourceIndex = this.source.computeLastIndex();
        }
        catch (UnsupportedOperation unsupportedOperation) {
            try {
                this.sourceIndex = this.source.getLastIndex();
            }
            catch (UnsupportedOperation unsupportedOperation2) {
                try {
                    this.sourceIndex = this.source.getStartIndex();
                }
                catch (UnsupportedOperation unsupportedOperation3) {
                    this.sourceIndex = 0L;
                }
            }
        }
        this.updateText();
    }

    public boolean doAction(double d, double d2, Object object, String string) {
        if (string.equals(resources.getString("SetSource"))) {
            this.setSource((DataSource)object);
            return true;
        }
        return super.doAction(d, d2, object, string);
    }

    public Abstract1DShape.PropertiesPanel createPanel(boolean bl) {
        return new TextPropertiesPanel(bl);
    }

    public Abstract1DShape.PropertiesPanel createPanel() {
        return this.createPanel(true);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        DataSourcePool.global.writeDataSource(objectOutputStream, this.textMapperSource);
        DataSourcePool.global.writeDataSource(objectOutputStream, this.source);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        if (this.textMapper != null) {
            this.textMapper.addListener(this);
        }
        if (this.mapper != null) {
            this.mapper.addListener(this);
        }
        this.delegateEndNotificationListener = this;
        this.textMapperSource = DataSourcePool.global.readDataSource(objectInputStream);
        if (this.textMapperSource != null) {
            try {
                this.textMapperIndex = this.textMapperSource.getLastIndex();
                this.textMapperSource.addListener(this);
                this.textMapperSource.addEndNotificationListener(this.delegateEndNotificationListener);
            }
            catch (UnsupportedOperation unsupportedOperation) {
                this.textMapperIndex = 0L;
            }
        }
        this.textDynamicColor = this.textMapper != null ? (Color)this.textMapper.getPaint(this.textMapperSource, this.textMapperIndex) : null;
        this.source = DataSourcePool.global.readDataSource(objectInputStream);
        if (this.source != null) {
            try {
                this.sourceIndex = this.source.getLastIndex();
                this.source.addListener(this);
                this.source.addEndNotificationListener(this.delegateEndNotificationListener);
            }
            catch (UnsupportedOperation unsupportedOperation) {
                this.sourceIndex = 0L;
            }
        }
        this.fitText();
    }

    protected AbstractShape cloneShape() {
        TextShape textShape = (TextShape)super.cloneShape();
        textShape.decimalFormatter = (NumberFormat)this.decimalFormatter.clone();
        textShape.scientificFormatter = (NumberFormat)this.scientificFormatter.clone();
        return textShape;
    }

    public void mappingChanged(GenericMapper genericMapper) {
        if (genericMapper.equals(this.mapper)) {
            this.updateText();
        }
        this.notifyChange();
    }

    protected synchronized void notifyChange(Rectangle rectangle) {
        this.dirtyState = true;
        super.notifyChange(rectangle);
    }

    public boolean isDirtyState() {
        return this.dirtyState;
    }

    public void setDirtyState(boolean bl) {
        this.dirtyState = bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        TextShape.computeReferences();
    }

    public class TextPropertiesPanel
    extends Abstract2DShape.PropertiesPanel2D {
        private PropertyChangeSupport changes = new PropertyChangeSupport(this);
        protected JButton btextcolor;
        protected JButton bbackcolor;
        protected JButton bframecolor;
        protected JButton beditmapper;
        protected JButton bnewmapper;
        protected JButton bdelmapper;
        protected Color noColor;
        protected ActionCheckBox cbResize;
        protected ActionCheckBox cbDataSource;
        protected JCheckBox cbBack;
        protected JCheckBox cbFrame;
        protected JLabel lwidth;
        protected JLabel lheight;
        protected JLabel lmapper;
        protected NumberField nfWidth;
        protected NumberField nfHeight;
        protected NumberField nfformat;
        protected JTextField tfText;
        protected JTextField tfpattern;
        protected SourceTree dstree;
        protected JLabel lformat;
        protected JLabel lpattern;
        protected JComboBox cbxformat;
        protected JComboBox cbxmapper;
        protected JLabel lformatdigits;
        protected JPanel cards;
        protected Color textColor;
        protected ColorMapper textMapper;
        protected transient DataSource textMapperSource;
        protected transient DataSource source;

        public TextPropertiesPanel() {
            this(true);
        }

        public TextPropertiesPanel(boolean bl) {
            this.setLayout(new BorderLayout());
            this.add((Component)this.createContent(bl), "Center");
        }

        public JComponent createContent(boolean bl) {
            this.textColor = TextShape.this.textColor;
            this.textMapper = TextShape.this.textMapper;
            this.textMapperSource = TextShape.this.textMapperSource;
            this.source = TextShape.this.source;
            Box box = Box.createVerticalBox();
            Box box2 = Box.createHorizontalBox();
            this.tfText = new JTextField(TextShape.this.text);
            box2.add(this.tfText);
            this.btextcolor = new JButton("    ");
            box2.add(this.btextcolor);
            this.noColor = this.btextcolor.getBackground();
            this.btextcolor.setFocusPainted(false);
            this.btextcolor.setBackground(this.textColor);
            box.add(box2);
            box.add(super.createContent(bl, true));
            box2 = Box.createHorizontalBox();
            this.cbDataSource = new ActionCheckBox(this, resources.getString("UseADataSource"), this.source != null){
                private final /* synthetic */ TextPropertiesPanel this$1;
                {
                    this.this$1 = textPropertiesPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.dstree.setEnabled(this.isSelected());
                    this.this$1.cbxformat.setEnabled(this.isSelected());
                    this.this$1.lformat.setEnabled(this.isSelected());
                    this.this$1.cbxformat.setEnabled(this.isSelected());
                    this.this$1.lpattern.setEnabled(this.isSelected());
                    this.this$1.tfpattern.setEnabled(this.isSelected());
                    this.this$1.tfText.setEnabled(!this.isSelected());
                    if (this.isSelected()) {
                        String string;
                        Object object = this.this$1.dstree.getSelectedSourceOrCollection();
                        this.this$1.source = object instanceof DataSource ? (DataSource)object : null;
                        ActionListener[] actionListenerArray = this.this$1.cbxformat.getActionListeners();
                        if (actionListenerArray != null) {
                            for (int i = 0; i < actionListenerArray.length; ++i) {
                                actionListenerArray[i].actionPerformed(new ActionEvent(this.this$1.cbxformat, 0, ""));
                            }
                        }
                        if ((string = DataInfo.getLabel(this.this$1.source)) == null || string.equals("")) {
                            string = this.this$1.tfText.getText();
                        }
                        this.this$1.setName(string);
                    } else {
                        this.this$1.source = null;
                        this.this$1.lformatdigits.setEnabled(false);
                        this.this$1.nfformat.setEnabled(false);
                        this.this$1.setName(this.this$1.tfText.getText());
                    }
                }
            };
            box2.add(this.cbDataSource);
            box2.add(Box.createHorizontalGlue());
            box.add(box2);
            this.dstree = new SourceTree(DataSourcePool.global);
            this.dstree.setVisibleRowCount(5);
            JScrollPane jScrollPane = new JScrollPane(this.dstree);
            box.add(jScrollPane);
            box2 = Box.createHorizontalBox();
            this.lformat = new JLabel(resources.getString("ValueFormat"));
            box2.add(this.lformat);
            box2.add(Box.createHorizontalGlue());
            this.cbxformat = new JComboBox();
            box2.add(this.cbxformat);
            this.cbxformat.addItem(resources.getString("String"));
            this.cbxformat.addItem(resources.getString("Decimal"));
            this.cbxformat.addItem(resources.getString("Scientific"));
            this.cbxformat.addItem(resources.getString("Hexadecimal"));
            this.cbxformat.addItem(resources.getString("Octal"));
            this.cbxformat.addItem(resources.getString("Binary"));
            this.cbxformat.addItem(resources.getString("UseMapper"));
            this.cbxformat.setEditable(false);
            box.add(box2);
            this.cards = new JPanel();
            this.cards.setLayout(new CardLayout());
            box2 = Box.createHorizontalBox();
            this.lformatdigits = new JLabel(resources.getString("DecimalDigits:"));
            box2.add(this.lformatdigits);
            box2.add(Box.createHorizontalGlue());
            long l = 0L;
            if (TextShape.this.format == 1) {
                l = TextShape.this.decimalFormatter.getMaximumFractionDigits();
            } else if (TextShape.this.format == 2 && TextShape.this.scientificFormatter instanceof DecimalFormat) {
                String string = ((DecimalFormat)TextShape.this.scientificFormatter).toPattern();
                l = 0L;
                l = string.indexOf(69) - string.indexOf(46);
                if (l > 0L) {
                    --l;
                }
            }
            this.nfformat = new NumberField(l, 3);
            box2.add(this.nfformat);
            this.nfformat.setColumns(3);
            this.nfformat.setHorizontalAlignment(4);
            this.cards.add((Component)box2, "bounds");
            box2 = Box.createHorizontalBox();
            this.cbxmapper = new JComboBox();
            box2.add(this.cbxmapper);
            this.cbxmapper.addItem(resources.getString("=======NONE======="));
            int n = 0;
            if (TextMapper.textMappers != null) {
                for (int i = 0; i < TextMapper.textMappers.size(); ++i) {
                    TextMapper textMapper = (TextMapper)TextMapper.textMappers.get(i);
                    if (textMapper.equals(TextShape.this.mapper)) {
                        n = i + 1;
                    }
                    this.cbxmapper.addItem(textMapper);
                }
            }
            this.cbxmapper.setEditable(false);
            this.cbxmapper.setSelectedIndex(n);
            box2.add(this.cbxmapper);
            box2.add(Box.createHorizontalGlue());
            this.beditmapper = new JButton(resources.getString("Edit"));
            box2.add(this.beditmapper);
            this.bnewmapper = new JButton(resources.getString("New"));
            box2.add(this.bnewmapper);
            this.bdelmapper = new JButton(resources.getString("Delete"));
            box2.add(this.bdelmapper);
            if (n == 0) {
                this.beditmapper.setEnabled(false);
                this.bdelmapper.setEnabled(false);
            }
            this.cbxmapper.setRenderer(new ListCellRenderer(this){
                private final /* synthetic */ TextPropertiesPanel this$1;
                {
                    this.this$1 = textPropertiesPanel;
                }

                public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                    String string = object.toString();
                    if (string.length() > 18) {
                        string = string.substring(0, 15) + "...";
                    }
                    return new JLabel(string);
                }
            });
            this.beditmapper.addActionListener(new ActionListener(this){
                private final /* synthetic */ TextPropertiesPanel this$1;
                {
                    this.this$1 = textPropertiesPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    if (TextPropertiesPanel.access$000((TextPropertiesPanel)this.this$1).mapper == null) {
                        return;
                    }
                    TextPropertiesPanel.access$000((TextPropertiesPanel)this.this$1).mapper.editDialog(null);
                    this.this$1.cbxmapper.repaint();
                }
            });
            this.bnewmapper.addActionListener(new ActionListener(this){
                private final /* synthetic */ TextPropertiesPanel this$1;
                {
                    this.this$1 = textPropertiesPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    TextPropertiesPanel.access$000((TextPropertiesPanel)this.this$1).mapper = TextMapper.createTextMapperDialog(null);
                    if (TextMapper.textMappers == null) {
                        TextMapper.textMappers = new Vector<E>();
                    }
                    TextMapper.textMappers.add(TextPropertiesPanel.access$000((TextPropertiesPanel)this.this$1).mapper);
                    this.this$1.cbxmapper.addItem(TextPropertiesPanel.access$000((TextPropertiesPanel)this.this$1).mapper);
                    this.this$1.cbxmapper.setSelectedItem(TextPropertiesPanel.access$000((TextPropertiesPanel)this.this$1).mapper);
                    this.this$1.cards.revalidate();
                    TextPropertiesPanel.access$000((TextPropertiesPanel)this.this$1).mapper.addListener(TextPropertiesPanel.access$000(this.this$1));
                }
            });
            this.bdelmapper.addActionListener(new ActionListener(this){
                private final /* synthetic */ TextPropertiesPanel this$1;
                {
                    this.this$1 = textPropertiesPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    if (TextPropertiesPanel.access$000((TextPropertiesPanel)this.this$1).mapper == null) {
                        return;
                    }
                    TextPropertiesPanel.access$000((TextPropertiesPanel)this.this$1).mapper.removeListener(TextPropertiesPanel.access$000(this.this$1));
                    if (TextMapper.textMappers != null) {
                        TextMapper.textMappers.remove(TextPropertiesPanel.access$000((TextPropertiesPanel)this.this$1).mapper);
                    }
                    this.this$1.cbxmapper.removeItem(TextPropertiesPanel.access$000((TextPropertiesPanel)this.this$1).mapper);
                    this.this$1.cbxmapper.setSelectedIndex(0);
                    TextPropertiesPanel.access$000((TextPropertiesPanel)this.this$1).mapper = null;
                    this.this$1.bdelmapper.setEnabled(false);
                    this.this$1.beditmapper.setEnabled(false);
                }
            });
            this.cbxmapper.addActionListener(new ActionListener(this){
                private final /* synthetic */ TextPropertiesPanel this$1;
                {
                    this.this$1 = textPropertiesPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    int n = this.this$1.cbxmapper.getSelectedIndex();
                    if (n == 0) {
                        this.this$1.beditmapper.setEnabled(false);
                        this.this$1.bdelmapper.setEnabled(false);
                        if (TextPropertiesPanel.access$000((TextPropertiesPanel)this.this$1).mapper != null) {
                            TextPropertiesPanel.access$000((TextPropertiesPanel)this.this$1).mapper.removeListener(TextPropertiesPanel.access$000(this.this$1));
                        }
                        TextPropertiesPanel.access$000((TextPropertiesPanel)this.this$1).mapper = null;
                    } else {
                        if (TextPropertiesPanel.access$000((TextPropertiesPanel)this.this$1).mapper != null) {
                            TextPropertiesPanel.access$000((TextPropertiesPanel)this.this$1).mapper.removeListener(TextPropertiesPanel.access$000(this.this$1));
                        }
                        TextPropertiesPanel.access$000((TextPropertiesPanel)this.this$1).mapper = (TextMapper)this.this$1.cbxmapper.getItemAt(n);
                        TextPropertiesPanel.access$000((TextPropertiesPanel)this.this$1).mapper.addListener(TextPropertiesPanel.access$000(this.this$1));
                        this.this$1.beditmapper.setEnabled(true);
                        this.this$1.bdelmapper.setEnabled(true);
                    }
                }
            });
            this.cards.add((Component)box2, "mapper");
            box.add(this.cards);
            CardLayout cardLayout = (CardLayout)this.cards.getLayout();
            if (TextShape.this.format == 6) {
                cardLayout.show(this.cards, "mapper");
            } else {
                cardLayout.show(this.cards, "bounds");
            }
            box2 = Box.createHorizontalBox();
            this.lpattern = new JLabel(resources.getString("DisplayPattern:"));
            box2.add(this.lpattern);
            box2.add(Box.createHorizontalGlue());
            this.tfpattern = new JTextField(TextShape.this.displayPattern);
            box2.add(this.tfpattern);
            this.tfpattern.setHorizontalAlignment(4);
            box.add(box2);
            this.tfText.getDocument().addDocumentListener(new DocumentListener(this){
                private final /* synthetic */ TextPropertiesPanel this$1;
                {
                    this.this$1 = textPropertiesPanel;
                }

                public void insertUpdate(DocumentEvent documentEvent) {
                    this.updateName();
                }

                public void removeUpdate(DocumentEvent documentEvent) {
                    this.updateName();
                }

                public void changedUpdate(DocumentEvent documentEvent) {
                    this.updateName();
                }

                private void updateName() {
                    this.this$1.setName(this.this$1.tfText.getText());
                }
            });
            this.setName(this.tfText.getText());
            this.cbxformat.addActionListener(new ActionListener(this){
                private final /* synthetic */ TextPropertiesPanel this$1;
                {
                    this.this$1 = textPropertiesPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    Object object;
                    long l = -1L;
                    if (this.this$1.cbxformat.getSelectedIndex() == 1) {
                        l = TextPropertiesPanel.access$000((TextPropertiesPanel)this.this$1).decimalFormatter.getMaximumFractionDigits();
                    } else if (this.this$1.cbxformat.getSelectedIndex() == 2 && TextPropertiesPanel.access$000((TextPropertiesPanel)this.this$1).scientificFormatter instanceof DecimalFormat) {
                        object = ((DecimalFormat)TextPropertiesPanel.access$000((TextPropertiesPanel)this.this$1).scientificFormatter).toPattern();
                        l = 0L;
                        l = ((String)object).indexOf(69) - ((String)object).indexOf(46);
                        if (l > 0L) {
                            --l;
                        }
                    }
                    if (l != -1L) {
                        this.this$1.nfformat.setEnabled(true);
                        this.this$1.nfformat.setValue(l);
                        this.this$1.lformatdigits.setEnabled(true);
                    } else {
                        this.this$1.nfformat.setEnabled(false);
                        this.this$1.nfformat.setValue(0L);
                        this.this$1.lformatdigits.setEnabled(false);
                    }
                    object = (CardLayout)this.this$1.cards.getLayout();
                    if (this.this$1.cbxformat.getSelectedIndex() == 6) {
                        ((CardLayout)object).show(this.this$1.cards, "mapper");
                    } else {
                        ((CardLayout)object).show(this.this$1.cards, "bounds");
                    }
                }
            });
            this.cbxformat.setSelectedIndex(TextShape.this.format);
            this.btextcolor.addActionListener(new ActionListener(this){
                private final /* synthetic */ TextPropertiesPanel this$1;
                {
                    this.this$1 = textPropertiesPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    DataSource dataSource = this.this$1.textMapperSource == null ? this.this$1.source : this.this$1.textMapperSource;
                    Color color = DynamicColorChooser.showDialog(null, resources.getString("ChooseATextColor"), null, this.this$1.textColor, dataSource, this.this$1.textMapper);
                    if (color == null) {
                        return;
                    }
                    this.this$1.textColor = color;
                    this.this$1.textMapperSource = DynamicColorChooser.getSource();
                    this.this$1.textMapper = DynamicColorChooser.getMapper();
                    this.this$1.btextcolor.setBackground(this.this$1.textColor);
                }
            });
            this.dstree.addTreeSelectionListener(new TreeSelectionListener(this){
                private final /* synthetic */ TextPropertiesPanel this$1;
                {
                    this.this$1 = textPropertiesPanel;
                }

                public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                    if (!treeSelectionEvent.isAddedPath()) {
                        return;
                    }
                    Object object = this.this$1.dstree.getSelectedSourceOrCollection();
                    this.this$1.source = object instanceof DataSource ? (DataSource)object : null;
                    String string = DataInfo.getLabel(this.this$1.source);
                    if (string == null || string.equals("")) {
                        string = this.this$1.tfText.getText();
                    }
                    this.this$1.setName(string);
                }
            });
            this.dstree.setSelectedValue(this.source);
            this.cbDataSource.apply();
            return box;
        }

        public void updateProperties() {
            super.updateProperties();
            TextShape.this.textColor = this.textColor;
            TextShape.this.textMapper = this.textMapper;
            if (TextShape.this.textMapperSource != null) {
                TextShape.this.textMapper.removeListener(TextShape.this);
                TextShape.this.textMapperSource.removeListener(TextShape.this);
                TextShape.this.textMapperSource.removeEndNotificationListener(TextShape.this.delegateEndNotificationListener);
            }
            TextShape.this.textMapperSource = this.textMapperSource;
            if (TextShape.this.textMapperSource != null) {
                try {
                    TextShape.this.textMapperIndex = TextShape.this.textMapperSource.getLastIndex();
                }
                catch (UnsupportedOperation unsupportedOperation) {
                    TextShape.this.textMapperIndex = 0L;
                }
                TextShape.this.textMapper.addListener(TextShape.this);
                TextShape.this.textMapperSource.addListener(TextShape.this);
                TextShape.this.textMapperSource.addEndNotificationListener(TextShape.this.delegateEndNotificationListener);
            }
            TextShape.this.text = this.tfText.getText();
            if (this.cbDataSource.isSelected()) {
                TextShape.this.format = this.cbxformat.getSelectedIndex();
                if (TextShape.this.format < 0) {
                    TextShape.this.format = 0;
                }
                if (TextShape.this.format == 6 && TextShape.this.mapper == null) {
                    TextShape.this.format = 0;
                }
                if (TextShape.this.format == 1) {
                    TextShape.this.decimalFormatter.setMaximumFractionDigits((int)this.nfformat.getLongValue());
                } else if (TextShape.this.format == 2 && TextShape.this.scientificFormatter instanceof DecimalFormat) {
                    int n = (int)this.nfformat.getLongValue();
                    String string = "0.";
                    for (int i = 0; i < n; ++i) {
                        string = string + "0";
                    }
                    string = string + "E0";
                    ((DecimalFormat)TextShape.this.scientificFormatter).applyPattern(string);
                }
                TextShape.this.displayPattern = this.tfpattern.getText();
            } else {
                this.source = null;
            }
            TextShape.this.setSource(this.source);
            if (this.source == null) {
                TextShape.this.updateText();
            }
        }

        public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
            super.addPropertyChangeListener(string, propertyChangeListener);
            this.changes.addPropertyChangeListener(string, propertyChangeListener);
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            super.addPropertyChangeListener(propertyChangeListener);
            this.changes.addPropertyChangeListener(propertyChangeListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            super.removePropertyChangeListener(propertyChangeListener);
            this.changes.removePropertyChangeListener(propertyChangeListener);
        }

        public void setName(String string) {
            String string2 = this.getName();
            if (string2 == null) {
                string2 = "";
            }
            if (string == null) {
                string = "";
            }
            super.setName(string);
            if (!string2.equals(string)) {
                this.changes.firePropertyChange("name", string2, string);
            }
        }

        public String toString() {
            String string = this.getName();
            if (string == null) {
                return super.toString();
            }
            return string;
        }

        protected String fillColorChooserTitle() {
            return resources.getString("ChooseBackgroundColor");
        }

        protected String fillColorLabel() {
            return resources.getString("UseBackgroundColor");
        }

        protected String lineColorChooserTitle() {
            return resources.getString("ChooseFrameColor");
        }

        protected String lineColorLabel() {
            return resources.getString("DisplayFrame");
        }

        static /* synthetic */ TextShape access$000(TextPropertiesPanel textPropertiesPanel) {
            return textPropertiesPanel.TextShape.this;
        }
    }
}

