/*
 * Decompiled with CFR 0.152.
 */
package simtools.diagram.test;

import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JToolBar;
import simtools.diagram.DiagramClipboard;
import simtools.diagram.DiagramComponent;
import simtools.diagram.test.TestComponent;
import simtools.ui.DesktopCardPanel;

public class TestFrame
extends JFrame
implements ActionListener {
    private DesktopCardPanel _editorPanel;
    private JButton _bPrint;
    private JButton _bAdjust;
    private JButton _bAlign;
    private JComboBox _cbZoom;
    private JComboBox _cbGrid;
    private JCheckBox _cbGridDisplay;
    private JFileChooser _chooser = new JFileChooser();

    public TestFrame() {
        super("DesktopCardPanel Test");
        this._editorPanel = new DesktopCardPanel(true);
        this.getContentPane().add("Center", this._editorPanel);
        this.getContentPane().add("North", this.createToolBar());
        this.setJMenuBar(this.createMenuBar());
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        this._editorPanel.addComponent(new TestComponent());
        this._editorPanel.addComponent(new TestComponent());
        this._editorPanel.addComponent(new TestComponent());
        DiagramClipboard.create();
        this.pack();
        this.show();
    }

    public JMenuBar createMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.add(this._editorPanel.createMenu(null));
        return jMenuBar;
    }

    public JToolBar createToolBar() {
        JToolBar jToolBar = new JToolBar();
        jToolBar.setMargin(new Insets(1, 1, 1, 1));
        this._bPrint = new JButton("Print");
        this._bPrint.addActionListener(this);
        jToolBar.add(this._bPrint);
        this._bAdjust = new JButton("Adjust");
        this._bAdjust.addActionListener(this);
        jToolBar.add(this._bAdjust);
        this._bAlign = new JButton("Align");
        this._bAlign.addActionListener(this);
        jToolBar.add(this._bAlign);
        JLabel jLabel = new JLabel("Zoom", 4);
        jLabel.setAlignmentY(0.0f);
        jToolBar.add(jLabel);
        this._cbZoom = new JComboBox();
        this._cbZoom.setAlignmentY(0.0f);
        this._cbZoom.addItem("500%");
        this._cbZoom.addItem("200%");
        this._cbZoom.addItem("150%");
        this._cbZoom.addItem("100%");
        this._cbZoom.addItem("75%");
        this._cbZoom.addItem("50%");
        this._cbZoom.addItem("25%");
        this._cbZoom.addItem("10%");
        this._cbZoom.setSelectedItem("100%");
        this._cbZoom.setEditable(true);
        this._cbZoom.addActionListener(this);
        jToolBar.add(this._cbZoom);
        JLabel jLabel2 = new JLabel("Grid", 4);
        jLabel2.setAlignmentY(0.0f);
        jToolBar.add(jLabel2);
        this._cbGrid = new JComboBox();
        this._cbGrid.setAlignmentY(0.0f);
        this._cbGrid.addItem("0");
        this._cbGrid.addItem("5");
        this._cbGrid.addItem("10");
        this._cbGrid.addItem("20");
        this._cbGrid.addItem("40");
        this._cbGrid.setSelectedItem("0");
        this._cbGrid.setEditable(true);
        this._cbGrid.addActionListener(this);
        jToolBar.add(this._cbGrid);
        this._cbGridDisplay = new JCheckBox("Grid Display");
        this._cbGridDisplay.addActionListener(this);
        jToolBar.add(this._cbGridDisplay);
        return jToolBar;
    }

    private double getZoomValue() {
        try {
            String string = (String)this._cbZoom.getSelectedItem();
            if (string.endsWith("%")) {
                string = string.substring(0, string.length() - 1);
            }
            Double d = new Double(string);
            return d / 100.0;
        }
        catch (Exception exception) {
            return -1.0;
        }
    }

    private DiagramComponent getDiagram() {
        JComponent jComponent = this._editorPanel.getSelectedComponent();
        if (jComponent instanceof DiagramComponent) {
            return (DiagramComponent)jComponent;
        }
        return null;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object;
        Object object2;
        if (actionEvent.getSource() == this._bPrint) {
            object2 = PrinterJob.getPrinterJob();
            object = this.getDiagram();
            if (object == null) {
                return;
            }
            ((PrinterJob)object2).setPrintable((Printable)object);
            try {
                ((PrinterJob)object2).print();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (actionEvent.getSource() == this._bAdjust) {
            object2 = this.getDiagram();
            if (object2 == null) {
                return;
            }
            ((DiagramComponent)object2).adjust();
        }
        if (actionEvent.getSource() == this._bAlign) {
            object2 = this.getDiagram();
            if (object2 == null) {
                return;
            }
            ((DiagramComponent)object2).align();
        }
        if (actionEvent.getSource() == this._cbZoom) {
            object2 = this.getDiagram();
            if (object2 == null) {
                return;
            }
            ((DiagramComponent)object2).setZoom(this.getZoomValue());
        }
        if (actionEvent.getSource() == this._cbGridDisplay) {
            object2 = this.getDiagram();
            if (object2 == null) {
                return;
            }
            ((DiagramComponent)object2).setGridDisplay(this._cbGridDisplay.isSelected());
        }
        if (actionEvent.getSource() == this._cbGrid) {
            object2 = this.getDiagram();
            if (object2 == null) {
                return;
            }
            try {
                object = (String)this._cbGrid.getSelectedItem();
                Integer n = new Integer((String)object);
                ((DiagramComponent)object2).setGrid(n);
            }
            catch (Exception exception) {
                ((DiagramComponent)object2).setGrid(0);
            }
        }
    }

    public static void main(String[] stringArray) {
        TestFrame testFrame = null;
        testFrame = new TestFrame();
    }
}

