/*
 * Decompiled with CFR 0.152.
 */
package simtools.ui;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.PrinterJob;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import simtools.ui.CustomizedLocale;
import simtools.ui.MenuResourceBundle;
import simtools.ui.ResourceFinder;

public class PrintDialog
extends JDialog
implements ActionListener {
    public static MenuResourceBundle resources = ResourceFinder.getMenu(class$simtools$ui$PrintDialog == null ? (class$simtools$ui$PrintDialog = PrintDialog.class$("simtools.ui.PrintDialog")) : class$simtools$ui$PrintDialog);
    protected Paper[] papers;
    protected Vector paperNames;
    protected JRadioButton printAllButton;
    protected JRadioButton printSelectedButton;
    protected JRadioButton portraitButton;
    protected JRadioButton landscapeButton;
    protected JRadioButton reverseLandscapeButton;
    protected JButton printerPropertiesButton;
    protected JButton cancelPrintButton;
    protected JButton printButton;
    protected JComboBox paperNameList;
    protected WholeNumberField wnf;
    protected boolean selectionOnly;
    protected PrinterJob printerJob;
    protected PageFormat pageFormat;
    protected boolean printOK;
    static /* synthetic */ Class class$simtools$ui$PrintDialog;

    public PrintDialog(String string) {
        this(string, null, null, false);
    }

    public PrintDialog(String string, PrinterJob printerJob, PageFormat pageFormat, boolean bl) {
        super((Frame)null, string, true);
        this.printerJob = printerJob == null ? PrinterJob.getPrinterJob() : printerJob;
        this.printerJob.setJobName(string);
        this.pageFormat = pageFormat == null ? this.printerJob.defaultPage() : this.printerJob.validatePage(pageFormat);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds(dimension.width / 2, 2 * dimension.height / 3, dimension.width / 2, dimension.height / 3);
        Box box = new Box(1);
        this.getContentPane().add(box);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 2));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), resources.getStringValue("printSelectionPanelTitle")));
        this.printAllButton = resources.getRadioButton("printAll", this);
        this.printSelectedButton = resources.getRadioButton("printSelected", this);
        jPanel2.add(this.printAllButton);
        jPanel2.add(this.printSelectedButton);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.printAllButton);
        buttonGroup.add(this.printSelectedButton);
        if (bl) {
            this.printSelectedButton.setSelected(true);
        } else {
            this.printAllButton.setSelected(true);
        }
        this.selectionOnly = bl;
        jPanel.add(jPanel2);
        JPanel jPanel3 = new JPanel();
        jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), resources.getStringValue("numCopiesTitle")));
        this.wnf = new WholeNumberField(1, 4);
        this.wnf.addActionListener(this);
        jPanel3.add(this.wnf);
        jPanel.add(jPanel3);
        box.add(jPanel);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayout(1, 2));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BoxLayout(jPanel5, 1));
        jPanel5.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), resources.getStringValue("paperSize")));
        int n = resources.getIntValue("paperNumber");
        this.paperNames = new Vector(n);
        this.papers = new Paper[n];
        for (int i = 0; i < n; ++i) {
            this.paperNames.add(resources.getStringValue("paper" + i + "Name"));
            this.papers[i] = new Paper();
            this.papers[i].setSize(resources.getDoubleValue("paper" + i + "Width"), resources.getDoubleValue("paper" + i + "Height"));
            this.papers[i].setImageableArea(resources.getDoubleValue("paper" + i + "ImageableX"), resources.getDoubleValue("paper" + i + "ImageableY"), resources.getDoubleValue("paper" + i + "ImageableWidth"), resources.getDoubleValue("paper" + i + "ImageableHeight"));
        }
        this.paperNameList = new JComboBox(this.paperNames);
        this.paperNameList.addActionListener(this);
        jPanel5.add(this.paperNameList);
        jPanel5.setAlignmentY(0.0f);
        jPanel5.setAlignmentX(0.5f);
        jPanel4.add(jPanel5);
        this.pageFormat.setPaper(this.papers[this.paperNameList.getSelectedIndex()]);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BoxLayout(jPanel6, 1));
        jPanel6.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), resources.getStringValue("paperOrientation")));
        this.portraitButton = resources.getRadioButton("portraitOrientation", this);
        this.landscapeButton = resources.getRadioButton("landscapeOrientation", this);
        this.reverseLandscapeButton = resources.getRadioButton("reverseLandscapeOrientation", this);
        jPanel6.add(this.portraitButton);
        jPanel6.add(this.landscapeButton);
        jPanel6.add(this.reverseLandscapeButton);
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(this.portraitButton);
        buttonGroup2.add(this.landscapeButton);
        buttonGroup2.add(this.reverseLandscapeButton);
        this.landscapeButton.setSelected(true);
        this.pageFormat.setOrientation(0);
        jPanel6.setAlignmentX(0.5f);
        jPanel6.setAlignmentY(0.0f);
        jPanel4.add(jPanel6);
        box.add(jPanel4);
        JPanel jPanel7 = new JPanel();
        this.printerPropertiesButton = resources.getButton("printerPropertiesButton", this);
        this.cancelPrintButton = resources.getButton("cancelPrintButton", this);
        this.printButton = resources.getButton("printButton", this);
        jPanel7.add(this.printerPropertiesButton);
        jPanel7.add(this.cancelPrintButton);
        jPanel7.add(this.printButton);
        box.add(jPanel7);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                PrintDialog.this.printOK = false;
                PrintDialog.this.dispose();
            }
        });
        this.pack();
        this.doLayout();
    }

    public PrinterJob getPrinterJob() {
        return this.printerJob;
    }

    public PageFormat getPageFormat() {
        return this.pageFormat;
    }

    public boolean getResult() {
        return this.printOK;
    }

    public boolean printSelection() {
        return this.selectionOnly;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.printAllButton) {
            this.selectionOnly = false;
            return;
        }
        if (actionEvent.getSource() == this.printSelectedButton) {
            this.selectionOnly = true;
            return;
        }
        if (actionEvent.getSource() == this.portraitButton) {
            this.pageFormat.setOrientation(1);
            return;
        }
        if (actionEvent.getSource() == this.landscapeButton) {
            this.pageFormat.setOrientation(0);
            return;
        }
        if (actionEvent.getSource() == this.reverseLandscapeButton) {
            this.pageFormat.setOrientation(2);
            return;
        }
        if (actionEvent.getSource() == this.printerPropertiesButton) {
            this.printOK = this.printerJob.printDialog();
            this.dispose();
            return;
        }
        if (actionEvent.getSource() == this.cancelPrintButton) {
            this.printOK = false;
            this.dispose();
            return;
        }
        if (actionEvent.getSource() == this.printButton) {
            this.printOK = true;
            this.dispose();
            return;
        }
        if (actionEvent.getSource() == this.paperNameList) {
            this.pageFormat.setPaper(this.papers[this.paperNameList.getSelectedIndex()]);
            return;
        }
        if (actionEvent.getSource() == this.wnf) {
            this.printerJob.setCopies(this.wnf.getValue());
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class WholeNumberField
    extends JTextField {
        private Toolkit toolkit = Toolkit.getDefaultToolkit();
        private NumberFormat integerFormatter = NumberFormat.getNumberInstance(CustomizedLocale.get());

        public WholeNumberField(int n, int n2) {
            super(n2);
            this.integerFormatter.setParseIntegerOnly(true);
            this.setValue(n);
        }

        public int getValue() {
            int n = 0;
            try {
                n = this.integerFormatter.parse(this.getText()).intValue();
            }
            catch (ParseException parseException) {
                this.toolkit.beep();
            }
            return n;
        }

        public void setValue(int n) {
            this.setText(this.integerFormatter.format(n));
        }

        protected Document createDefaultModel() {
            return new WholeNumberDocument();
        }

        protected class WholeNumberDocument
        extends PlainDocument {
            protected WholeNumberDocument() {
            }

            public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
                char[] cArray = string.toCharArray();
                char[] cArray2 = new char[cArray.length];
                int n2 = 0;
                for (int i = 0; i < cArray2.length; ++i) {
                    if (Character.isDigit(cArray[i])) {
                        cArray2[n2++] = cArray[i];
                        continue;
                    }
                    WholeNumberField.this.toolkit.beep();
                }
                super.insertString(n, new String(cArray2, 0, n2), attributeSet);
                WholeNumberField.this.postActionEvent();
            }
        }
    }
}

