/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.taskdefs.condition.Condition;
import org.apache.tools.ant.types.FileSet;

public class Checksum
extends MatchingTask
implements Condition {
    private File file = null;
    private String algorithm = "MD5";
    private String provider = null;
    private String fileext;
    private String property;
    private boolean forceOverwrite;
    private String verifyProperty;
    private Vector filesets = new Vector();
    private Hashtable includeFileMap = new Hashtable();
    private MessageDigest messageDigest;
    private boolean isCondition;
    private int readBufferSize = 8192;

    public void setFile(File file) {
        this.file = file;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public void setFileext(String fileext) {
        this.fileext = fileext;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public void setVerifyproperty(String verifyProperty) {
        this.verifyProperty = verifyProperty;
    }

    public void setForceOverwrite(boolean forceOverwrite) {
        this.forceOverwrite = forceOverwrite;
    }

    public void setReadBufferSize(int size) {
        this.readBufferSize = size;
    }

    public void addFileset(FileSet set) {
        this.filesets.addElement(set);
    }

    public void execute() throws BuildException {
        this.isCondition = false;
        boolean value = this.validateAndExecute();
        if (this.verifyProperty != null) {
            this.project.setNewProperty(this.verifyProperty, new Boolean(value).toString());
        }
    }

    public boolean eval() throws BuildException {
        this.isCondition = true;
        return this.validateAndExecute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean validateAndExecute() throws BuildException {
        String savedFileExt = this.fileext;
        if (this.file == null && this.filesets.size() == 0) {
            throw new BuildException("Specify at least one source - a file or a fileset.");
        }
        if (this.file != null && this.file.exists() && this.file.isDirectory()) {
            throw new BuildException("Checksum cannot be generated for directories");
        }
        if (this.property != null && this.fileext != null) {
            throw new BuildException("Property and FileExt cannot co-exist.");
        }
        if (this.property != null) {
            if (this.forceOverwrite) {
                throw new BuildException("ForceOverwrite cannot be used when Property is specified");
            }
            if (this.file != null ? this.filesets.size() > 0 : this.filesets.size() > 1) {
                throw new BuildException("Multiple files cannot be used when Property is specified");
            }
        }
        if (this.verifyProperty != null) {
            this.isCondition = true;
        }
        if (this.verifyProperty != null && this.forceOverwrite) {
            throw new BuildException("VerifyProperty and ForceOverwrite cannot co-exist.");
        }
        if (this.isCondition && this.forceOverwrite) {
            throw new BuildException("ForceOverwrite cannot be used when conditions are being used.");
        }
        this.messageDigest = null;
        if (this.provider != null) {
            try {
                this.messageDigest = MessageDigest.getInstance(this.algorithm, this.provider);
            }
            catch (NoSuchAlgorithmException noalgo) {
                throw new BuildException(noalgo, this.location);
            }
            catch (NoSuchProviderException noprovider) {
                throw new BuildException(noprovider, this.location);
            }
        }
        try {
            this.messageDigest = MessageDigest.getInstance(this.algorithm);
        }
        catch (NoSuchAlgorithmException noalgo) {
            throw new BuildException(noalgo, this.location);
        }
        if (this.messageDigest == null) {
            throw new BuildException("Unable to create Message Digest", this.location);
        }
        if (this.fileext == null) {
            this.fileext = "." + this.algorithm;
        } else if (this.fileext.trim().length() == 0) {
            throw new BuildException("File extension when specified must not be an empty string");
        }
        try {
            this.addToIncludeFileMap(this.file);
            int sizeofFileSet = this.filesets.size();
            int i = 0;
            while (i < sizeofFileSet) {
                FileSet fs = (FileSet)this.filesets.elementAt(i);
                DirectoryScanner ds = fs.getDirectoryScanner(this.project);
                String[] srcFiles = ds.getIncludedFiles();
                int j = 0;
                while (j < srcFiles.length) {
                    File src = new File(fs.getDir(this.project), srcFiles[j]);
                    this.addToIncludeFileMap(src);
                    ++j;
                }
                ++i;
            }
            boolean bl = this.generateChecksums();
            Object var10_13 = null;
            this.fileext = savedFileExt;
            this.includeFileMap.clear();
            return bl;
        }
        catch (Throwable throwable) {
            Object var10_14 = null;
            this.fileext = savedFileExt;
            this.includeFileMap.clear();
            throw throwable;
        }
    }

    private void addToIncludeFileMap(File file) throws BuildException {
        if (file != null) {
            if (file.exists()) {
                if (this.property == null) {
                    File dest = new File(file.getParent(), file.getName() + this.fileext);
                    if (this.forceOverwrite || this.isCondition || file.lastModified() > dest.lastModified()) {
                        this.includeFileMap.put(file, dest);
                    } else {
                        this.log(file + " omitted as " + dest + " is up to date.", 3);
                    }
                } else {
                    this.includeFileMap.put(file, this.property);
                }
            } else {
                String message = "Could not find file " + file.getAbsolutePath() + " to generate checksum for.";
                this.log(message);
                throw new BuildException(message, this.location);
            }
        }
    }

    /*
     * Loose catch block
     */
    private boolean generateChecksums() throws BuildException {
        boolean checksumMatches;
        block23: {
            IOException e32;
            FileOutputStream fos;
            FileInputStream fis;
            block22: {
                checksumMatches = true;
                fis = null;
                fos = null;
                byte[] buf = new byte[this.readBufferSize];
                Enumeration e2 = this.includeFileMap.keys();
                while (e2.hasMoreElements()) {
                    this.messageDigest.reset();
                    File src = (File)e2.nextElement();
                    if (!this.isCondition) {
                        this.log("Calculating " + this.algorithm + " checksum for " + src);
                    }
                    fis = new FileInputStream(src);
                    DigestInputStream dis = new DigestInputStream(fis, this.messageDigest);
                    while (dis.read(buf, 0, this.readBufferSize) != -1) {
                    }
                    dis.close();
                    fis.close();
                    fis = null;
                    byte[] fileDigest = this.messageDigest.digest();
                    StringBuffer checksumSb = new StringBuffer();
                    int i = 0;
                    while (i < fileDigest.length) {
                        String hexStr = Integer.toHexString(0xFF & fileDigest[i]);
                        if (hexStr.length() < 2) {
                            checksumSb.append("0");
                        }
                        checksumSb.append(hexStr);
                        ++i;
                    }
                    String checksum = checksumSb.toString();
                    Object destination = this.includeFileMap.get(src);
                    if (destination instanceof String) {
                        String prop = (String)destination;
                        if (this.isCondition) {
                            checksumMatches = checksum.equals(this.property);
                            continue;
                        }
                        this.project.setNewProperty(prop, checksum);
                        continue;
                    }
                    if (!(destination instanceof File)) continue;
                    if (this.isCondition) {
                        File existingFile = (File)destination;
                        if (existingFile.exists()) {
                            fis = new FileInputStream(existingFile);
                            InputStreamReader isr = new InputStreamReader(fis);
                            BufferedReader br = new BufferedReader(isr);
                            String suppliedChecksum = br.readLine();
                            fis.close();
                            fis = null;
                            br.close();
                            isr.close();
                            checksumMatches = checksum.equals(suppliedChecksum);
                            continue;
                        }
                        checksumMatches = false;
                        continue;
                    }
                    File dest = (File)destination;
                    fos = new FileOutputStream(dest);
                    fos.write(checksum.getBytes());
                    fos.close();
                    fos = null;
                }
                Object var18_18 = null;
                if (fis == null) break block22;
                try {
                    fis.close();
                }
                catch (IOException e32) {
                    // empty catch block
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e32) {}
            }
            break block23;
            {
                catch (Exception e4) {
                    throw new BuildException(e4, this.location);
                }
            }
            catch (Throwable throwable) {
                IOException e32;
                Object var18_19 = null;
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException e32) {
                        // empty catch block
                    }
                }
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException e32) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        return checksumMatches;
    }
}

